# 画面設計書 56-連絡先ページ

## 概要

本ドキュメントは、QuickerSiteの連絡先管理機能における連絡先ページ画面（bs_contactPage.asp）の設計書である。

### 本画面の処理概要

この画面では、個々の会員に対してページ単位の編集権限を付与する。イントラネット会員が特定のページのタイトルや本文を編集できるようにするための、きめ細かな権限管理機能を提供する。

**業務上の目的・背景**：イントラネットやコミュニティサイトでは、一般会員にも一部のコンテンツ編集を許可したい場合がある。本画面は、管理者が各会員に対してページ単位で「タイトル編集」「本文編集」「リストページ編集」の権限を個別に付与できるようにする。これにより、複数の担当者がそれぞれの担当ページを管理する分散型コンテンツ管理が実現できる。

**画面へのアクセス方法**：連絡先ホーム画面（bs_contactHome.asp）の検索結果から、対象会員のパーミッションアイコン（unlock）をクリックしてポップアップで開く。

**主要な操作・処理内容**：
1. 対象会員のニックネーム・メールアドレスの確認
2. 通常サイトのページ一覧からタイトル編集/本文編集権限を選択
3. フリーページ（ルートレベルページ）のタイトル編集/本文編集権限を選択
4. イントラネットページの権限を選択
5. イントラネットのフリーページの権限を選択
6. 権限設定の保存

**画面遷移**：連絡先ホーム画面からポップアップで表示される。保存後はメッセージを表示して画面を維持する。

**権限による表示制御**：secondAdmin.bIntranetContacts権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 83 | コンタクト一覧 | 主機能 | 連絡先一覧ページの表示 |

## 画面種別

設定

## URL/ルーティング

`asp/bs_contactPage.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| iContactID | String | 入力 | 必須 | 連絡先ID（暗号化） |
| bBodyID | Array | 入力 | - | 本文編集権限を付与するページIDの配列 |
| bTitleID | Array | 入力 | - | タイトル編集権限を付与するページIDの配列 |
| bLPID | Array | 入力 | - | リストページ編集権限を付与するページIDの配列 |
| postback | Boolean | 入力 | - | ポストバックフラグ |
| btnaction | String | 入力 | - | アクション種別（save） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| ニックネーム | 対象会員のニックネーム | tblContact.sNickname |
| メールアドレス | 対象会員のメールアドレス | tblContact.sEmail |
| 通常ページ一覧 | 編集可能ページのツリー表示 | cls_menu.getPRMenu |
| フリーページ一覧 | ルートレベルページの一覧 | cls_menu.lossePaginas |
| イントラネットページ一覧 | イントラネット内ページのツリー表示 | cls_menu.getPRMenu |
| イントラネットフリーページ一覧 | イントラネット内フリーページの一覧 | cls_menu.lossePaginas |

## イベント仕様

### 1-保存ボタン押下

選択されたページ権限をデータベースに保存する。保存前に既存の権限設定を全削除し、新たに選択されたものを登録する。保存成功時は「fb_saveOK」メッセージを表示する。また、会員専用のuserfilesフォルダを作成する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblContactPage | SELECT | 現在の権限設定取得 |
| 保存 | tblContactPage | DELETE | 既存権限設定全削除 |
| 保存 | tblContactPage | INSERT | 本文編集権限登録 |
| 保存 | tblContactPage | INSERT | タイトル編集権限登録 |
| 保存 | tblContactPage | INSERT | リストページ権限登録 |

### テーブル別更新項目詳細

#### tblContactPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iContactId=対象ID | 保存前に全削除 |
| INSERT | iContactID | 連絡先ID | |
| INSERT | iBodyID | ページID | 本文編集権限時 |
| INSERT | iTitleID | ページID | タイトル編集権限時 |
| INSERT | iLPID | ページID | リストページ権限時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| fb_saveOK | 成功 | 保存しました | 保存成功時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| フォルダ作成エラー | savePermissions関数がfalseを返す |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- 権限はページ単位で「タイトル編集」「本文編集」「リストページ編集」の3種類を個別に設定できる
- 通常サイトとイントラネットで別々に権限を設定できる
- フリーページ（親ページを持たないルートレベルページ）は別セクションで表示される
- 保存時に会員専用のuserfilesフォルダ（userfiles/{iContactId}）が作成される
- getPRMenuメソッドで階層構造を持つページ一覧をチェックボックス付きで表示する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

権限管理に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | getTPer/getBPer/getLPer関数（行338-382）で現在の権限取得 |
| 1-2 | contact.asp | `asp/includes/contact.asp` | savePermissions関数（行383-426）で権限保存 |

**読解のコツ**: tblContactPageテーブルでiContactIDと各権限タイプ（iTitleID, iBodyID, iLPID）の組み合わせを保存している。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactPage.asp | `asp/bs_contactPage.asp` | メイン画面、権限表示と保存処理 |

**主要処理フロー**:
1. **行4-5**: セキュリティチェック、contactオブジェクト生成
2. **行6-10**: ポストバック時の権限保存処理
3. **行11-17**: btnaction="save"時の保存実行
4. **行18-26**: ページ一覧取得とパーミッション表示
5. **行27-29**: フォーム表示（ページツリーとチェックボックス）

#### Step 3: ページツリー表示を理解する

ページ階層構造の表示ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | menu.asp | `asp/includes/menu.asp` | getPRMenuメソッドでページツリーと権限チェックボックスを生成 |
| 3-2 | menu.asp | `asp/includes/menu.asp` | lossePaginasメソッドでフリーページ一覧を取得 |

### プログラム呼び出し階層図

```
bs_contactPage.asp
    │
    ├─ begin.asp（初期化）
    │      └─ contact.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ cls_contact
    │      ├─ pick()（データ取得）
    │      ├─ getTPer()（タイトル編集権限取得）
    │      ├─ getBPer()（本文編集権限取得）
    │      ├─ getLPer()（リストページ権限取得）
    │      ├─ savePermissions()（権限保存）
    │      └─ createUserFilesFolder()（フォルダ作成）
    │
    └─ cls_menu
           ├─ getPRMenu()（ページツリー生成）
           └─ lossePaginas()（フリーページ取得）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

フォーム入力              bs_contactPage.asp            画面更新
  ├─ bBodyID[]                  │                       │
  ├─ bTitleID[]                 │                       ├─ ページツリー表示
  └─ bLPID[]                    │                       │    ├─ 通常サイト
                                ▼                       │    ├─ フリーページ
tblContactPage ────▶ getTPer/getBPer/getLPer ─────▶    │    ├─ イントラネット
                                │                       │    └─ INTRフリーページ
tblPage ───────────▶ cls_menu.getPRMenu() ─────────▶   │
                                │                       │
                                ├─ savePermissions()    └─ メッセージ
                                │    ├─ DELETE all
                                │    ├─ INSERT bBodyID
                                │    ├─ INSERT bTitleID
                                │    └─ INSERT bLPID
                                │
                                └─ createUserFilesFolder()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactPage.asp | `asp/bs_contactPage.asp` | ソース | メイン画面 |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先クラス（権限管理含む） |
| menu.asp | `asp/includes/menu.asp` | ソース | ページメニュー・ツリー生成 |
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | 遷移元画面 |
