# 画面設計書 57-一括操作

## 概要

本ドキュメントは、QuickerSiteの連絡先管理機能における一括操作画面（bs_contactSelectionActions.asp）の設計書である。

### 本画面の処理概要

この画面では、連絡先ホーム画面で選択された複数の会員に対して一括でメールを送信する機能を提供する。メール本文には会員情報のプレースホルダーを使用でき、パーソナライズされたメールを一斉配信できる。

**業務上の目的・背景**：会員管理において、特定の条件に合致する会員グループへの一斉連絡は重要な業務である。本画面は、検索結果から選択した会員に対してカスタマイズされたメールを効率的に送信するための機能を提供する。過去に送信したメールを再利用する機能も備え、業務効率化を図っている。

**画面へのアクセス方法**：連絡先ホーム画面（bs_contactHome.asp）で会員を検索・選択し、「emailtoselection」リンクをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 選択された会員数の確認
2. 過去に送信したメールの再利用（テンプレート選択）
3. メール件名の入力
4. メール本文の入力（リッチテキストエディタ）
5. 本文背景色の設定
6. CC送信先メールアドレスの入力
7. プレースホルダー（会員情報埋め込み用タグ）の確認・コピー
8. メール送信の実行

**画面遷移**：連絡先ホーム画面から遷移する。送信完了後はフィードバック画面（bs_massMailingFB.asp）にリダイレクトされる。

**権限による表示制御**：secondAdmin.bIntranetContacts権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | 一括メール送信 | 主機能 | 選択した連絡先への一括操作・メール送信 |

## 画面種別

一括処理

## URL/ルーティング

`asp/bs_contactSelectionActions.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| iContactIDM | Array | 入力 | 必須 | 送信対象の連絡先ID配列（暗号化） |
| resendMailID | Number | 入力 | - | 再送用メールテンプレートID |
| sSubject | String | 入力 | 必須 | メール件名 |
| sBody | String | 入力 | 必須 | メール本文（HTML） |
| sBodyBGColor | String | 入力 | - | 本文背景色（デフォルト#FFFFFF） |
| ccEmails | String | 入力 | - | CC送信先（カンマ区切り） |
| postBack | Boolean | 入力 | - | ポストバックフラグ |
| sendBack | Boolean | 入力 | - | 送信実行フラグ |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| N° contacts | 選択された連絡先数 | iContactIDM配列のカウント |
| Resend | 過去のメール一覧（選択用） | tblMail |
| Subject | 件名入力欄 | フォーム入力 |
| Message | 本文入力欄（リッチテキスト） | フォーム入力 |
| Body background-color | 背景色選択 | フォーム入力 |
| CC送信先 | CC入力欄 | フォーム入力 |
| プレースホルダー一覧 | 使用可能なタグ一覧 | カスタムフィールド |

## イベント仕様

### 1-過去メール選択

セレクトボックスで過去のメールを選択すると、確認ダイアログ表示後、そのメールの件名・本文・背景色をフォームに読み込む。

### 2-送信ボタン押下

確認ダイアログを表示後、選択された全連絡先に対してメールを送信する。送信処理中はボタンを無効化し、「Please wait」を表示する。

送信処理（bs_massMailing2.asp）：
- 各連絡先のメールアドレスにメールを送信
- プレースホルダーを会員情報で置換
- 重複送信を防止（contactDictで管理）
- CC指定があれば各メールにCCも送信
- 送信履歴をtblMailとtblMailContactに保存
- 完了後、送信件数をパラメータとしてフィードバック画面にリダイレクト

### 3-プレースホルダークリック

プレースホルダーテキストをクリックすると、テキストが選択状態になりコピーしやすくなる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblMail | SELECT | 過去メール一覧取得 |
| テンプレート選択 | tblMail | SELECT | テンプレート内容取得 |
| 送信実行 | tblMail | INSERT | 送信履歴保存 |
| 送信実行 | tblMailContact | INSERT | 送信先メール保存 |
| 送信実行 | tblContact | SELECT | 連絡先情報取得 |
| 送信実行 | tblContactValues | SELECT | カスタムフィールド値取得 |

### テーブル別更新項目詳細

#### tblMail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sBody | メール本文 | |
| INSERT | sSubject | メール件名 | |
| INSERT | sBodyBGColor | 背景色 | |
| INSERT | dDateSent | now() | 送信日時 |

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iMailID | 保存したメールID | |
| INSERT | sEmail | 送信先メールアドレス | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| areyousure | 確認 | 本当によろしいですか？ | 送信ボタン押下時 |
| pleasewait | 情報 | お待ちください | 送信処理中 |
| err_mandatory | エラー | 必須項目を入力してください | 件名/本文未入力時 |
| warningresend | 警告 | テンプレートを上書きします | テンプレート選択時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 件名未入力 | エラーメッセージを追加 |
| 本文未入力 | エラーメッセージを追加 |
| メール送信エラー | ErrorReportで記録し、次の送信先へ継続 |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- プレースホルダー：[Email]、[各カスタムフィールド名]、[sPw]（パスワード）が使用可能
- チェックボックスタイプのフィールドはプレースホルダーとして使用不可
- CC送信先はカンマ区切りで複数指定可能
- 重複メールアドレスへの送信は1回のみ（contactDictで管理）
- 送信処理はserver.ScriptTimeout=10000で長時間実行に対応
- 日付フィールドはconvertDateToPickerで表示形式に変換

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

一括メール送信に関連するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mail.asp | `asp/includes/mail.asp` | cls_mailクラス、送信履歴の保存 |
| 1-2 | mail_message.asp | `asp/includes/mail_message.asp` | cls_mail_messageクラス、メール送信処理 |

**読解のコツ**: mail.aspは送信履歴管理、mail_message.aspは実際のメール送信を担当している。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactSelectionActions.asp | `asp/bs_contactSelectionActions.asp` | メイン画面、フォーム表示と送信トリガー |

**主要処理フロー**:
1. **行4-7**: セキュリティチェック、変数初期化
2. **行8-23**: ポストバック処理（テンプレート読み込み）
3. **行24-32**: 送信実行判定とバリデーション
4. **行34-49**: フォーム表示、プレースホルダー一覧生成
5. **行41-49**: massHidden関数で選択連絡先IDをhiddenで保持

#### Step 3: 送信処理を理解する

実際のメール送信処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_massMailing2.asp | `asp/bs_massMailing2.asp` | 一括送信処理、プレースホルダー置換 |

**主要処理フロー**:
- **行6-8**: タイムアウト設定、重複防止用Dictionary初期化
- **行20-64**: 連絡先ループ、プレースホルダー置換、メール送信
- **行66-80**: 送信履歴保存（tblMail, tblMailContact）
- **行80**: フィードバック画面へリダイレクト

### プログラム呼び出し階層図

```
bs_contactSelectionActions.asp
    │
    ├─ begin.asp（初期化）
    │      ├─ mail.asp（クラス定義）
    │      └─ mail_message.asp（クラス定義）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ customer.mails（過去メール一覧取得）
    │
    ├─ customer.contactFields()（フィールド定義取得）
    │
    ├─ cls_mail.pick()（テンプレート読み込み時）
    │
    └─ bs_massMailing2.asp（送信実行時）
           │
           ├─ cls_contact.pick()（連絡先情報取得）
           │
           ├─ cls_mail_message.send()（メール送信）
           │
           ├─ cls_mail.save()（送信履歴保存）
           │
           └─ tblMailContact INSERT（送信先保存）
```

### データフロー図

```
[入力]                        [処理]                           [出力]

iContactIDM[]                 bs_contactSelectionActions.asp    フォーム表示
sSubject                            │                              │
sBody                               │                              ├─ 連絡先数
sBodyBGColor                        ▼                              ├─ テンプレート選択
ccEmails                      バリデーション                        ├─ 入力フォーム
                                    │                              └─ プレースホルダー
                                    ▼
tblContact ─────────────▶ bs_massMailing2.asp ───────────▶ メール送信
tblContactValues ─────────▶      │                              │
                                 ├─ プレースホルダー置換          │
                                 ├─ メール送信                    │
                                 │    └─ cls_mail_message       │
                                 ├─ CC送信                       │
                                 └─ 履歴保存                     │
                                      ├─ tblMail                │
                                      └─ tblMailContact         │
                                                                  ▼
                                                        bs_massMailingFB.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactSelectionActions.asp | `asp/bs_contactSelectionActions.asp` | ソース | メイン画面 |
| bs_massMailing2.asp | `asp/bs_massMailing2.asp` | ソース | 一括送信処理 |
| bs_massMailingFB.asp | `asp/bs_massMailingFB.asp` | ソース | 送信完了画面 |
| mail.asp | `asp/includes/mail.asp` | ソース | メール履歴クラス |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| contact.asp | `asp/includes/contact.asp` | ソース | 連絡先クラス |
| contactField.asp | `asp/includes/contactField.asp` | ソース | フィールドクラス |
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | 遷移元画面 |
| ckeditor.asp | `asp/includes/ckeditor.asp` | ソース | リッチテキストエディタ |
