# 画面設計書 58-チケット管理

## 概要

本ドキュメントは、QuickerSiteの連絡先管理機能におけるチケット管理画面（bs_tickets.asp）の設計書である。

### 本画面の処理概要

この画面では、会員登録時に発行されるアクティベーションチケット（登録確認リンク）の管理を行う。未アクティベートの登録リクエストを一覧表示し、再送信や削除の操作を提供する。

**業務上の目的・背景**：会員登録フローにおいて、メールアドレスの実在確認と本人確認のためにアクティベーションリンクを送信する方式が一般的である。本画面は、何らかの理由でアクティベーションが完了していない登録リクエストを管理するための画面である。メールが届かなかった場合の再送信や、不正な登録リクエストの削除が行える。

**画面へのアクセス方法**：連絡先ホーム画面（bs_contactHome.asp）から「pendingactivationlinks」リンクをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 未アクティベートの登録リクエスト一覧表示
2. 登録日時、メールアドレス、訪問者詳細情報の確認
3. アクティベーションリンクの再送信
4. 登録リクエストの削除（単一/複数選択）

**画面遷移**：連絡先ホーム画面から遷移する。再送信後は同じ画面にリダイレクトされる。

**権限による表示制御**：secondAdmin.bIntranetContacts権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | アクティベーション管理 | 主機能 | 会員登録のアクティベーション待ち一覧管理 |

## 画面種別

一覧・管理

## URL/ルーティング

`asp/bs_tickets.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| pageAction | String | 入力 | - | アクション種別（remove/resend） |
| iTicketID | String/Array | 入力 | - | チケットID（暗号化、削除時は配列） |
| fbMessage | String | 入力 | - | フィードバックメッセージキー |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Created on | 登録日時 | tblContactRegistration.dCreatedTS |
| Email | 登録メールアドレス | tblContactRegistration.sEmail |
| Log | 訪問者詳細（IP、ブラウザ等） | tblContactRegistration.sVisitorDetails |
| Delete | 削除チェックボックス | - |
| Resend | 再送信リンク | - |

## イベント仕様

### 1-再送信リンククリック

確認ダイアログを表示後、対象のアクティベーションメールを再送信する。処理後、同じ画面にリダイレクトし「fb_activationlinkresend」メッセージを表示する。

### 2-選択アイテム削除リンククリック

確認ダイアログを表示後、チェックボックスで選択された登録リクエストを一括削除する。フォームをサブミットして削除処理を実行する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblContactRegistration | SELECT | チケット一覧取得 |
| 削除 | tblContactRegistration | DELETE | 選択されたチケット削除 |
| 再送信 | tblContactRegistration | SELECT | チケット情報取得 |

### テーブル別更新項目詳細

#### tblContactRegistration

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | iCustomerID=cId | 一覧取得 |
| DELETE | - | iId=対象ID and iCustomerID=cId | 削除処理 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| areyousure | 確認 | 本当によろしいですか？ | 削除/再送信時 |
| fb_activationlinkresend | 成功 | アクティベーションリンクを再送信しました | 再送信成功時 |
| noresults | 情報 | 結果がありません | チケット0件時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| チケットが存在しない | 「noresults」メッセージを表示 |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- チケットのsVisitorDetailsには、登録時のIP、ブラウザ、言語設定などが保存されている
- splitby関数で長い訪問者詳細を折り返し表示している
- sortableクラスでテーブルの並べ替えが可能
- customer.ticketsプロパティでチケット一覧を取得
- アクティベーションリンクの形式：{siteURL}/default.asp?pageAction=cProfile&ac={sTicket}

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アクティベーションチケットのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ticket.asp | `asp/includes/ticket.asp` | cls_ticketクラス、プロパティ（iId, sEmail, sTicket, sVisitorDetails, dCreatedTS） |

**読解のコツ**: sTicketはランダム生成される一意の文字列で、アクティベーションURLのパラメータとして使用される。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_tickets.asp | `asp/bs_tickets.asp` | メイン画面、削除・再送信処理 |

**主要処理フロー**:
1. **行4**: セキュリティチェック、ヘッダー表示
2. **行5-13**: remove処理（複数チケット削除）
3. **行14-21**: resend処理（アクティベーションメール再送信）
4. **行22**: customer.ticketsでチケット一覧取得
5. **行23-24**: 一覧テーブル表示

#### Step 3: チケットクラスを理解する

チケットの送信・削除処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ticket.asp | `asp/includes/ticket.asp` | sendTicketサブ（行107-115）でメール再送信、removeサブ（行100-106）で削除 |

**主要処理フロー**:
- **行100-106**: remove関数 - tblContactRegistrationから削除
- **行107-115**: sendTicket関数 - アクティベーションメール送信
- **行116-118**: activationlinkプロパティ - URLの生成

### プログラム呼び出し階層図

```
bs_tickets.asp
    │
    ├─ begin.asp（初期化）
    │      └─ ticket.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ cls_ticket
    │      ├─ pick()（データ取得）
    │      ├─ remove()（削除処理）
    │      └─ sendTicket()（アクティベーションメール送信）
    │             └─ cls_mail_message.send()
    │
    └─ customer.tickets（チケット一覧取得）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

QueryString/Form          bs_tickets.asp                HTML一覧
  ├─ pageAction                 │                       │
  └─ iTicketID[]                │                       ├─ 登録日時
                                ▼                       ├─ メールアドレス
tblContactRegistration ─▶ customer.tickets ──────────▶ ├─ 訪問者詳細
                                │                       ├─ 削除チェックボックス
                                ├─ remove() ─────────▶ └─ 再送信リンク
                                │    └─ DELETE
                                │
                                └─ sendTicket() ─────▶ メール送信
                                     └─ cls_mail_message
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_tickets.asp | `asp/bs_tickets.asp` | ソース | メイン画面 |
| ticket.asp | `asp/includes/ticket.asp` | ソース | チケットクラス定義 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信機能 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（ticketsプロパティ） |
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | 遷移元画面 |
| getVisitorDetails.asp | `asp/includes/getVisitorDetails.asp` | ソース | 訪問者詳細取得 |
