# 画面設計書 59-ゲストブック一覧

## 概要

本ドキュメントは、QuickerSiteのゲストブック管理機能におけるゲストブック一覧画面（bs_gbList.asp）の設計書である。

### 本画面の処理概要

この画面では、登録済みのゲストブック（訪問者用の書き込みフォーム）を一覧表示し、各ゲストブックの管理機能へのアクセスを提供する。

**業務上の目的・背景**：ウェブサイトにおいて、訪問者からのコメントや感想を受け付けるゲストブック機能は、コミュニケーションツールとして重要である。本画面は、複数のゲストブックを管理する際の起点となり、各ゲストブックへの編集・エントリー管理・Excel出力等の操作へのハブとして機能する。

**画面へのアクセス方法**：バックサイトにログイン後、メニューから「Guestbook」を選択してアクセスする。

**主要な操作・処理内容**：
1. 登録済みゲストブックの一覧表示
2. 新規ゲストブック作成画面への遷移
3. 既存ゲストブックの編集画面への遷移
4. ゲストブックの複製
5. エントリー（投稿）管理画面への遷移
6. ゲストブックデータのExcel出力
7. 埋め込みコードの表示・コピー

**画面遷移**：バックサイトホームから遷移する。ゲストブック編集画面（bs_gbEdit.asp）、エントリー管理画面（bs_gbEditItems.asp）、Excel出力画面（bs_gbExcel.asp）へ遷移できる。

**権限による表示制御**：secondAdmin.bGuestbook権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | ゲストブック一覧 | 主機能 | 登録済みゲストブックの一覧表示 |
| 62 | ゲストブック作成・編集 | 遷移先機能 | 新規ゲストブック作成画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_gbList.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| iGBID | String | 入力 | - | ゲストブックID（暗号化、複製時） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| ゲストブック名 | ゲストブック名（編集リンク付き） | tblGuestbook.sName |
| コピーアイコン | ゲストブック複製ボタン | - |
| エントリー管理アイコン | 投稿管理画面へのリンク | - |
| Excelアイコン | Excel出力へのリンク | - |
| 埋め込みコード | ページ埋め込み用タグ | [QS_GUESTBOOK:{sCode}] |
| iID | ゲストブックID | tblGuestbook.iId |

## イベント仕様

### 1-ゲストブック名リンククリック

選択したゲストブックの編集画面（bs_gbEdit.asp）へ遷移する。

### 2-新規ゲストブックリンククリック

新規ゲストブック作成画面（bs_gbEdit.asp）へiGBIDパラメータなしで遷移する。

### 3-コピーアイコンクリック

確認ダイアログを表示後、選択したゲストブックを複製する。複製されたゲストブックは新しいsCodeが自動生成され、編集画面にリダイレクトされる。

### 4-エントリー管理アイコンクリック

選択したゲストブックのエントリー管理画面（bs_gbEditItems.asp）へ遷移する。

### 5-Excelアイコンクリック

新しいウィンドウでゲストブックデータのExcel出力画面（bs_gbExcel.asp）を開く。

### 6-埋め込みコードクリック

テキストボックス内の埋め込みコードが選択状態になり、コピーしやすくなる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tblGuestbook | SELECT | ゲストブック一覧取得 |
| 複製 | tblGuestbook | INSERT | ゲストブック複製 |

### テーブル別更新項目詳細

#### tblGuestbook

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | iCustomerID=cId | 一覧取得 |
| INSERT | sCode | GeneratePassword() | 複製時に新しいコード生成 |
| INSERT | その他 | 元のゲストブックの値をコピー | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| areyousuretocopy | 確認 | コピーしてよろしいですか？ | コピーアイコンクリック時 |
| noguestbooks | 情報 | ゲストブックがありません | ゲストブック0件時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ゲストブックが存在しない | 「noguestbooks」メッセージを表示 |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- 埋め込みコード形式：[QS_GUESTBOOK:{sCode}]
- 複製時は新しいsCodeが自動生成される（GeneratePassword関数）
- sCodeはsanitize関数で安全な文字列に変換されて表示
- customer.guestbooksプロパティでゲストブック一覧を取得
- Excel出力は新しいウィンドウで開く

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ゲストブックのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | guestbook.asp | `asp/includes/guestbook.asp` | cls_guestbookクラス、プロパティ（iId, sCode, sName, sTemplate等） |

**読解のコツ**: sCodeはゲストブックを一意に識別するコードで、埋め込みタグに使用される。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbList.asp | `asp/bs_gbList.asp` | メイン画面、複製処理と一覧表示 |

**主要処理フロー**:
1. **行4**: セキュリティチェック、ヘッダー表示
2. **行5-7**: 複製処理（copy関数呼び出し、リダイレクト）
3. **行8-9**: customer.guestbooksでゲストブック一覧取得
4. **行9-10**: 一覧ループ、各アイコン・リンク表示

#### Step 3: 複製処理を理解する

ゲストブックの複製処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | guestbook.asp | `asp/includes/guestbook.asp` | copy関数（行152-158）で複製処理 |

**主要処理フロー**:
- **行152-158**: copy関数 - iIdをnullにしてsCodeを新規生成、save()で保存

### プログラム呼び出し階層図

```
bs_gbList.asp
    │
    ├─ begin.asp（初期化）
    │      └─ guestbook.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ cls_guestbook
    │      └─ copy()（複製処理）
    │             └─ save()
    │
    ├─ customer.guestbooks（ゲストブック一覧取得）
    │
    └─ getIcon()（アイコン表示）
           ├─ copyItem
           ├─ edit（エントリー管理）
           └─ excel
```

### データフロー図

```
[入力]                    [処理]                        [出力]

QueryString               bs_gbList.asp                 HTML一覧
  └─ iGBID                      │                       │
       （複製時）                │                       ├─ ゲストブック名
                                ▼                       ├─ コピーアイコン
tblGuestbook ────────▶ customer.guestbooks ─────────▶ ├─ エントリー管理アイコン
                                │                       ├─ Excelアイコン
                                ├─ copy() ──────────▶   ├─ 埋め込みコード
                                │    └─ INSERT          └─ iID
                                │
                                └─ リダイレクト（複製後）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbList.asp | `asp/bs_gbList.asp` | ソース | メイン画面 |
| guestbook.asp | `asp/includes/guestbook.asp` | ソース | ゲストブッククラス定義 |
| bs_gbEdit.asp | `asp/bs_gbEdit.asp` | ソース | ゲストブック編集画面 |
| bs_gbEditItems.asp | `asp/bs_gbEditItems.asp` | ソース | エントリー管理画面 |
| bs_gbExcel.asp | `asp/bs_gbExcel.asp` | ソース | Excel出力画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（guestbooksプロパティ） |
| showicons.asp | `asp/includes/showicons.asp` | ソース | アイコン表示関数 |
