# 画面設計書 6-管理者ダッシュボード

## 概要

本ドキュメントは、QuickerSite CMSのシステム管理者（Admin）向けダッシュボードについて、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、QuickerSiteのシステム全体を管理するAdmin権限でログインした後に表示されるダッシュボードである。ホスティングされている全顧客サイトの一覧表示、統計情報の確認、サイトの一括削除などの操作が可能である。

**業務上の目的・背景**：QuickerSiteはマルチテナント型CMSとして複数の顧客サイトをホスティングできる。Admin管理者は、各顧客サイトの状態把握、アクセス統計の確認、問題サイトの管理などを一元的に行う必要がある。この画面はその中央管理コンソールとして機能する。

**画面へのアクセス方法**：Admin認証（ad_login.asp）成功後に自動遷移、または `/asp/ad_default.asp` へ直接アクセス（要Admin認証）。

**主要な操作・処理内容**：
1. 顧客サイト一覧を確認する（ID、名前、作成日、URL）
2. 「Show Statistics」リンクで詳細統計モードに切り替える
3. 各サイトの「Visit」リンクでフロントサイトを確認する
4. 各サイトの「Backsite」リンクでバックサイトにアクセスする
5. 「Mail」リンクでウェブマスターにメール送信する
6. サイト名をクリックしてad_customer.aspへ遷移し詳細設定を行う
7. チェックボックスで選択したサイトを一括削除する

**画面遷移**：
- 遷移元：ad_login.asp（Admin認証成功時）
- 遷移先：ad_customer.asp（顧客編集）、各顧客サイトのバックサイト、各顧客サイトのフロントサイト

**権限による表示制御**：Admin認証済みユーザーのみアクセス可能。特定の権限分けはなく、Admin権限を持つユーザーは全機能にアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | ページ一覧 | 主機能 | 顧客サイト一覧・統計情報の表示 |
| 91 | アクセス統計表示 | 補助機能 | サイトアクセス統計の概要表示 |

## 画面種別

ダッシュボード / 一覧画面

## URL/ルーティング

- `/asp/ad_default.asp`
- `/asp/ad_default.asp?showDetail=true`（統計表示モード）

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| 統計表示フラグ | showDetail | QueryString | 文字列 | - | - | "true"で統計モード |
| 削除対象ID | iDeleteID | Checkbox | 数値 | - | - | 複数選択可能 |

## 表示項目

### 通常モード（showDetail=空）

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| Show Statisticsリンク | 上部 | 統計モードへの切り替え |
| サイト総数 | 上部 | JavaScript動的表示 |
| 総ディスク使用量 | 上部 | MB単位で表示 |
| サイト一覧テーブル | メインエリア | ソート可能なテーブル |
| Nr | テーブル列 | 連番 |
| iId | テーブル列 | 顧客ID |
| Date | テーブル列 | 作成日 |
| Name | テーブル列 | サイト名（編集リンク）とURL |
| Visit/Mail | テーブル列 | サイト訪問・メール送信リンク |
| Backsite | テーブル列 | バックサイトへのリンク |
| Delete | テーブル列 | 削除チェックボックス |

### 統計モード（showDetail=true）

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| iId | テーブル列 | 顧客ID |
| Name | テーブル列 | サイト名（編集リンク） |
| Allow Applications | テーブル列 | アプリケーション許可フラグ |
| Visit | テーブル列 | サイト訪問リンク |
| Backsite | テーブル列 | バックサイトへのリンク |
| Hits/day | テーブル列 | 1日あたりのヒット数 |
| Visits/day | テーブル列 | 1日あたりの訪問者数 |
| サーバー統計 | 下部 | 全サイト合計のHits/day、Visits/day |

## イベント仕様

### 1-削除ボタン押下

**処理フロー**：
1. JavaScript confirm()で削除確認ダイアログ表示
2. 確認後、フォームをPOST送信
3. 選択されたiDeleteID配列をループ処理
4. 各顧客のcls_customerオブジェクトをpick
5. remove()メソッドで顧客データを削除
6. 画面リフレッシュ

### 2-サイト名リンクのクリック

**処理フロー**：
1. ad_customer.asp?iId={顧客ID}へ遷移
2. 顧客詳細設定画面が表示される

### 3-Visitリンクのクリック

**処理フロー**：
1. 新しいウィンドウ/タブで顧客サイトのフロントページを開く

### 4-Backsiteリンクのクリック

**処理フロー**：
1. 新しいウィンドウ/タブで顧客サイトのバックサイトを開く
2. getBacksiteURL関数でURL生成

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| サイト削除 | tblCustomer | DELETE | 顧客レコード削除 |
| サイト削除 | tblPage | DELETE | 関連ページ削除 |
| サイト削除 | tblMonitor | DELETE | 関連モニターデータ削除 |
| サイト削除 | その他関連テーブル | DELETE | カスケード削除 |

### テーブル別更新項目詳細

#### tblCustomer（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE iId = {削除対象ID} | 顧客マスタ |

#### tblPage（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE iCustomerID = {削除対象ID} | 全ページ |

#### tblMonitor（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE iCustomerID = {削除対象ID} | 監視データ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| - | 確認 | Are you sure to remove the selected websites? | 削除ボタン押下時 |
| createdaccount | 情報 | アカウント作成完了 | 新規作成後のリダイレクト時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態 | ad_security.aspによりnoaccess.htmへリダイレクト |
| 顧客データ0件 | ad_customer.aspへリダイレクト（新規作成促進） |
| 自サイト削除試行 | チェックボックス非表示により防止 |

## 備考

- テーブルはsortableクラスにより、クライアントサイドでソート可能
- 自身の顧客ID（cId）は削除チェックボックスが表示されず、誤削除を防止
- 統計情報はdResetStatsからの日数で日平均を計算
- aantalDagen（日数）が0の場合は1として計算（ゼロ除算防止）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

顧客管理に関わるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラス、remove関数 |
| 1-2 | customerList.asp | `asp/includes/customerList.asp` | cls_customerListクラス、getAll関数 |

**読解のコツ**: tblCustomerテーブルが顧客マスタ。各顧客に紐づくページ、フォーム、ギャラリー等のデータはiCustomerIDで関連付けられている。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ad_default.asp | `asp/ad_default.asp` | 管理者ダッシュボードのメインファイル |

**主要処理フロー**:
1. **行4**: ad_security.aspによるAdmin認証チェック
2. **行5-10**: iDeleteIDによる削除処理ループ
3. **行11-12**: cls_customerListの初期化
4. **行13**: showDetailパラメータによる表示モード分岐
5. **行17-35**: 通常モードのテーブル出力
6. **行36-53**: 統計モードのテーブル出力

#### Step 3: 削除処理を理解する

顧客削除のロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | remove関数（行570-584） |

**主要処理フロー**:
- **行572**: reset()で関連データクリア
- **行573**: tblMonitor削除
- **行574**: tblPage削除
- **行575**: tblCustomer削除
- **行577-581**: IISサイト削除（コメントアウト）

### プログラム呼び出し階層図

```
ad_default.asp (エントリーポイント)
    │
    ├─ ad_security.asp (Admin認証チェック)
    │
    ├─ 削除処理ループ
    │      ├─ cls_customer.pick()
    │      └─ cls_customer.remove()
    │              ├─ reset() (関連データクリア)
    │              └─ DELETE文実行
    │
    ├─ cls_customerList.getAll() (顧客一覧取得)
    │
    └─ 表示モード分岐
           ├─ 通常モード (一覧表示)
           └─ 統計モード (統計付き表示)
```

### データフロー図

```
[データソース]              [処理]                    [出力]

tblCustomer ─────────▶ customerList.getAll() ──▶ 顧客一覧テーブル
    │                          │
    ├─ iId                     │
    ├─ sName                   ▼
    ├─ sUrl              [通常モード]
    ├─ iFolderSize       ├─ Nr, iId, Date, Name...
    └─ dCreatedTS        │
                         ▼
                   [統計モード]
                   ├─ iTotalHits
                   ├─ iMaxVisits
                   └─ aantalDagen (日数計算)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ad_default.asp | `asp/ad_default.asp` | ソース | 管理者ダッシュボードメイン |
| ad_security.asp | `asp/ad_security.asp` | インクルード | Admin認証チェック |
| customer.asp | `asp/includes/customer.asp` | インクルード | cls_customerクラス |
| customerList.asp | `asp/includes/customerList.asp` | インクルード | cls_customerListクラス |
| functions.asp | `asp/includes/functions.asp` | インクルード | getBacksiteURL等のユーティリティ |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダーHTML |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッターHTML |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト用フッター |
