# 画面設計書 60-ゲストブック編集

## 概要

本ドキュメントは、QuickerSiteのゲストブック管理機能におけるゲストブック編集画面（bs_gbEdit.asp）の設計書である。

### 本画面の処理概要

この画面では、ゲストブックの新規作成・編集・削除を行う。ゲストブックの基本設定、表示テンプレート、投稿承認設定、通知メール設定などを管理できる。

**業務上の目的・背景**：ゲストブックは訪問者との双方向コミュニケーションツールとして機能する。本画面では、ゲストブックの外観（HTMLテンプレート）、動作（承認フロー、ページング）、通知設定などを細かくカスタマイズできる。これにより、サイトのデザインや運用ポリシーに合わせたゲストブックを構築できる。

**画面へのアクセス方法**：ゲストブック一覧画面（bs_gbList.asp）から「newguestbook」リンクまたは既存ゲストブック名をクリックしてアクセスする。

**主要な操作・処理内容**：
1. ゲストブック名の入力
2. 公開期間（開始日・終了日）の設定
3. 埋め込みコードの設定
4. 各種テンプレート（全体、フォーム、エラー、アイテム、返信）の編集
5. 表示順序の設定（最新順/古い順）
6. ページング件数の設定
7. 投稿承認設定
8. 承認待ちメッセージの設定
9. 通知メールアドレスの設定
10. ブロックIPの設定
11. ゲストブックの保存
12. ゲストブックの削除

**画面遷移**：ゲストブック一覧画面から遷移する。保存・削除後はゲストブック一覧画面にリダイレクトされる。

**権限による表示制御**：secondAdmin.bGuestbook権限を持つユーザーのみがアクセス可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | ゲストブック作成・編集 | 主機能 | ゲストブックの作成・設定 |

## 画面種別

登録・編集

## URL/ルーティング

`asp/bs_gbEdit.asp`

## 入出力項目

| 項目名 | 型 | 入力/出力 | 必須 | 説明 |
|--------|-----|----------|------|------|
| iGBId | String | 入力 | - | ゲストブックID（暗号化、新規時は空） |
| sName | String | 入力 | 必須 | ゲストブック名 |
| dOnlinefrom | Date | 入力 | - | 公開開始日 |
| dOnlineUntil | Date | 入力 | - | 公開終了日 |
| sCode | String | 入力 | 必須 | 埋め込みコード識別子 |
| sFullTemplate | String | 入力 | 必須 | 全体テンプレート |
| sTemplateForm | String | 入力 | 必須 | 入力フォームテンプレート |
| sTemplateErr | String | 入力 | 必須 | エラーテンプレート |
| sTemplate | String | 入力 | 必須 | アイテムテンプレート |
| sTemplateReply | String | 入力 | 必須 | 返信テンプレート |
| sSortby | String | 入力 | - | 表示順序（recentfirst/空） |
| iPaging | Number | 入力 | 必須 | 1ページあたりの表示件数 |
| bRequireValidation | Boolean | 入力 | - | 投稿承認が必要か |
| sWarningApproval | String | 入力 | - | 承認待ちメッセージ |
| sEmail | String | 入力 | - | 通知メールアドレス |
| sBlockIP | String | 入力 | - | ブロックIPリスト（改行区切り） |
| postBack | Boolean | 入力 | - | ポストバックフラグ |
| btnaction | String | 入力 | - | アクション種別（save/delete） |

## 表示項目

| 項目名 | 説明 | データソース |
|--------|------|-------------|
| Name | ゲストブック名入力欄 | tblGuestbook.sName |
| Open from/untill | 公開期間設定 | tblGuestbook.dOnlineFrom/dOnlineUntil |
| Code | 埋め込みコード | tblGuestbook.sCode |
| Full template | 全体テンプレート | tblGuestbook.sFullTemplate |
| Template form | 入力フォームテンプレート | tblGuestbook.sTemplateForm |
| Template error | エラーテンプレート | tblGuestbook.sTemplateErr |
| Template Item | アイテムテンプレート | tblGuestbook.sTemplate |
| Template Reply | 返信テンプレート | tblGuestbook.sTemplateReply |
| Show entries | 表示順序選択 | tblGuestbook.sSortby |
| Show entries by | ページング件数 | tblGuestbook.iPaging |
| Entries need validation? | 承認設定 | tblGuestbook.bRequireValidation |
| Note for items to be approved | 承認待ちメッセージ | tblGuestbook.sWarningApproval |
| Send notification email to | 通知メール | tblGuestbook.sEmail |
| Blocked IP | ブロックIPリスト | tblGuestbook.sBlockIP |
| 使用箇所 | ゲストブックが使用されているページ一覧 | fullSearch結果 |

## イベント仕様

### 1-保存ボタン押下

入力値のバリデーションを行い、問題なければデータベースに保存する。バリデーション項目：
- ゲストブック名：必須
- 埋め込みコード：必須

保存成功後はゲストブック一覧画面にリダイレクトする。

### 2-削除ボタン押下

確認ダイアログを表示後、ゲストブックとその全投稿（tblGuestbookItem）を削除する。削除後はゲストブック一覧画面にリダイレクトする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規保存 | tblGuestbook | INSERT | ゲストブック登録 |
| 更新保存 | tblGuestbook | UPDATE | ゲストブック更新 |
| 削除 | tblGuestbookItem | DELETE | 全投稿削除 |
| 削除 | tblGuestbook | DELETE | ゲストブック削除 |

### テーブル別更新項目詳細

#### tblGuestbook

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sCode | 入力値（大文字変換） | |
| INSERT/UPDATE | sName | 入力値 | |
| INSERT/UPDATE | dOnlineFrom | 入力値（日付変換） | |
| INSERT/UPDATE | dOnlineUntil | 入力値（日付変換） | |
| INSERT/UPDATE | sTemplate | 入力値 | |
| INSERT/UPDATE | sTemplateForm | 入力値 | |
| INSERT/UPDATE | sFullTemplate | 入力値 | |
| INSERT/UPDATE | sTemplateReply | 入力値 | |
| INSERT/UPDATE | sTemplateErr | 入力値 | |
| INSERT/UPDATE | bRequireValidation | 入力値 | |
| INSERT/UPDATE | sEmail | 入力値 | |
| INSERT/UPDATE | sWarningApproval | 入力値 | |
| INSERT/UPDATE | sBlockIP | 入力値 | |
| INSERT/UPDATE | sSortBy | 入力値 | |
| INSERT/UPDATE | iPaging | 入力値 | |
| INSERT/UPDATE | iCustomerID | cId | |

#### tblGuestbookItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iGuestbookID=対象ID | ゲストブック削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| err_mandatory | エラー | 必須項目を入力してください | 必須チェック失敗時 |
| areyousure | 確認 | 本当によろしいですか？ | 削除時 |
| whereguestbookused | 情報 | このゲストブックは以下のページで使用されています | 使用箇所表示時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| ゲストブック名未入力 | エラーメッセージを表示し、保存を中止 |
| 埋め込みコード未入力 | エラーメッセージを表示し、保存を中止 |
| 権限不足 | セキュリティチェックでアクセス拒否 |

## 備考

- テンプレートにはプレースホルダーが使用可能：
  - 全体テンプレート：{ITEMS}, {PAGING}, {FORM}
  - フォームテンプレート：{SMILEYS}, {CAPTCHA}, {ID}, {AUTHOR}, {EMAIL}, {MESSAGE}, {TEMPLATEERROR}
  - アイテムテンプレート：{AUTHOR}, {MESSAGE}, {TIMESTAMP}, {TEMPLATEREPLY}, {WARNINGAPPROVAL}
  - 返信テンプレート：{REPLY}
  - エラーテンプレート：{ERROR}
- sCodeは大文字に変換されて保存される
- 公開期間外の場合、入力フォームは非表示になる
- 保存後にfullSearchでゲストブックの使用箇所を検索して表示
- デフォルトテンプレートはClass_Initializeで設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ゲストブックのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | guestbook.asp | `asp/includes/guestbook.asp` | cls_guestbookクラス、全プロパティとデフォルト値（行2-32） |
| 1-2 | guestbookitem.asp | `asp/includes/guestbookitem.asp` | cls_guestbookitemクラス、投稿アイテムの構造 |

**読解のコツ**: Class_Initializeでデフォルトのテンプレートが設定されている（行19-31）。これがゲストブックの初期表示形式となる。

#### Step 2: エントリーポイントを理解する

画面処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbEdit.asp | `asp/bs_gbEdit.asp` | メイン画面、アクション分岐（行11-21） |

**主要処理フロー**:
1. **行4**: セキュリティチェック、ヘッダー表示
2. **行5-6**: guestbookオブジェクト生成
3. **行7-10**: ポストバック時の入力値取得
4. **行11-21**: btnactionに応じた処理分岐（save/delete）
5. **行22-37**: 使用箇所検索と表示

#### Step 3: テンプレート処理を理解する

フロントエンドでのテンプレート展開処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | guestbook.asp | `asp/includes/guestbook.asp` | build関数（行159-284）でテンプレートを展開してHTMLを生成 |

**主要処理フロー**:
- **行159-214**: 入力フォーム処理、CAPTCHA検証、投稿保存
- **行215-260**: 投稿一覧取得とテンプレート適用
- **行261-284**: ページング処理と最終出力生成

### プログラム呼び出し階層図

```
bs_gbEdit.asp
    │
    ├─ begin.asp（初期化）
    │      ├─ guestbook.asp（クラス定義読み込み）
    │      └─ guestbookitem.asp（クラス定義読み込み）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ cls_guestbook
    │      ├─ pick()（データ取得）
    │      ├─ getRequestValues()（フォーム値取得）
    │      ├─ check()（バリデーション）
    │      ├─ save()（保存処理）
    │      └─ remove()（削除処理）
    │
    ├─ cls_fullSearch（使用箇所検索）
    │      └─ search()
    │
    └─ JQDatePicker()（日付選択UI）
```

### データフロー図

```
[入力]                    [処理]                        [出力]

フォーム入力              bs_gbEdit.asp                 リダイレクト
  ├─ sName                      │                       │
  ├─ sCode                      ├─ check() ──────────▶ エラーメッセージ
  ├─ テンプレート各種            │     │
  ├─ 設定項目                    │     ▼
  └─ btnaction                  ├─ save() ──────────▶ tblGuestbook
                                │
                                ├─ remove() ─────────▶ tblGuestbookItem
                                │                      tblGuestbook
                                │
                                └─ fullSearch() ─────▶ 使用箇所表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbEdit.asp | `asp/bs_gbEdit.asp` | ソース | メイン画面 |
| guestbook.asp | `asp/includes/guestbook.asp` | ソース | ゲストブッククラス定義 |
| guestbookitem.asp | `asp/includes/guestbookitem.asp` | ソース | 投稿アイテムクラス定義 |
| fullsearch.asp | `asp/includes/fullsearch.asp` | ソース | 全文検索機能 |
| bs_gbList.asp | `asp/bs_gbList.asp` | ソース | 遷移元・遷移先画面 |
| bs_gbBack.asp | `asp/bs_gbBack.asp` | テンプレート | 戻るリンク表示 |
