# 画面設計書 61-エントリー管理

## 概要

本ドキュメントは、QuickerSiteのゲストブックエントリー管理画面（bs_gbEditItems.asp）の設計仕様を定義するものです。この画面は、ゲストブックに投稿された全エントリー（メッセージ）を一覧表示し、管理者が内容の編集、承認、削除、および返信を行うための機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ウェブサイトのゲストブック機能において、訪問者から寄せられたメッセージを管理者が効率的に管理するために必要な画面です。スパム投稿の除去、不適切なコンテンツの編集、投稿への返信など、コミュニティ管理の中核的な役割を担います。承認制のゲストブックを運用している場合、この画面で投稿を承認しないとフロントエンドに表示されません。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、ゲストブック一覧画面（bs_gbList.asp）から該当ゲストブックを選択し、エントリー管理画面に遷移します。URLパラメータとしてiGBID（暗号化されたゲストブックID）が渡されます。

**主要な操作・処理内容**：
1. ゲストブックに投稿された全エントリーの一覧表示（投稿者名、メッセージ内容、IPアドレス、承認状態）
2. 各エントリーの投稿者名（Author）の編集
3. 各エントリーのメッセージ本文（Message）の編集
4. 管理者からの返信（Reply）の追加・編集
5. 各エントリーの承認/非承認切り替え（チェックボックス）
6. 各エントリーの削除指定（チェックボックス）
7. 一括保存処理（複数エントリーを同時に更新・削除）

**画面遷移**：
- 遷移元：ゲストブック一覧画面（bs_gbList.asp）
- 遷移先：ゲストブック一覧画面（bs_gbList.asp）- 戻るリンク押下時

**権限による表示制御**：secondAdmin.bGuestbook権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | ゲストブック投稿管理 | 主機能 | ゲストブック投稿の承認・編集・削除 |
| 117 | CSRF対策 | 補助機能 | フォーム送信時のセキュリティトークン検証 |

## 画面種別

一覧・編集（一覧形式での一括編集画面）

## URL/ルーティング

`asp/bs_gbEditItems.asp?iGBID={暗号化されたゲストブックID}`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| ゲストブックID | iGBId | hidden | 入力 | 必須 | - | 暗号化されたゲストブックID |
| ポストバックフラグ | postback | hidden | 入力 | 必須 | - | true固定 |
| セキュリティトークン | QS_secCodeHidden | hidden | 入力 | 必須 | - | CSRF対策用 |
| エントリーID | iGBItemID | hidden | 入出力 | 必須 | - | 各エントリーのID |
| 投稿者名 | sAuthor{ID} | text | 入出力 | - | 50 | 投稿者名の編集フィールド |
| メッセージ本文 | sValue{ID} | textarea | 入出力 | - | - | メッセージ本文の編集フィールド |
| 管理者返信 | sReply{ID} | textarea | 入出力 | - | - | 管理者からの返信 |
| 承認フラグ | approve{ID} | checkbox | 入出力 | - | - | trueで承認済み |
| 削除フラグ | remove{ID} | checkbox | 入力 | - | - | trueで削除対象 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| iId | 左列 | エントリーの内部ID |
| IP | 左列 | 投稿者のIPアドレス |
| Author | 中央 | 投稿者名（編集可能） |
| Email | 中央 | 投稿者メールアドレス（リンク表示） |
| Message | 中央 | メッセージ本文（編集可能） |
| Reply by admin | 中央 | 管理者返信（編集可能） |
| Approved | 右列 | 承認状態（チェックボックス） |
| Delete | 右列 | 削除指定（チェックボックス） |

## イベント仕様

### 1-保存ボタン押下

保存ボタン（btnaction）をクリックすると、以下の処理が実行されます：

1. ボタンの二重クリック防止（disabled化）
2. フォームのサブミット
3. サーバー側でCSRFトークン検証（checkCSRF関数）
4. 各エントリーIDについてループ処理：
   - cls_guestbookitemオブジェクトを生成
   - entry.pick(entryID)でデータ取得
   - フォームから取得した値でプロパティを更新
   - 削除フラグがtrueの場合：entry.remove()で削除
   - 削除フラグがfalseの場合：entry.save()で更新
5. 成功メッセージ「fb_saveOK」を表示

### 2-戻るリンク押下

ゲストブック一覧画面（bs_gbList.asp）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下（更新） | tblGuestBookItem | UPDATE | エントリー情報の更新 |
| 保存ボタン押下（削除） | tblGuestBookItem | DELETE | エントリーの削除 |
| 画面表示時 | tblGuestBookItem | SELECT | エントリー一覧の取得 |

### テーブル別更新項目詳細

#### tblGuestBookItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sValue | フォームのsValue{ID}の値 | メッセージ本文 |
| UPDATE | sMessageBy | フォームのsAuthor{ID}の値 | 投稿者名 |
| UPDATE | sReply | フォームのsReply{ID}の値 | 管理者返信 |
| UPDATE | bApproved | フォームのapprove{ID}の値 | 承認フラグ |
| DELETE | - | WHERE iId={entryID} | 行削除 |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 成功 | fb_saveOK | 保存処理完了時 | 保存が完了しました |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| CSRFトークン不正 | checkCSRF関数でエラー処理 |
| エントリーID不正 | convertGetal(entry.iId)<>0の条件で無効なIDはスキップ |
| 権限不足 | logon.hasaccess関数でアクセス拒否 |

## 備考

- エントリーの表示順は作成日時の降順（新しいものが上）
- 削除と更新を同時に指定した場合、削除が優先される
- 管理者返信はフロントエンドでテンプレートに従って表示される
- IPアドレスはスパム対策の参考情報として表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ゲストブックエントリーのデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | guestbookitem.asp | `asp/includes/guestbookitem.asp` | cls_guestbookitemクラスのプロパティ（iId, sValue, sMessageBy, sReply, bApproved等）を確認 |
| 1-2 | guestbook.asp | `asp/includes/guestbook.asp` | cls_guestbookクラスのentriesメソッドでエントリー一覧取得の仕組みを確認 |

**読解のコツ**: ASP/VBScriptでは、クラスのプロパティはPublic宣言で定義されます。entries関数はDictionaryオブジェクトを返し、各エントリーのデータはQS_VBScriptIdentifierで区切られた文字列として格納されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるbs_gbEditItems.aspを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbEditItems.asp | `asp/bs_gbEditItems.asp` | 画面のメイン処理フロー |

**主要処理フロー**:
1. **行4-6**: インクルードファイル読み込みとセキュリティチェック（logon.hasaccess）
2. **行5-6**: cls_guestbookオブジェクト生成
3. **行7-8**: postBackフラグ取得（フォーム送信判定）
4. **行9-27**: postBack=trueの場合、CSRF検証とエントリー更新/削除ループ処理
5. **行28-29**: entries取得と画面表示

#### Step 3: エントリー更新処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | guestbookitem.asp | `asp/includes/guestbookitem.asp` | save関数（行83-138）とremove関数（行139-145）の実装 |

**主要処理フロー**:
- **行95-125**: save関数 - 新規/更新の判定、レコードセット操作
- **行139-145**: remove関数 - DELETEクエリ実行

#### Step 4: セキュリティ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_security.asp | `asp/bs_security.asp` | 認証・認可処理 |

### プログラム呼び出し階層図

```
bs_gbEditItems.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証)
    |
    +-- cls_guestbook (guestbook.asp)
    |       +-- pick() (ゲストブック情報取得)
    |       +-- entries (エントリー一覧取得)
    |
    +-- cls_guestbookitem (guestbookitem.asp)
            +-- pick() (エントリー情報取得)
            +-- save() (エントリー更新)
            +-- remove() (エントリー削除)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iGBID(暗号化)  -----> decrypt() -----> iGuestbookID
                           |
                           v
                    cls_guestbook.pick()
                           |
                           v
                    cls_guestbook.entries
                           |
                           v
                    tblGuestBookItem(SELECT)
                           |
                           v
                    エントリー一覧表示 -----> HTML Table

フォームデータ -----> checkCSRF() -----> 検証OK
    |                      |
    v                      v
sAuthor, sValue   cls_guestbookitem.pick()
sReply, approve         |
remove                  v
    |            save()/remove()
    v                   |
                        v
                 tblGuestBookItem(UPDATE/DELETE)
                        |
                        v
                 Message.Add("fb_saveOK")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbEditItems.asp | `asp/bs_gbEditItems.asp` | ソース | メイン画面処理 |
| guestbook.asp | `asp/includes/guestbook.asp` | ソース | ゲストブッククラス定義 |
| guestbookitem.asp | `asp/includes/guestbookitem.asp` | ソース | ゲストブックアイテムクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
| urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URLエンコード用JavaScript |
