# 画面設計書 62-Excel出力

## 概要

本ドキュメントは、QuickerSiteのゲストブックデータExcel出力機能（bs_gbExcel.asp）の設計仕様を定義するものです。この機能は、指定されたゲストブックの全投稿データをExcel形式のファイルとしてエクスポートし、ダウンロードを提供します。

### 本画面の処理概要

**業務上の目的・背景**：ゲストブックに蓄積された投稿データを外部で分析・保管するために、Excel形式でのデータエクスポート機能が必要です。イベントやキャンペーンで収集したユーザーコメントの集計、バックアップ目的でのデータ保存、他システムへのデータ連携など、多様なビジネスニーズに対応します。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、ゲストブック一覧画面（bs_gbList.asp）または関連画面から、エクスポート機能を呼び出します。URLパラメータとしてiGBID（暗号化されたゲストブックID）が渡されます。

**主要な操作・処理内容**：
1. URLパラメータからゲストブックIDを取得・復号化
2. データベースから該当ゲストブックの全投稿データを取得（ID昇順）
3. HTML形式のテーブルを生成
4. cls_excelfileクラスを使用してExcel形式に変換
5. ユーザーにファイルダウンロードを提供

**画面遷移**：
- 遷移元：ゲストブック一覧画面（bs_gbList.asp）、ゲストブック編集画面（bs_gbEdit.asp）
- 遷移先：ファイルダウンロード（画面遷移なし）

**権限による表示制御**：bs_security.aspによるバックサイトログイン認証が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 64 | ゲストブックExcel出力 | 主機能 | ゲストブック投稿のExcel形式エクスポート |

## 画面種別

処理（ファイルダウンロード）

## URL/ルーティング

`asp/bs_gbExcel.asp?iGBID={暗号化されたゲストブックID}`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|-----|----------|------|------|
| ゲストブックID | iGBID | QueryString | 入力 | 必須 | 暗号化されたゲストブックID |

## 表示項目

本機能はファイルダウンロードのため、画面表示項目はありません。

### 出力ファイル内容

| 列番号 | 項目名 | データソース | 説明 |
|--------|--------|-------------|------|
| 1 | rs(0) | tblGuestBookItem.iId | エントリーID |
| 2 | rs(1) | tblGuestBookItem.iGuestbookID | ゲストブックID |
| 3 | rs(2) | tblGuestBookItem.sMessageBy | 投稿者名 |
| 4 | rs(3) | tblGuestBookItem.sMessageByEmail | 投稿者メールアドレス |
| 5 | rs(4) | tblGuestBookItem.sValue | メッセージ本文 |
| 6 | rs(5) | tblGuestBookItem.dCreatedTS | 作成日時 |

## イベント仕様

### 1-ページアクセス時

ページにアクセスした時点で自動的に以下の処理が実行されます：

1. bs_security.aspでセキュリティ認証チェック
2. iGBIDパラメータを復号化してゲストブックIDを取得
3. SQLクエリでtblGuestBookItemからデータを取得
4. HTMLテーブル形式でデータを構築
5. cls_excelfileオブジェクトを生成
6. export()メソッドでExcel変換
7. redirectLink()メソッドでダウンロードリンクを提供

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページアクセス | tblGuestBookItem | SELECT | ゲストブックエントリーの全件取得 |

### テーブル別更新項目詳細

#### tblGuestBookItem（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iGuestbookID={復号化したID} ORDER BY iId ASC | 全カラム取得 |

## メッセージ仕様

本機能は直接ファイルダウンロードを提供するため、画面メッセージはありません。

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 認証失敗 | bs_security.aspでリダイレクト |
| パラメータ不正 | 復号化失敗時は0として処理（空のExcel出力） |
| データなし | 空のExcelファイルが出力される |

## 備考

- データは内部ID（iId）の昇順で出力される
- Excel出力はcls_excelfileクラスに依存
- HTMLテーブル形式からExcel形式への変換処理を使用
- 大量データの場合、メモリ使用量に注意が必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Excel出力対象となるゲストブックエントリーのデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | guestbookitem.asp | `asp/includes/guestbookitem.asp` | tblGuestBookItemテーブルのカラム構成を確認 |

**読解のコツ**: Pick関数内のrs("カラム名")の記述からテーブル構造を把握できます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbExcel.asp | `asp/bs_gbExcel.asp` | 全体の処理フロー（25行のシンプルなファイル） |

**主要処理フロー**:
1. **行4**: bs_security.aspインクルードで認証チェック
2. **行5**: SQLクエリでデータ取得（iGBIDパラメータを復号化）
3. **行7-19**: HTMLテーブル文字列を構築（gbTable変数）
4. **行21-24**: cls_excelfileでエクスポート・リダイレクト

#### Step 3: Excel出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 要調査 | cls_excelfile定義ファイル | export()とredirectLink()メソッドの実装 |

**読解のコツ**: cls_excelfileクラスはHTMLテーブルをExcel形式に変換するユーティリティクラスです。実装詳細は別途調査が必要です。

### プログラム呼び出し階層図

```
bs_gbExcel.asp
    |
    +-- bs_security.asp (認証チェック)
    |
    +-- db.execute() (データベースクエリ)
    |       +-- tblGuestBookItem (SELECT)
    |
    +-- cls_excelfile
            +-- export() (Excel変換)
            +-- redirectLink() (ダウンロード提供)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iGBID(QueryString) ---> decrypt() ---> iGuestbookID
                              |
                              v
                       SQL SELECT
                              |
                              v
                       tblGuestBookItem
                              |
                              v
                       HTMLテーブル構築
                              |
                              v
                       cls_excelfile.export()
                              |
                              v
                       cls_excelfile.redirectLink()
                              |
                              v
                       Excelファイルダウンロード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbExcel.asp | `asp/bs_gbExcel.asp` | ソース | メイン処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化・共通設定 |
| guestbookitem.asp | `asp/includes/guestbookitem.asp` | ソース | ゲストブックアイテムクラス定義 |
