# 画面設計書 63-投票一覧

## 概要

本ドキュメントは、QuickerSiteの投票（Poll）一覧画面（bs_pollList.asp）の設計仕様を定義するものです。この画面は、サイトに登録された全ての投票機能を一覧表示し、新規作成、編集、複製などの管理操作を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ウェブサイトにインタラクティブな投票機能を追加することで、訪問者の意見収集やエンゲージメント向上を図ります。この一覧画面は、複数の投票を効率的に管理するための中心的な画面として、投票の作成・編集・複製へのアクセスポイントを提供します。投票機能はテンプレートタグ[QS_POLL:コード]でページに埋め込むことができます。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、メインメニューまたはダッシュボードから「投票」セクションを選択することでアクセスします。

**主要な操作・処理内容**：
1. 登録済み投票の一覧表示（質問文、埋め込みコード、内部ID）
2. 新規投票の作成画面への遷移
3. 既存投票の編集画面への遷移
4. 投票の複製（コピー）機能
5. 埋め込み用コード[QS_POLL:コード]のコピー機能

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）、各種管理画面
- 遷移先：投票編集画面（bs_pollEdit.asp）- 新規作成・編集・複製後

**権限による表示制御**：secondAdmin.bPoll権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | 投票（Poll）一覧 | 主機能 | 登録済み投票の一覧表示 |
| 60 | 投票作成・編集 | 遷移先機能 | 新規投票作成画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_pollList.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|-----|----------|------|------|
| 投票ID（複製用） | ipollID | QueryString | 入力 | - | 複製対象の投票ID（暗号化） |
| セキュリティコード | QS_secCodeURL | QueryString | 入力 | - | CSRF対策用（複製時） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 質問文（リンク） | 左列 | 投票の質問文。クリックで編集画面へ遷移 |
| 複製アイコン | 中央 | 投票をコピーするアイコンリンク |
| 埋め込みコード | 中央 | [QS_POLL:コード]形式。クリックで選択可能 |
| 内部ID | 右列 | 投票の内部ID（iID: xxx形式） |

## イベント仕様

### 1-新規投票作成リンク押下

「newpoll」リンクをクリックすると、投票編集画面（bs_pollEdit.asp）に遷移し、新規投票を作成できます。

### 2-投票名（質問文）リンク押下

投票の質問文リンクをクリックすると、該当投票の編集画面（bs_pollEdit.asp?iPollID={暗号化ID}）に遷移します。

### 3-複製アイコン押下

1. 確認ダイアログ「areyousuretocopy」を表示
2. OKの場合、同一ページにリダイレクト（iPollIDパラメータ付き）
3. サーバー側でcls_poll.copy()メソッドを実行
4. 複製された投票の編集画面に自動遷移

### 4-埋め込みコード入力欄クリック

入力欄をクリックすると、JavaScript（this.select()）により全選択され、コピーしやすくなります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblPoll | SELECT | 投票一覧の取得 |
| 複製アイコン押下 | tblPoll | INSERT | 投票の複製 |

### テーブル別更新項目詳細

#### tblPoll（参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iCustomerID={cid} | 顧客に属する全投票 |

#### tblPoll（複製時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全カラム | 元の投票データをコピー | iIdは自動採番 |
| INSERT | sCode | GeneratePassword | 新規ユニークコード生成 |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 確認 | areyousuretocopy | 複製アイコン押下時 | コピーしてもよいですか？ |
| 情報 | nopoll | 投票が0件の場合 | 投票がありません |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 権限不足 | logon.hasaccess関数でアクセス拒否 |
| 投票0件 | 「nopoll」メッセージを表示 |

## 備考

- 投票の埋め込みコード（sCode）が設定されている場合のみ、埋め込みコード入力欄が表示される
- 複製時はsCodeが新規生成され、重複を防止
- 投票結果はこの画面では表示されない（編集画面で確認）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

投票（Poll）のデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | poll.asp | `asp/includes/poll.asp` | cls_pollクラスのプロパティ（iId, sQuestion, sCode, Questions等）を確認 |

**読解のコツ**: Questionsプロパティは最大12個の選択肢を管理するDictionaryオブジェクトです。各選択肢は色（sAnc）とテキスト（sAn）のペアで構成されます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_pollList.asp | `asp/bs_pollList.asp` | 画面のメイン処理フロー（11行のシンプルなファイル） |

**主要処理フロー**:
1. **行4**: セキュリティチェック、権限確認（logon.hasaccess secondAdmin.bPoll）
2. **行5-7**: 複製処理の判定・実行（copyPoll.copy()）
3. **行8-9**: 投票一覧の取得（customer.polls）
4. **行9-10**: 投票一覧のHTML生成（forループ）

#### Step 3: 複製処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | poll.asp | `asp/includes/poll.asp` | copy関数（行381-387） |

**主要処理フロー**:
- **行382**: isNumeriek(iId)で有効なIDかチェック
- **行383**: iId=nullで新規レコード扱いに
- **行384**: sCode=GeneratePasswordで新規コード生成
- **行385**: save()で新規レコードとして保存

### プログラム呼び出し階層図

```
bs_pollList.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証: secondAdmin.bPoll)
    |
    +-- cls_poll (poll.asp)
    |       +-- copy() (投票複製)
    |       +-- pick() (URLパラメータから投票取得)
    |       +-- save() (複製保存)
    |
    +-- customer.polls (投票一覧取得)
            +-- tblPoll (SELECT)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(なし)            ---> customer.polls ---> 投票一覧取得
                              |
                              v
                       tblPoll(SELECT)
                              |
                              v
                       投票一覧表示 ---> HTML Table


ipollID(複製時) ---> decrypt() ---> iPollID
                         |
                         v
                   cls_poll.pick()
                         |
                         v
                   cls_poll.copy()
                         |
                         v
                   tblPoll(INSERT)
                         |
                         v
                   Response.Redirect(編集画面)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_pollList.asp | `asp/bs_pollList.asp` | ソース | メイン画面処理 |
| poll.asp | `asp/includes/poll.asp` | ソース | 投票クラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
