# 画面設計書 64-投票編集

## 概要

本ドキュメントは、QuickerSiteの投票（Poll）編集画面（bs_pollEdit.asp）の設計仕様を定義するものです。この画面は、投票の作成・編集・削除・リセットを行うための機能を提供し、投票の質問文、選択肢（最大12個）、表示期間、ラベル設定などを管理します。

### 本画面の処理概要

**業務上の目的・背景**：ウェブサイトに設置する投票機能の詳細設定を行う画面です。訪問者に対して質問を提示し、複数の選択肢から回答を収集するアンケート形式の機能を構築できます。投票結果はグラフ形式で表示され、各選択肢の色もカスタマイズ可能です。公開期間や投票締切日の設定により、キャンペーン等の期間限定投票にも対応します。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、投票一覧画面（bs_pollList.asp）から新規作成リンクまたは既存投票のリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 投票の質問文（Poll）の設定
2. 最大12個の選択肢（Option）と各選択肢の色の設定
3. 投票タイトル表示の有無設定
4. 投票締切日（Voting deadline）の設定
5. オンライン期間（Online from/until）の設定
6. 埋め込み用コード（Code）の設定
7. 各種ラベル（View Results、Vote Now!、Number of votes）のカスタマイズ
8. 投票結果の表示
9. 投票結果のリセット
10. 投票の削除

**画面遷移**：
- 遷移元：投票一覧画面（bs_pollList.asp）
- 遷移先：投票一覧画面（bs_pollList.asp）- 保存/削除/リセット後

**権限による表示制御**：secondAdmin.bPoll権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | 投票作成・編集 | 主機能 | 投票の作成・選択肢設定 |
| 117 | CSRF対策 | 補助機能 | フォーム送信時のセキュリティトークン検証 |

## 画面種別

登録・編集

## URL/ルーティング

- 新規作成：`asp/bs_pollEdit.asp`
- 編集：`asp/bs_pollEdit.asp?iPollID={暗号化された投票ID}`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| 投票ID | iPollId | hidden | 入力 | - | - | 暗号化された投票ID |
| ポストバックフラグ | postback | hidden | 入力 | 必須 | - | true固定 |
| セキュリティトークン | QS_secCodeHidden | hidden | 入力 | 必須 | - | CSRF対策用 |
| 質問文 | sQuestion | text | 入出力 | 必須 | 255 | 投票の質問文 |
| タイトル表示 | bShowTitle | checkbox | 入出力 | - | - | 投票タイトルを表示するか |
| 投票締切日 | dVoteDeadline | text | 入出力 | - | - | 投票の締切日（日付ピッカー） |
| オンライン開始日 | dVoteFrom | text | 入出力 | - | - | 公開開始日（日付ピッカー） |
| オンライン終了日 | dVoteUntil | text | 入出力 | - | - | 公開終了日（日付ピッカー） |
| コード | sCode | text | 入出力 | 必須 | 45 | 埋め込み用コード |
| View Resultsラベル | label_viewresults | text | 入出力 | 必須 | 255 | 結果表示リンクのラベル |
| Vote Now!ラベル | label_votenow | text | 入出力 | 必須 | 255 | 投票ボタンのラベル |
| Number of votesラベル | label_numberofvotes | text | 入出力 | 必須 | 255 | 投票数表示のラベル |
| 選択肢1-12 | sA1〜sA12 | text | 入出力 | - | 45 | 各選択肢のテキスト |
| 選択肢1-12の色 | sA1c〜sA12c | text | 入出力 | - | - | 各選択肢のグラフ色（カラーピッカー） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 投票結果グラフ | 下部 | 既存投票の場合、選択肢ごとの投票数と割合をグラフ表示 |
| 使用箇所一覧 | 最下部 | 投票が使用されているページの一覧 |

## イベント仕様

### 1-保存ボタン押下

1. フォームをサブミット
2. サーバー側でCSRFトークン検証（checkCSRF）
3. poll.getRequestValues()でフォーム値を取得
4. poll.save()で保存処理
5. 成功時：投票一覧画面（bs_pollList.asp）へリダイレクト
6. 失敗時：エラーメッセージ表示、画面に留まる

### 2-削除ボタン押下

1. 確認ダイアログ「areyousure」を表示
2. OKの場合、フォームをサブミット
3. サーバー側でCSRFトークン検証
4. poll.remove()で削除処理（関連投票データも含む）
5. 投票一覧画面へリダイレクト

### 3-リセットボタン押下

1. 確認ダイアログ「areyousure」を表示
2. OKの場合、フォームをサブミット
3. サーバー側でCSRFトークン検証
4. poll.reset()で投票結果をリセット
5. 投票一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblPoll | SELECT | 投票情報の取得 |
| 保存ボタン押下（新規） | tblPoll | INSERT | 投票の新規作成 |
| 保存ボタン押下（更新） | tblPoll | UPDATE | 投票情報の更新 |
| 削除ボタン押下 | tblPoll | DELETE | 投票の削除 |
| 削除ボタン押下 | tblPollVote | DELETE | 投票結果の削除 |
| リセットボタン押下 | tblPollVote | DELETE | 投票結果の削除 |
| リセットボタン押下 | tblPoll | UPDATE | リセット日時の更新 |
| 使用箇所検索 | テンプレート/ページ | 検索 | 正規表現による使用箇所検索 |

### テーブル別更新項目詳細

#### tblPoll

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sQuestion | フォームのsQuestionの値 | 質問文 |
| INSERT/UPDATE | sCode | フォームのsCodeの値 | 埋め込みコード |
| INSERT/UPDATE | bShowTitle | フォームのbShowTitleの値 | タイトル表示フラグ |
| INSERT/UPDATE | dVoteDeadline | フォームのdVoteDeadlineの値 | 投票締切日 |
| INSERT/UPDATE | dVoteFrom | フォームのdVoteFromの値 | 公開開始日 |
| INSERT/UPDATE | dVoteUntil | フォームのdVoteUntilの値 | 公開終了日 |
| INSERT/UPDATE | label_viewresults | フォームのlabel_viewresultsの値 | 結果表示ラベル |
| INSERT/UPDATE | label_votenow | フォームのlabel_votenowの値 | 投票ボタンラベル |
| INSERT/UPDATE | label_numberofvotes | フォームのlabel_numberofvotesの値 | 投票数ラベル |
| INSERT/UPDATE | sA1〜sA15 | フォームのsA1〜sA15の値 | 選択肢テキスト |
| INSERT/UPDATE | sA1c〜sA15c | フォームのsA1c〜sA15cの値 | 選択肢色 |
| UPDATE | dResetDate | now() | リセット時のみ |
| DELETE | - | WHERE iId={pollID} | 削除時 |

#### tblPollVote

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE iPollID={pollID} | 削除/リセット時 |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 確認 | areyousure | 削除/リセットボタン押下時 | よろしいですか？ |
| エラー | err_mandatory | 必須項目未入力時 | 必須項目を入力してください |
| 情報 | wherepollused | 使用箇所が見つかった場合 | この投票は以下の場所で使用されています |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 権限不足 | logon.hasaccess関数でアクセス拒否 |
| 必須項目未入力 | check関数でfalseを返し、エラーメッセージ表示 |
| CSRFトークン不正 | checkCSRF関数でエラー処理 |

## 備考

- 選択肢の色はJQueryColorPickerで選択可能
- 日付はJQDatePickerを使用（ヨーロッパ形式）
- 使用箇所検索はcls_fullSearchを使用し、正規表現パターン`[QS_POLL:+(code)+[\]]`で検索
- 投票結果のリセット後も、リセット前に投票したユーザーは再投票可能（Cookie/セッションの判定にdResetDateを使用）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

投票（Poll）の完全なデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | poll.asp | `asp/includes/poll.asp` | cls_pollクラスの全プロパティとQuestions辞書の構造 |

**読解のコツ**: Class_Initialize内でデフォルト色（12色）が設定されています。Questions辞書は配列（色、テキスト）を値として持ちます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_pollEdit.asp | `asp/bs_pollEdit.asp` | 画面のメイン処理フロー |

**主要処理フロー**:
1. **行4**: セキュリティチェック、権限確認
2. **行5-6**: cls_pollオブジェクト生成、bCanVote=false設定
3. **行7-11**: postBack判定とgetRequestValues()呼び出し
4. **行12-26**: btnactionによる処理分岐（save/delete/reset）
5. **行28-29**: 選択肢入力フィールドの生成（12個のループ）
6. **行32-42**: 使用箇所検索（cls_fullSearch）

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | poll.asp | `asp/includes/poll.asp` | Save関数（行147-186）、Check関数（行136-146） |

**主要処理フロー**:
- **行136-146**: check() - sQuestion、sCodeの必須チェック
- **行147-186**: save() - 新規/更新判定、レコードセット操作

#### Step 4: 投票結果表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | poll.asp | `asp/includes/poll.asp` | showresults関数（行336-380） |

**主要処理フロー**:
- **行343-353**: 各選択肢の投票数集計（tblPollVoteからCOUNT）
- **行359-376**: HTMLテーブル形式での結果表示生成

### プログラム呼び出し階層図

```
bs_pollEdit.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証: secondAdmin.bPoll)
    |
    +-- cls_poll (poll.asp)
    |       +-- pick() (投票情報取得)
    |       +-- getRequestValues() (フォーム値取得)
    |       +-- check() (入力検証)
    |       +-- save() (保存処理)
    |       +-- remove() (削除処理)
    |       +-- reset() (リセット処理)
    |       +-- showresults() (結果表示)
    |
    +-- cls_fullSearch
    |       +-- search() (使用箇所検索)
    |
    +-- JQDatePicker() (日付ピッカー)
    +-- JQColorPicker() (カラーピッカー)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iPollID(暗号化)  ----> decrypt() -----> iPollID
                            |
                            v
                     cls_poll.pick()
                            |
                            v
                     tblPoll(SELECT)
                            |
                            v
                     フォーム表示 -----> HTML Form


フォームデータ ----> checkCSRF() ----> 検証OK
     |                    |
     v                    v
sQuestion, sCode   cls_poll.getRequestValues()
dVoteFrom等              |
     |                    v
     |              cls_poll.check()
     |                    |
     v                    v
              cls_poll.save()/remove()/reset()
                          |
                          v
                   tblPoll(INSERT/UPDATE/DELETE)
                   tblPollVote(DELETE: reset/delete)
                          |
                          v
                   Response.Redirect(一覧画面)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_pollEdit.asp | `asp/bs_pollEdit.asp` | ソース | メイン画面処理 |
| poll.asp | `asp/includes/poll.asp` | ソース | 投票クラス定義 |
| bs_pollBack.asp | `asp/bs_pollBack.asp` | テンプレート | 投票編集のバック部分 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URLエンコード用JavaScript |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
