# 画面設計書 65-ポップアップ一覧

## 概要

本ドキュメントは、QuickerSiteのポップアップ一覧画面（bs_popupList.asp）の設計仕様を定義するものです。この画面は、サイトに登録された全てのポップアップを一覧表示し、新規作成、編集、複製、プレビュー、表示回数リセットなどの管理操作を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ウェブサイトに表示するポップアップウィンドウを一元管理するための画面です。キャンペーン告知、重要なお知らせ、メールマガジン登録促進など、訪問者の注目を集める情報発信に使用されます。表示頻度の制御（初回のみ、セッションごと、ページロード回数ごと等）により、ユーザー体験を損なわない適切な表示が可能です。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、メインメニューまたはダッシュボードから「ポップアップ」セクションを選択することでアクセスします。

**主要な操作・処理内容**：
1. 登録済みポップアップの一覧表示（名前、表示回数、有効/無効状態、内部ID）
2. 新規ポップアップの作成画面への遷移
3. 既存ポップアップの編集画面への遷移
4. ポップアップの複製（コピー）機能
5. ポップアップのプレビュー表示（別ウィンドウ）
6. 表示回数カウンターのリセット

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）、各種管理画面
- 遷移先：ポップアップ編集画面（bs_popupEdit.asp）- 新規作成・編集・複製後

**権限による表示制御**：secondAdmin.bPopup権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | ポップアップ一覧 | 主機能 | 登録済みポップアップの一覧表示 |
| 66 | ポップアップ作成・編集 | 遷移先機能 | 新規ポップアップ作成画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_popupList.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|-----|----------|------|------|
| ポップアップID（複製用） | ipopupID | QueryString | 入力 | - | 複製対象のポップアップID（暗号化） |
| ポップアップID（リセット用） | i | QueryString | 入力 | - | リセット対象のポップアップID（暗号化） |
| セキュリティコード | QS_secCodeURL | QueryString | 入力 | - | CSRF対策用（複製時） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 名前（リンク） | 左列 | ポップアップ名。クリックで編集画面へ遷移 |
| 表示回数・リセットリンク | 中央 | "(X times shown - reset)"形式で表示 |
| 有効/無効状態 | 中央 | Enabled（太字）またはDisabled（グレー斜体） |
| プレビューアイコン | 右列 | 別ウィンドウでプレビュー表示 |
| 複製アイコン | 右列 | ポップアップをコピーするアイコンリンク |
| 内部ID | 右列 | ポップアップの内部ID（iID: xxx形式） |

## イベント仕様

### 1-新規ポップアップ作成リンク押下

「New Popup」リンクをクリックすると、ポップアップ編集画面（bs_popupEdit.asp）に遷移し、新規ポップアップを作成できます。

### 2-ポップアップ名リンク押下

ポップアップ名リンクをクリックすると、該当ポップアップの編集画面（bs_popupEdit.asp?ipopupID={暗号化ID}）に遷移します。

### 3-複製アイコン押下

1. 確認ダイアログ「areyousuretocopy」を表示
2. OKの場合、同一ページにリダイレクト（ipopupIDパラメータ付き）
3. サーバー側でcls_popup.copy()メソッドを実行
4. 複製されたポップアップの編集画面に自動遷移

### 4-プレビューアイコン押下

JavaScriptでwindow.open()を実行し、新しいウィンドウでポップアップをプレビュー表示します。
- URL: `{C_DIRECTORY_QUICKERSITE}/default.asp?iId={ホームページID}&forcePP={popupKey}`

### 5-リセットリンク押下

1. 同一ページにリダイレクト（iパラメータ付き）
2. サーバー側で該当ポップアップのiShows（表示回数）を0にリセット
3. ポップアップを保存

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblPopup | SELECT | ポップアップ一覧の取得 |
| 複製アイコン押下 | tblPopup | INSERT | ポップアップの複製 |
| リセットリンク押下 | tblPopup | UPDATE | 表示回数のリセット |

### テーブル別更新項目詳細

#### tblPopup（参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iCustomerID={cid} | 顧客に属する全ポップアップ |

#### tblPopup（複製時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全カラム | 元のポップアップデータをコピー | iIdは自動採番 |

#### tblPopup（リセット時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iShows | 0 | 表示回数を0にリセット |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 確認 | areyousuretocopy | 複製アイコン押下時 | コピーしてもよいですか？ |
| 情報 | - | ポップアップが0件の場合 | No Popups available |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 権限不足 | logon.hasaccess関数でアクセス拒否 |
| ポップアップ0件 | 「No Popups available」メッセージを表示 |

## 備考

- 有効状態（bEnabled）がtrueの場合「Enabled」、falseの場合「Disabled」と表示
- 表示回数（iShows）は、ポップアップが実際に表示されるたびにカウントアップされる
- プレビューは現在のホームページにforcePPパラメータを付けて表示する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ポップアップのデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | popup.asp | `asp/includes/popup.asp` | cls_popupクラスのプロパティ（iId, sName, bEnabled, iShows等）を確認 |

**読解のコツ**: iModeプロパティは表示頻度を制御します（0:毎回、1:初回訪問のみ、2:セッション初回、3-10:N回目のページロード時）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_popupList.asp | `asp/bs_popupList.asp` | 画面のメイン処理フロー（17行のシンプルなファイル） |

**主要処理フロー**:
1. **行4**: セキュリティチェック、権限確認（logon.hasaccess secondAdmin.bPopup）
2. **行5-7**: 複製処理の判定・実行（copyPopup.copy()）
3. **行8-12**: リセット処理の判定・実行（iShowsを0に設定）
4. **行14-15**: ポップアップ一覧の取得（customer.popups）
5. **行15-16**: ポップアップ一覧のHTML生成（forループ）

#### Step 3: 複製処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | popup.asp | `asp/includes/popup.asp` | copy関数（行187-192） |

**主要処理フロー**:
- **行188**: isNumeriek(iId)で有効なIDかチェック
- **行189**: iId=nullで新規レコード扱いに
- **行190**: save()で新規レコードとして保存

### プログラム呼び出し階層図

```
bs_popupList.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証: secondAdmin.bPopup)
    |
    +-- cls_popup (popup.asp)
    |       +-- copy() (ポップアップ複製)
    |       +-- pick() (URLパラメータからポップアップ取得)
    |       +-- save() (保存: 複製時/リセット時)
    |
    +-- customer.popups (ポップアップ一覧取得)
    |       +-- tblPopup (SELECT)
    |
    +-- getHomePage (ホームページ情報取得)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(なし)            ---> customer.popups ---> ポップアップ一覧取得
                              |
                              v
                       tblPopup(SELECT)
                              |
                              v
                       一覧表示 ---> HTML Table


ipopupID(複製時) ---> decrypt() ---> iPopupID
                         |
                         v
                   cls_popup.pick()
                         |
                         v
                   cls_popup.copy()
                         |
                         v
                   tblPopup(INSERT)
                         |
                         v
                   Response.Redirect(編集画面)


i(リセット時)    ---> decrypt() ---> iPopupID
                         |
                         v
                   cls_popup.pick()
                         |
                         v
                   iShows = 0
                         |
                         v
                   cls_popup.save()
                         |
                         v
                   tblPopup(UPDATE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_popupList.asp | `asp/bs_popupList.asp` | ソース | メイン画面処理 |
| popup.asp | `asp/includes/popup.asp` | ソース | ポップアップクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
