# 画面設計書 66-ポップアップ編集

## 概要

本ドキュメントは、QuickerSiteのポップアップ編集画面（bs_popupEdit.asp）の設計仕様を定義するものです。この画面は、ポップアップの作成・編集・削除を行うための機能を提供し、ポップアップの名前、URL/テキストコンテンツ、表示設定、サイズ、表示モードなどを管理します。

### 本画面の処理概要

**業務上の目的・背景**：ウェブサイトに表示するポップアップの詳細設定を行う画面です。外部URLをiframeで表示するか、WYSIWYGエディタで作成したHTMLコンテンツを直接表示するかを選択できます。表示モード（頻度）や公開期間、自動クローズ機能など、きめ細かな制御が可能です。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、ポップアップ一覧画面（bs_popupList.asp）から新規作成リンクまたは既存ポップアップのリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. ポップアップ名（Name）の設定
2. 表示URLの設定（外部サイトをiframeで表示）
3. テキストコンテンツの設定（WYSIWYGエディタで作成）
4. 有効/無効（Enabled）の切り替え
5. 表示モード（Mode）の設定（表示頻度の制御）
6. オンライン期間（Online from/until）の設定
7. ポップアップサイズ（Width/Height）の設定
8. 自動クローズ時間（Auto-close after）の設定
9. ポップアップの削除

**画面遷移**：
- 遷移元：ポップアップ一覧画面（bs_popupList.asp）
- 遷移先：ポップアップ一覧画面（bs_popupList.asp）- 保存/削除後

**権限による表示制御**：secondAdmin.bPopup権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 66 | ポップアップ作成・編集 | 主機能 | ポップアップの作成・コンテンツ編集・表示条件設定 |
| 117 | CSRF対策 | 補助機能 | フォーム送信時のセキュリティトークン検証 |

## 画面種別

登録・編集

## URL/ルーティング

- 新規作成：`asp/bs_popupEdit.asp`
- 編集：`asp/bs_popupEdit.asp?ipopupID={暗号化されたポップアップID}`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| ポップアップID | ipopupId | hidden | 入力 | - | - | 暗号化されたポップアップID |
| ポストバックフラグ | postBack | hidden | 入力 | 必須 | - | true固定 |
| セキュリティトークン | QS_secCodeHidden | hidden | 入力 | 必須 | - | CSRF対策用 |
| 名前 | sName | text | 入出力 | 必須 | 50 | ポップアップの名前 |
| URL | sUrl | text | 入出力 | - | 255 | 外部URLまたは空（テキスト使用時） |
| テキスト | sValue | textarea（FCK） | 入出力 | - | - | WYSIWYGエディタでの本文 |
| 有効 | bEnabled | checkbox | 入出力 | - | - | ポップアップを有効にするか |
| モード | iMode | select | 入出力 | - | - | 表示頻度の設定 |
| オンライン開始日 | dOnlineFrom | text | 入出力 | - | - | 公開開始日（日付ピッカー） |
| オンライン終了日 | dOnlineUntil | text | 入出力 | - | - | 公開終了日（日付ピッカー） |
| 幅 | iWidth | select | 入出力 | 必須 | - | 10〜1000pxの選択 |
| 高さ | iHeight | select | 入出力 | 必須 | - | 10〜1000pxの選択 |
| 自動クローズ | iAutoclose | select | 入出力 | - | - | 0〜120秒（0:無効） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| WYSIWYGエディタ | 中央 | FCKEditorによるリッチテキスト編集 |

## イベント仕様

### 1-保存ボタン押下

1. フォームをサブミット
2. サーバー側でCSRFトークン検証（checkCSRF）
3. popup.getRequestValues()でフォーム値を取得
4. popup.check()で入力検証
5. popup.save()で保存処理
6. 成功時：ポップアップ一覧画面（bs_popupList.asp）へリダイレクト
7. 失敗時：エラーメッセージ表示、画面に留まる

### 2-削除ボタン押下

1. 確認ダイアログ「areyousure」を表示
2. OKの場合、フォームをサブミット
3. サーバー側でpopup.remove()を実行
4. ポップアップ一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblPopup | SELECT | ポップアップ情報の取得 |
| 保存ボタン押下（新規） | tblPopup | INSERT | ポップアップの新規作成 |
| 保存ボタン押下（更新） | tblPopup | UPDATE | ポップアップ情報の更新 |
| 削除ボタン押下 | tblPopup | DELETE | ポップアップの削除 |

### テーブル別更新項目詳細

#### tblPopup

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォームのsNameの値 | ポップアップ名 |
| INSERT/UPDATE | sUrl | フォームのsUrlの値 | 外部URL |
| INSERT/UPDATE | sValue | フォームのsValueの値 | HTMLコンテンツ |
| INSERT/UPDATE | bEnabled | フォームのbEnabledの値 | 有効フラグ |
| INSERT/UPDATE | iMode | フォームのiModeの値 | 表示モード |
| INSERT/UPDATE | dOnlineFrom | フォームのdOnlineFromの値 | 公開開始日 |
| INSERT/UPDATE | dOnlineUntil | フォームのdOnlineUntilの値 | 公開終了日 |
| INSERT/UPDATE | iWidth | フォームのiWidthの値 | 幅（px） |
| INSERT/UPDATE | iHeight | フォームのiHeightの値 | 高さ（px） |
| INSERT/UPDATE | iAutoclose | フォームのiAutocloseの値 | 自動クローズ秒数 |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| DELETE | - | WHERE iId={popupID} | 削除時 |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 確認 | areyousure | 削除ボタン押下時 | よろしいですか？ |
| エラー | err_mandatory | 必須項目未入力時 | 必須項目を入力してください |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 権限不足 | logon.hasaccess関数でアクセス拒否 |
| 必須項目未入力 | check関数でfalseを返し、エラーメッセージ表示 |
| URL・テキスト両方未入力 | check関数でfalseを返し、エラーメッセージ表示 |

## 備考

- URLとテキストのどちらか一方は必須（両方空はエラー）
- URLが指定された場合はiframeで外部ページを表示
- テキストのみの場合はColorboxで直接コンテンツを表示
- bNOPopup=trueが設定され、この画面自体でポップアップが表示されないようになっている
- 表示モードはcls_popupModeListで管理

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ポップアップの完全なデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | popup.asp | `asp/includes/popup.asp` | cls_popupクラスの全プロパティ |
| 1-2 | popupModeList.asp | `asp/includes/popupModeList.asp` | 表示モードの選択肢定義 |

**読解のコツ**: iModeの値によって表示頻度が変わります（0:毎回、1:初回訪問のみ、3-10:N回目のページロード時）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_popupEdit.asp | `asp/bs_popupEdit.asp` | 画面のメイン処理フロー |

**主要処理フロー**:
1. **行4**: bNOPopup=true設定（この画面でポップアップ無効化）
2. **行4**: セキュリティチェック、権限確認
3. **行5-6**: cls_popupModeList、cls_popupオブジェクト生成
4. **行9-12**: 削除処理の判定・実行
5. **行13-18**: 保存処理（postBack判定、getRequestValues、checkCSRF、save）

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | popup.asp | `asp/includes/popup.asp` | Save関数（行144-179）、Check関数（行133-143） |

**主要処理フロー**:
- **行133-143**: check() - sName必須、sUrlとsValueの少なくとも一方必須
- **行144-179**: save() - 新規/更新判定、レコードセット操作

#### Step 4: 表示モードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | popupModeList.asp | `asp/includes/popupModeList.asp` | 表示モードの定義 |

**主要処理フロー**:
- **行6-15**: 表示モードの定義（0:毎回、1:初回訪問、3-10:N回目）

### プログラム呼び出し階層図

```
bs_popupEdit.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証: secondAdmin.bPopup)
    |
    +-- cls_popupModeList (popupModeList.asp)
    |       +-- showSelected() (モード選択肢生成)
    |
    +-- cls_popup (popup.asp)
    |       +-- pick() (ポップアップ情報取得)
    |       +-- getRequestValues() (フォーム値取得)
    |       +-- check() (入力検証)
    |       +-- save() (保存処理)
    |       +-- remove() (削除処理)
    |
    +-- createFCKInstance() (WYSIWYGエディタ生成)
    +-- JQDatePicker() (日付ピッカー)
    +-- numberList() (数値選択肢生成)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ipopupID(暗号化) ----> decrypt() -----> iPopupID
                            |
                            v
                     cls_popup.pick()
                            |
                            v
                     tblPopup(SELECT)
                            |
                            v
                     フォーム表示 -----> HTML Form
                                       + FCKEditor


フォームデータ ----> checkCSRF() ----> 検証OK
     |                    |
     v                    v
sName, sUrl,       cls_popup.getRequestValues()
sValue, iMode              |
dOnline*, iSize            v
                     cls_popup.check()
                            |
                            v
                     cls_popup.save()
                            |
                            v
                     tblPopup(INSERT/UPDATE)
                            |
                            v
                     Response.Redirect(一覧画面)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_popupEdit.asp | `asp/bs_popupEdit.asp` | ソース | メイン画面処理 |
| popup.asp | `asp/includes/popup.asp` | ソース | ポップアップクラス定義 |
| popupModeList.asp | `asp/includes/popupModeList.asp` | ソース | 表示モード選択肢 |
| bs_popupBack.asp | `asp/bs_popupBack.asp` | テンプレート | ポップアップ編集のバック部分 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
