# 画面設計書 67-ポップアップモード

## 概要

本ドキュメントは、QuickerSiteのポップアップモード設定画面（bs_popupMode.asp）の設計仕様を定義するものです。この画面は、サイト全体のポップアップ表示エフェクト（見た目）を設定するための機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：ポップアップの見た目（スタイル）をサイト全体で統一的に設定するための画面です。5種類のプリセットスタイルから選択でき、サイトのデザインコンセプトに合わせたポップアップの外観を簡単に設定できます。これはColorboxライブラリのテーマ設定に対応しています。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、設定メニューまたはポップアップ関連の設定画面からアクセスします。

**主要な操作・処理内容**：
1. 5種類のポップアップエフェクトからラジオボタンで選択
2. 選択したエフェクトの保存

**画面遷移**：
- 遷移元：設定メニュー、ポップアップ一覧画面
- 遷移先：同一画面（保存後リダイレクト、成功メッセージ表示）

**権限による表示制御**：バックサイトログイン認証が必要です。（secondAdmin.bTemplates権限のチェックがコメントアウトされている）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | ポップアップ効果設定 | 主機能 | ポップアップの表示エフェクト設定 |

## 画面種別

設定

## URL/ルーティング

`asp/bs_popupMode.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|-----|----------|------|------|
| ポップアップビューモード | sPopupViewmode | radio | 入出力 | 必須 | 1〜5のいずれかを選択 |

### ポップアップエフェクト選択肢

| 値 | エフェクト名 | 説明 |
|---|-------------|------|
| 1 | Dark Rounded Square | 暗い角丸四角形 |
| 2 | Light Square | 明るい四角形 |
| 3 | Dark Square | 暗い四角形 |
| 4 | Light Rounded Square | 明るい角丸四角形 |
| 5 | Gray Square | グレーの四角形 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| エフェクト選択ラジオボタン | 中央 | 5種類のスタイル選択 |
| 保存ボタン | 下部 | 設定を保存 |

## イベント仕様

### 1-保存ボタン押下

1. フォームをサブミット（POST）
2. サーバー側でsPopupViewmodeの値を取得
3. customer.sPopupViewmodeプロパティを更新
4. customer.save()で顧客情報を保存
5. 同一画面にリダイレクト（fbMessage=fb_saveOKパラメータ付き）
6. 成功メッセージを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblCustomer | SELECT | 現在のポップアップモード取得 |
| 保存ボタン押下 | tblCustomer | UPDATE | ポップアップモードの更新 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPopupViewmode | フォームのsPopupViewmodeの値（1〜5） | ポップアップスタイル |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 成功 | fb_saveOK | 保存処理完了時 | 保存が完了しました |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 認証失敗 | バックサイトログイン画面へリダイレクト |

## 備考

- この設定はサイト全体（customer単位）に適用される
- Colorboxライブラリのスタイルに対応
- secondAdmin.bTemplates権限チェックがコメントアウトされているため、バックサイトにログインしていれば誰でもアクセス可能
- getBOHeader、getBOSetupMenuもコメントアウトされている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ポップアップモードの設定がどこに保存されるかを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | popup.asp | `asp/includes/popup.asp` | sGetViewmodeプロパティ（行22-27） |

**読解のコツ**: sPopupViewmodeはcustomerオブジェクト（顧客情報）に保存され、サイト全体で共有されます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_popupMode.asp | `asp/bs_popupMode.asp` | 画面のメイン処理フロー（9行のシンプルなファイル） |

**主要処理フロー**:
1. **行4**: セキュリティチェック（権限チェックはコメントアウト）
2. **行4-7**: フォーム送信判定と保存処理
3. **行8**: ラジオボタンフォームの生成

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_popupMode.asp | `asp/bs_popupMode.asp` | 行4-7の保存処理 |

**主要処理フロー**:
- **行4-5**: sPopupViewmodeが空でない場合に処理
- **行5**: customer.sPopupViewmodeに値を設定
- **行6**: customer.save()で保存
- **行7**: リダイレクト（成功メッセージ付き）

### プログラム呼び出し階層図

```
bs_popupMode.asp
    |
    +-- bs_security.asp (認証チェック)
    |
    +-- customer (顧客オブジェクト)
    |       +-- sPopupViewmode (プロパティ設定)
    |       +-- save() (保存処理)
    |
    +-- フォーム表示
            +-- ラジオボタン x 5
```

### データフロー図

```
[入力]                    [処理]                         [出力]

sPopupViewmode(POST) ---> customer.sPopupViewmode設定
                               |
                               v
                         customer.save()
                               |
                               v
                         tblCustomer(UPDATE)
                               |
                               v
                         Response.Redirect(同画面+fbMessage)


(画面表示時)       ---> customer.sPopupViewmode取得
                               |
                               v
                         ラジオボタン選択状態設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_popupMode.asp | `asp/bs_popupMode.asp` | ソース | メイン画面処理 |
| popup.asp | `asp/includes/popup.asp` | ソース | ポップアップクラス（sGetViewmode参照） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
