# 画面設計書 68-フィード一覧

## 概要

本ドキュメントは、QuickerSiteのRSSフィード一覧画面（bs_feedList.asp）の設計仕様を定義するものです。この画面は、サイトに登録された全てのRSSフィードを一覧表示し、新規作成、編集、複製、プレビューなどの管理操作を提供します。

### 本画面の処理概要

**業務上の目的・背景**：外部サイトのRSSフィードを取り込んでサイトに表示する機能を管理するための画面です。ニュースサイト、ブログ、SNSなどの外部コンテンツを自サイトに統合表示することで、コンテンツの充実化や更新の自動化を実現します。フィードはテンプレートタグ[QS_FEED:コード]でページに埋め込むことができます。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、メインメニューまたはダッシュボードから「フィード」セクションを選択することでアクセスします。

**主要な操作・処理内容**：
1. 登録済みフィードの一覧表示（名前、埋め込みコード、内部ID）
2. 新規フィードの作成画面への遷移
3. 既存フィードの編集画面への遷移
4. フィードの複製（コピー）機能
5. フィードのプレビュー表示
6. 埋め込み用コード[QS_FEED:コード]のコピー機能

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）、各種管理画面
- 遷移先：フィード編集画面（bs_feedEdit.asp）- 新規作成・編集・複製後
- 遷移先：フィードプレビュー画面（bs_feedPreview.asp）- プレビューアイコン押下時

**権限による表示制御**：secondAdmin.bFeed権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | フィード一覧 | 主機能 | 登録済みRSSフィードの一覧表示 |
| 54 | フィード作成・編集 | 遷移先機能 | 新規フィード作成画面への遷移 |
| 55 | フィードプレビュー | 遷移先機能 | フィードプレビュー画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_feedList.asp`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|-----|----------|------|------|
| フィードID（複製用） | iFeedID | QueryString | 入力 | - | 複製対象のフィードID（暗号化） |
| セキュリティコード | QS_secCodeURL | QueryString | 入力 | - | CSRF対策用（複製時） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 名前（リンク） | 左列 | フィード名。クリックで編集画面へ遷移 |
| プレビューアイコン | 中央 | プレビュー画面へ遷移するアイコンリンク |
| 複製アイコン | 中央 | フィードをコピーするアイコンリンク |
| 埋め込みコード | 中央 | [QS_FEED:コード]形式。クリックで選択可能 |
| 内部ID | 右列 | フィードの内部ID（iID: xxx形式） |

## イベント仕様

### 1-新規フィード作成リンク押下

「newfeed」リンクをクリックすると、フィード編集画面（bs_feedEdit.asp）に遷移し、新規フィードを作成できます。

### 2-フィード名リンク押下

フィード名リンクをクリックすると、該当フィードの編集画面（bs_feedEdit.asp?ifeedID={暗号化ID}）に遷移します。

### 3-プレビューアイコン押下

フィードプレビュー画面（bs_feedPreview.asp?ifeedID={暗号化ID}）に遷移します。

### 4-複製アイコン押下

1. 確認ダイアログ「areyousuretocopy」を表示
2. OKの場合、同一ページにリダイレクト（iFeedIDパラメータ付き）
3. サーバー側でcls_feed.copy()メソッドを実行
4. 複製されたフィードの編集画面に自動遷移

### 5-埋め込みコード入力欄クリック

入力欄をクリックすると、JavaScript（this.select()）により全選択され、コピーしやすくなります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblFeed | SELECT | フィード一覧の取得 |
| 複製アイコン押下 | tblFeed | INSERT | フィードの複製 |

### テーブル別更新項目詳細

#### tblFeed（参照）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iCustomerID={cid} | 顧客に属する全フィード |

#### tblFeed（複製時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | 全カラム | 元のフィードデータをコピー | iIdは自動採番 |
| INSERT | sName | "Copy of " + 元のsName | 名前に"Copy of"を付加 |
| INSERT | sCode | 空文字列 | コードは空に設定 |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 確認 | areyousuretocopy | 複製アイコン押下時 | コピーしてもよいですか？ |
| 情報 | nofeed | フィードが0件の場合 | フィードがありません |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 権限不足 | logon.hasaccess関数でアクセス拒否 |
| フィード0件 | 「nofeed」メッセージを表示 |

## 備考

- フィードの埋め込みコード（sCode）が設定されている場合のみ、埋め込みコード入力欄が表示される
- 複製時はsCodeが空に設定され、重複を防止
- 複製時はsNameに"Copy of"が付加される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィードのデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feed.asp | `asp/includes/feed.asp` | cls_feedクラスのプロパティ（iId, sName, sUrl, sCode, iMaxItems等）を確認 |

**読解のコツ**: フィードはRSS/Atom両形式に対応しています。build()メソッドでフィードの取得・パース・キャッシュ処理が行われます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_feedList.asp | `asp/bs_feedList.asp` | 画面のメイン処理フロー（11行のシンプルなファイル） |

**主要処理フロー**:
1. **行4**: セキュリティチェック、権限確認（logon.hasaccess secondAdmin.bFeed）
2. **行5-7**: 複製処理の判定・実行（copyFeed.copy()）
3. **行8-9**: フィード一覧の取得（customer.feeds）
4. **行9-10**: フィード一覧のHTML生成（forループ）

#### Step 3: 複製処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | feed.asp | `asp/includes/feed.asp` | copy関数（行193-200） |

**主要処理フロー**:
- **行194**: isNumeriek(iId)で有効なIDかチェック
- **行195**: iId=nullで新規レコード扱いに
- **行196**: sName="Copy of " + sNameで名前変更
- **行197**: sCode=""でコードを空に
- **行198**: save()で新規レコードとして保存

### プログラム呼び出し階層図

```
bs_feedList.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証: secondAdmin.bFeed)
    |
    +-- cls_feed (feed.asp)
    |       +-- copy() (フィード複製)
    |       +-- pick() (URLパラメータからフィード取得)
    |       +-- save() (複製保存)
    |
    +-- customer.feeds (フィード一覧取得)
            +-- tblFeed (SELECT)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

(なし)            ---> customer.feeds ---> フィード一覧取得
                              |
                              v
                       tblFeed(SELECT)
                              |
                              v
                       一覧表示 ---> HTML Table


iFeedID(複製時)  ---> decrypt() ---> iFeedID
                         |
                         v
                   cls_feed.pick()
                         |
                         v
                   cls_feed.copy()
                         |
                         v
                   tblFeed(INSERT)
                         |
                         v
                   Response.Redirect(編集画面)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_feedList.asp | `asp/bs_feedList.asp` | ソース | メイン画面処理 |
| feed.asp | `asp/includes/feed.asp` | ソース | フィードクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
