# 画面設計書 69-フィード編集

## 概要

本ドキュメントは、QuickerSiteのRSSフィード編集画面（bs_feedEdit.asp）の設計仕様を定義するものです。この画面は、外部RSSフィードの取り込み設定を行うための機能を提供し、フィードのURL、表示件数、キャッシュ時間、カスタムテンプレートなどを管理します。

### 本画面の処理概要

**業務上の目的・背景**：外部サイトのRSS/Atomフィードを自サイトに取り込んで表示するための詳細設定画面です。ニュースアグリゲーション、ソーシャルメディア連携、関連サイトの更新情報表示など、動的なコンテンツ配信を実現します。表示形式のカスタマイズやキャッシュ設定により、パフォーマンスとデザインの両立が可能です。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、フィード一覧画面（bs_feedList.asp）から新規作成リンクまたは既存フィードのリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. フィード名（Name）の設定
2. 埋め込み用コード（Code）の設定
3. フィードURL（URL）の設定（http/https選択）
4. 複数URLの設定（複数フィード統合用）
5. 最大表示件数（Max items）の設定
6. ランダム表示（Show items at random）の設定
7. JavaScriptの有効/無効設定
8. キャッシュ時間（Cache）の設定
9. カスタムテンプレートの使用設定
10. 各種表示オプション（タイトル、日付、著者、カテゴリ等）
11. タイトル・本文の文字数制限設定
12. フィードの削除

**画面遷移**：
- 遷移元：フィード一覧画面（bs_feedList.asp）
- 遷移先：フィード一覧画面（bs_feedList.asp）- 保存/削除後

**権限による表示制御**：secondAdmin.bFeed権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 54 | フィード作成・編集 | 主機能 | 外部RSSフィードの取り込み設定 |
| 117 | CSRF対策 | 補助機能 | フォーム送信時のセキュリティトークン検証 |

## 画面種別

登録・編集

## URL/ルーティング

- 新規作成：`asp/bs_feedEdit.asp`
- 編集：`asp/bs_feedEdit.asp?ifeedID={暗号化されたフィードID}`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 最大長 | 説明 |
|--------|--------|-----|----------|------|--------|------|
| フィードID | ifeedId | hidden | 入力 | - | - | 暗号化されたフィードID |
| ポストバックフラグ | postback | hidden | 入力 | 必須 | - | true固定 |
| セキュリティトークン | QS_secCodeHidden | hidden | 入力 | 必須 | - | CSRF対策用 |
| 名前 | sName | text | 入出力 | 必須 | 255 | フィードの名前 |
| コード | sCode | text | 入出力 | - | 45 | 埋め込み用コード |
| URLプレフィックス | sPrefixUrl | select | 入出力 | - | - | http:// または https:// |
| URL | sUrl | text | 入出力 | 必須 | 255 | フィードのURL（プレフィックス除く） |
| 複数URL | sUrls | textarea | 入出力 | - | - | 複数フィードURL（改行区切り） |
| 最大件数 | iMaxItems | select | 入出力 | - | - | 1〜100の選択 |
| ランダム表示 | bRandom | checkbox | 入出力 | - | - | ランダム順で表示 |
| JavaScript有効 | bEnableJS | checkbox | 入出力 | - | - | コンテンツ内JSを有効化 |
| キャッシュ | iCache | select | 入出力 | - | - | 0〜14400秒（30秒刻み） |
| カスタムテンプレート使用 | bTemplate | checkbox | 入出力 | - | - | カスタムテンプレートを使用 |
| タイトル表示 | bShowTitle | checkbox | 入出力 | - | - | アイテムタイトルを表示 |
| タイトルリンク | bLinkOnTitle | checkbox | 入出力 | - | - | タイトルをリンク化 |
| 新しいウィンドウで開く | bOpenLinkInNW | checkbox | 入出力 | - | - | リンクを新規ウィンドウで開く |
| 日付表示 | bShowDate | checkbox | 入出力 | - | - | 日付を表示 |
| 著者表示 | bShowAuthor | checkbox | 入出力 | - | - | 著者情報を表示 |
| カテゴリ表示 | bShowCategory | checkbox | 入出力 | - | - | カテゴリを表示 |
| テンプレート前HTML | sHTMLBefore | text | 入出力 | - | 254 | テンプレート使用時の前部HTML |
| テンプレート | sTemplate | textarea | 入出力 | - | - | カスタムテンプレート |
| テンプレート後HTML | sHTMLAfter | text | 入出力 | - | 254 | テンプレート使用時の後部HTML |
| タイトル文字数制限 | iTitleLimitTo | select | 入出力 | - | - | 0〜100（0:無制限） |
| 本文文字数制限 | iLimitTo | select | 入出力 | - | - | 0〜2500または「表示しない」 |

### テンプレート変数

| 変数 | 説明 |
|------|------|
| {AUTHOR} | 著者名 |
| {CATEGORY} | カテゴリ |
| {COUNTER} | アイテム番号 |
| {DATE} | 日付 |
| {DESCRIPTION} | 説明文 |
| {IMAGE} | 画像URL |
| {ENCLOSURE} | 添付ファイルURL |
| {LINK} | リンクURL |
| {TITLE} | タイトル |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| テンプレート変数一覧 | 左列 | 使用可能な変数のコピー用入力欄 |
| 使用箇所一覧 | 最下部 | フィードが使用されているページの一覧 |

## イベント仕様

### 1-保存ボタン押下

1. フォームをサブミット
2. サーバー側でCSRFトークン検証（checkCSRF）
3. feed.getRequestValues()でフォーム値を取得
4. feed.check()で入力検証
5. feed.save()で保存処理
6. 成功時：フィード一覧画面（bs_feedList.asp）へリダイレクト
7. 失敗時：エラーメッセージ表示、画面に留まる

### 2-削除ボタン押下

1. 確認ダイアログ「areyousure」を表示
2. OKの場合、フォームをサブミット
3. サーバー側でCSRFトークン検証
4. feed.remove()で削除処理
5. フィード一覧画面へリダイレクト

### 3-カスタムテンプレートチェックボックス変更

チェック状態を変更すると、フォームが自動サブミットされ、表示が切り替わります（テンプレート入力欄の表示/非表示）。

### 4-タイトル表示チェックボックス変更

チェック状態を変更すると、フォームが自動サブミットされ、関連オプション（リンク設定等）の表示が切り替わります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblFeed | SELECT | フィード情報の取得 |
| 保存ボタン押下（新規） | tblFeed | INSERT | フィードの新規作成 |
| 保存ボタン押下（更新） | tblFeed | UPDATE | フィード情報の更新 |
| 削除ボタン押下 | tblFeed | DELETE | フィードの削除 |
| 削除ボタン押下 | tblPage | UPDATE | 関連ページのiFeedIDをnullに |
| 使用箇所検索 | テンプレート/ページ | 検索 | 正規表現による使用箇所検索 |

### テーブル別更新項目詳細

#### tblFeed

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォームのsNameの値 | フィード名 |
| INSERT/UPDATE | sCode | フォームのsCodeの値（大文字変換） | 埋め込みコード |
| INSERT/UPDATE | sPrefixUrl | フォームのsPrefixUrlの値 | http/https |
| INSERT/UPDATE | sUrl | フォームのsUrlの値 | フィードURL |
| INSERT/UPDATE | sUrls | フォームのsUrlsの値 | 複数URL |
| INSERT/UPDATE | iMaxItems | フォームのiMaxItemsの値 | 最大件数 |
| INSERT/UPDATE | bRandom | フォームのbRandomの値 | ランダム表示 |
| INSERT/UPDATE | bEnableJS | フォームのbEnableJSの値 | JS有効 |
| INSERT/UPDATE | iCache | フォームのiCacheの値 | キャッシュ秒数 |
| INSERT/UPDATE | bTemplate | フォームのbTemplateの値 | カスタムテンプレート使用 |
| INSERT/UPDATE | sTemplate | フォームのsTemplateの値 | テンプレートHTML |
| INSERT | dCreatedTS | now() | 作成日時（新規のみ） |
| INSERT/UPDATE | dUpdatedTS | now() | 更新日時 |
| DELETE | - | WHERE iId={feedID} | 削除時 |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| 確認 | areyousure | 削除ボタン押下時 | よろしいですか？ |
| エラー | err_mandatory | 必須項目未入力時 | 必須項目を入力してください |
| エラー | err_doublefeed | コード重複時 | 同じコードのフィードが既に存在します |
| 情報 | wherefeedused | 使用箇所が見つかった場合 | このフィードは以下の場所で使用されています |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 権限不足 | logon.hasaccess関数でアクセス拒否 |
| 必須項目未入力 | check関数でfalseを返し、エラーメッセージ表示 |
| sCode重複 | check関数でfalseを返し、エラーメッセージ表示 |
| CSRFトークン不正 | checkCSRF関数でエラー処理 |
| 自己参照URL | 自サイトのRSSを参照しようとするとエラー |

## 備考

- sUrlとsUrlsのどちらか一方は必須
- sCodeは大文字に自動変換される
- sCodeの重複チェックが行われる（同一顧客内で一意）
- 使用箇所検索はcls_fullSearchを使用し、正規表現パターン`[QS_FEED:+(code)+[\]]`で検索
- キャッシュ設定はアプリケーション変数に保存され、パフォーマンス向上に寄与
- RSS/Atom両形式に対応（自動判定）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィードの完全なデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feed.asp | `asp/includes/feed.asp` | cls_feedクラスの全プロパティとbuild()メソッド |

**読解のコツ**: build()メソッド（行201-497）がフィード取得・パース・表示の中核です。RSS/Atom判定、キャッシュ処理、テンプレート変換が含まれます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_feedEdit.asp | `asp/bs_feedEdit.asp` | 画面のメイン処理フロー |

**主要処理フロー**:
1. **行4**: セキュリティチェック、権限確認
2. **行5-8**: cls_feedオブジェクト生成、postBack判定
3. **行9-20**: btnactionによる処理分岐（save/delete）
4. **行21-22**: cls_urlTypeShortListでプレフィックス選択肢生成
5. **行25-37**: 使用箇所検索（cls_fullSearch）

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | feed.asp | `asp/includes/feed.asp` | Save関数（行96-147）、Check関数（行65-95） |

**主要処理フロー**:
- **行65-95**: check() - sName必須、sUrl/sUrls必須、sCode重複チェック、自己参照チェック
- **行96-147**: save() - 新規/更新判定、レコードセット操作、キャッシュクリア

#### Step 4: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | feed.asp | `asp/includes/feed.asp` | remove関数（行182-192） |

**主要処理フロー**:
- **行185**: 関連ページのiFeedIDをnullに更新
- **行187**: tblFeedから削除
- **行189-190**: キャッシュをクリア

### プログラム呼び出し階層図

```
bs_feedEdit.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証: secondAdmin.bFeed)
    |
    +-- cls_urlTypeShortList
    |       +-- showSelected() (http/https選択肢生成)
    |
    +-- cls_feed (feed.asp)
    |       +-- pick() (フィード情報取得)
    |       +-- getRequestValues() (フォーム値取得)
    |       +-- check() (入力検証)
    |       +-- save() (保存処理)
    |       +-- remove() (削除処理)
    |
    +-- cls_fullSearch
    |       +-- search() (使用箇所検索)
    |
    +-- numberList() (数値選択肢生成)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ifeedID(暗号化)  ----> decrypt() -----> iFeedID
                            |
                            v
                     cls_feed.pick()
                            |
                            v
                     tblFeed(SELECT)
                            |
                            v
                     フォーム表示 -----> HTML Form


フォームデータ ----> checkCSRF() ----> 検証OK
     |                    |
     v                    v
sName, sUrl,       cls_feed.getRequestValues()
sCode, iMaxItems          |
bTemplate等               v
                    cls_feed.check()
                          |
                          v
                    cls_feed.save()
                          |
                          v
                    tblFeed(INSERT/UPDATE)
                          |
                          v
                    customer.cacheFeeds()
                    application(キャッシュクリア)
                          |
                          v
                    Response.Redirect(一覧画面)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_feedEdit.asp | `asp/bs_feedEdit.asp` | ソース | メイン画面処理 |
| feed.asp | `asp/includes/feed.asp` | ソース | フィードクラス定義 |
| bs_feedBack.asp | `asp/bs_feedBack.asp` | テンプレート | フィード編集のバック部分 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
