# 画面設計書 7-ページ作成画面

## 概要

本ドキュメントは、QuickerSite CMSの新規ページ作成画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、サイトに新規ページを追加する際の最初のステップとして、ページタイプを選択する画面である。選択したタイプに応じて、適切な編集画面へ遷移する。

**業務上の目的・背景**：QuickerSiteは複数のページタイプをサポートしており、用途に応じた最適なページ構造を選択できる。この画面はページタイプの選択を明確にし、作成後の手戻りを防ぐことを目的としている。各タイプの説明を表示することで、サイト管理者が適切な選択を行えるようガイドする。

**画面へのアクセス方法**：バックサイトホームの「新規ページ」リンク、または既存ページの子ページ作成から `/asp/bs_setupPage.asp` へアクセス。

**主要な操作・処理内容**：
1. 親ページがある場合、その情報を確認する
2. 利用可能なページタイプから1つを選択する（ラジオボタン）
3. 「Continue」ボタンをクリックして選択を確定する
4. 選択したタイプに応じた編集画面へ自動遷移する

**画面遷移**：
- 遷移元：bs_default.asp（バックサイトホーム）、各ページ編集画面から新規子ページ作成
- 遷移先：bs_editItem.asp（コンテンツ付きアイテム）、bs_editContainer.asp（コンテナ）、bs_editExternalURL.asp（外部URL）、bs_editList.asp（リストページ）、bs_constantEdit.asp（定数）

**権限による表示制御**：secondAdmin.bPagesAddがtrueのユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | 新規ページ作成時のページタイプ選択・設定 |

## 画面種別

選択画面（ウィザード形式のステップ1）

## URL/ルーティング

- `/asp/bs_setupPage.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| 親ページID | iParentID | Hidden | 暗号化数値 | - | - | 親ページのID（暗号化） |
| ボタンアクション | btnaction | Hidden | 文字列 | - | - | 固定値「continue」 |
| イントラネットフラグ | bIntranet | Hidden | Boolean | - | - | イントラネットページかどうか |
| ページタイプ | fixedType | Radio | 数値 | - | 必須 | 選択されたページタイプ |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| BOヘッダー | 上部 | バックサイト共通ヘッダー |
| 親ページ情報 | フォーム上部 | 「Is attached to: {親ページタイトル}」 |
| 選択プロンプト | 中央 | 「Select type of item」 |
| ページタイプ一覧 | メインエリア | ラジオボタン付きタイプ一覧 |
| タイプ名 | 各行 | ページタイプの名称（太字） |
| タイプ説明 | 各行 | ページタイプの詳細説明 |
| Continueボタン | 下部 | 選択確定ボタン |

## イベント仕様

### 1-Continueボタン押下

**処理フロー**：
1. フォームをPOST送信（btnaction="continue"）
2. bs_process.aspで選択されたfixedTypeを判定
3. fixedTypeに応じてリダイレクト先を決定：
   - sb_item (1)：bs_editItem.asp
   - sb_container (2)：bs_editContainer.asp
   - sb_externalURL (3)：bs_editExternalURL.asp
   - sb_list (4)：bs_editList.asp
   - sb_lossePagina (5)：bs_editItem.asp?bLossePagina=true
   - sb_constant (6)：bs_constantEdit.asp
4. iParentIDとbIntranetをパラメータとして渡してリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Continueボタン押下 | なし | - | 本画面ではDB更新なし（選択のみ） |

### テーブル別更新項目詳細

本画面ではデータベースへの更新は行わない。実際のページ作成は遷移先の編集画面で行われる。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| err_makeChoice | エラー | 選択必須エラー | タイプを選択せずにContinue押下 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態 | bs_security.aspによりログイン画面へリダイレクト |
| 権限なし | logon.hasaccess関数によりbs_default.aspへリダイレクト |
| 選択なし | err_makeChoiceエラーメッセージ表示、画面再表示 |

## 備考

- ページタイプ一覧はcls_fixedTypeListクラスから取得される
- 親ページが存在する場合、sb_lossePagina（フリーページ）は選択肢から除外される
- 最初のタイプがデフォルトで選択される（trunner=0の条件）
- イントラネットページの場合、bs_backIntranet.aspがインクルードされる

### ページタイプ一覧

| タイプID | タイプ名 | 説明 |
|---------|---------|------|
| sb_item | Item with content | コンテンツを持つ通常のページ |
| sb_container | Container | 子ページを持つコンテナページ |
| sb_externalUrl | External URL | 外部サイトへのリダイレクト |
| sb_list | List page | リスト形式でアイテムを表示するページ |
| sb_lossePagina | Free page | メニューに属さない独立ページ |
| sb_menugroup | Menu group | メニューグループ |

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページタイプの定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fixedTypeList.asp | `asp/includes/fixedTypeList.asp` | ページタイプ定数と名称の定義 |
| 1-2 | constants.asp | `asp/includes/constants.asp` | sb_item等の定数値 |

**読解のコツ**: cls_fixedTypeListクラスはDictionary形式でタイプID→名称のマッピングを返す。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_setupPage.asp | `asp/bs_setupPage.asp` | ページ作成画面のメインファイル |

**主要処理フロー**:
1. **行4**: bs_security.aspインクルード、hasaccess関数で権限チェック
2. **行4-5**: cls_fixedTypeListの初期化
3. **行6**: 親ページ情報の表示判定
4. **行7-12**: ページタイプのラジオボタン生成ループ
5. **行10**: 親ページありの場合、sb_lossePaginaを除外

#### Step 3: 処理ロジックを理解する

タイプ選択後の遷移ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | case "continue"の処理（行74-92） |

**主要処理フロー**:
- **行76-91**: Select Caseでタイプ別にリダイレクト先を決定
- **行92**: リダイレクト実行（パラメータ付与）

### プログラム呼び出し階層図

```
bs_setupPage.asp (エントリーポイント)
    │
    ├─ bs_security.asp (認証・権限チェック)
    │      └─ logon.hasaccess(secondAdmin.bPagesAdd)
    │
    ├─ cls_fixedTypeList (タイプ一覧取得)
    │      └─ list プロパティでDictionary取得
    │
    ├─ フォーム表示
    │      ├─ 親ページ情報（条件付き）
    │      └─ タイプ別ラジオボタン
    │
    └─ bs_process.asp (POST処理)
           └─ case "continue"
                  └─ タイプ別リダイレクト
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iParentID ────────────▶ 親ページ表示判定 ─────────▶ 親ページ情報表示
                              │
                              ▼
cls_fixedTypeList ────▶ タイプ一覧生成 ───────────▶ ラジオボタン表示
                              │
                              ▼
fixedType選択 ────────▶ bs_process.asp ────────────▶ 編集画面へリダイレクト
                        Select Case判定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_setupPage.asp | `asp/bs_setupPage.asp` | ソース | ページ作成画面メイン |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 遷移処理 |
| fixedTypeList.asp | `asp/includes/fixedTypeList.asp` | インクルード | ページタイプ一覧 |
| constants.asp | `asp/includes/constants.asp` | インクルード | タイプ定数定義 |
| page.asp | `asp/includes/page.asp` | インクルード | 親ページ情報取得 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト用フッター |
| bs_backIntranet.asp | `asp/bs_backIntranet.asp` | テンプレート | イントラネット用戻りリンク |
