# 画面設計書 70-フィードプレビュー

## 概要

本ドキュメントは、QuickerSiteのRSSフィードプレビュー画面（bs_feedPreview.asp）の設計仕様を定義するものです。この画面は、登録されたRSSフィードの実際の表示結果をプレビューするための機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：フィード設定の結果を実際の表示形式で確認するための画面です。フィードURLの有効性、表示件数、テンプレートの適用結果などを公開前に検証できます。これにより、設定ミスによるレイアウト崩れや取得エラーを事前に発見できます。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、フィード一覧画面（bs_feedList.asp）からプレビューアイコンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 指定されたフィードIDに基づくフィード情報の取得
2. 外部RSSフィードの取得・パース
3. 設定されたテンプレート/表示オプションに基づく表示生成
4. プレビュー結果の表示
5. 一覧画面への戻りリンク

**画面遷移**：
- 遷移元：フィード一覧画面（bs_feedList.asp）
- 遷移先：フィード一覧画面（bs_feedList.asp）- 戻るリンク押下時

**権限による表示制御**：secondAdmin.bFeed権限が必要です。この権限がない場合、画面にアクセスできません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | フィードプレビュー | 主機能 | フィード表示のプレビュー |

## 画面種別

プレビュー（参照専用）

## URL/ルーティング

`asp/bs_feedPreview.asp?ifeedID={暗号化されたフィードID}`

## 入出力項目

| 項目名 | 項目ID | 型 | 入力/出力 | 必須 | 説明 |
|--------|--------|-----|----------|------|------|
| フィードID | ifeedID | QueryString | 入力 | 必須 | プレビュー対象のフィードID（暗号化） |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 戻るリンク | 上部・下部 | フィード一覧画面へ戻るリンク |
| フィードプレビュー | 中央 | 実際のフィード表示結果（幅600px） |

## イベント仕様

### 1-戻るリンク押下

フィード一覧画面（bs_feedList.asp）へ遷移します。

### 2-ページ表示時

1. URLパラメータからフィードIDを取得・復号化
2. cls_feedオブジェクトを生成
3. feed.build()メソッドでフィードを取得・パース・表示生成
4. プレビュー結果をHTML出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示時 | tblFeed | SELECT | フィード設定の取得 |

### テーブル別更新項目詳細

この画面はデータベースの更新を行いません（参照のみ）。

#### tblFeed（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iId={復号化したID} AND iCustomerID={cid} | フィード設定取得 |

## メッセージ仕様

| 種別 | メッセージID | 表示条件 | メッセージ内容 |
|------|------------|----------|---------------|
| - | - | - | この画面固有のメッセージはなし |

## 例外処理

| 状況 | 処理内容 |
|------|----------|
| 権限不足 | logon.hasaccess関数でアクセス拒否 |
| フィードID不正 | 空のプレビュー表示 |
| フィードURL取得エラー | build()内でエラーハンドリング（空出力） |

## 備考

- プレビュー表示は幅600pxのテーブル内に表示
- 実際のフィード取得が行われるため、ネットワーク遅延が発生する可能性あり
- キャッシュが有効な場合、キャッシュされたデータが表示される
- フィード取得エラーの詳細はログに記録される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フィードの表示処理を理解するために、build()メソッドを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | feed.asp | `asp/includes/feed.asp` | build()メソッド（行201-497）の処理フロー |

**読解のコツ**: build()メソッドは以下の処理を行います：
1. キャッシュ確認
2. XMLDOMでフィード取得
3. RSS/Atom形式判定
4. アイテムのパース・変換
5. テンプレート適用
6. キャッシュ保存

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_feedPreview.asp | `asp/bs_feedPreview.asp` | 画面のメイン処理フロー（8行の非常にシンプルなファイル） |

**主要処理フロー**:
1. **行4**: セキュリティチェック、権限確認（logon.hasaccess secondAdmin.bFeed）
2. **行4**: 戻るリンクと表示エリアのHTML出力
3. **行5**: cls_feedオブジェクト生成（URLパラメータからpick）
4. **行6**: feed.build()でフィード表示を生成
5. **行7**: feedオブジェクトの解放

#### Step 3: フィード取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | feed.asp | `asp/includes/feed.asp` | build()内のXML取得処理（行258-277） |

**主要処理フロー**:
- **行258-261**: XMLDOMオブジェクト作成・設定
- **行267-277**: フィード読み込みとエラーハンドリング
- **行279-300**: RSS/Atom形式の判定

### プログラム呼び出し階層図

```
bs_feedPreview.asp
    |
    +-- bs_security.asp (認証チェック)
    |       +-- logon.hasaccess (権限検証: secondAdmin.bFeed)
    |
    +-- cls_feed (feed.asp)
            +-- pick() (フィード設定取得)
            +-- build() (フィード表示生成)
                    |
                    +-- キャッシュ確認
                    +-- XMLDOMでフィード取得
                    +-- RSS/Atom判定
                    +-- アイテムパース
                    +-- テンプレート適用
                    +-- キャッシュ保存
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ifeedID(暗号化)  ----> decrypt() -----> iFeedID
                            |
                            v
                     cls_feed.pick()
                            |
                            v
                     tblFeed(SELECT)
                            |
                            v
                     cls_feed.build()
                            |
                            v
                     キャッシュ確認
                            |
                 [キャッシュあり]  [キャッシュなし]
                      |                  |
                      v                  v
                 キャッシュ取得    XMLDOM.Load(外部URL)
                      |                  |
                      |                  v
                      |            RSS/Atomパース
                      |                  |
                      |                  v
                      |            テンプレート適用
                      |                  |
                      |                  v
                      |            キャッシュ保存
                      |                  |
                      +------------------+
                              |
                              v
                       HTML出力 -----> プレビュー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_feedPreview.asp | `asp/bs_feedPreview.asp` | ソース | メイン画面処理 |
| feed.asp | `asp/includes/feed.asp` | ソース | フィードクラス定義（build()含む） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイトヘッダー |
| header.asp | `asp/includes/header.asp` | テンプレート | 共通ヘッダー |
| footer.asp | `asp/includes/footer.asp` | テンプレート | 共通フッター |
