# 画面設計書 71-テンプレート一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるテンプレート一覧画面（bs_templateList.asp）の設計仕様を定義する。

### 本画面の処理概要

テンプレート一覧画面は、サイトのデザインテンプレートを管理するための中央ハブとして機能する。サイト管理者はこの画面を通じて、登録済みテンプレートの一覧表示、新規テンプレート作成、既存テンプレートの編集・複製・削除、デフォルトテンプレートの設定、およびテンプレートのプレビューを行うことができる。

**業務上の目的・背景**：CMSにおいてサイトのデザイン（見た目）を決定するテンプレートは極めて重要な要素である。本画面は、複数のテンプレートを効率的に管理し、サイトの外観を柔軟に切り替えられるようにすることで、サイト運用の効率化とデザインの多様性を実現する。特に、A/Bテストやキャンペーン時のデザイン変更など、ビジネス上のニーズに迅速に対応できる環境を提供する。

**画面へのアクセス方法**：バックサイトにログイン後、ヘッダーメニューの「Setup」から「Template」を選択してアクセスする。管理者権限（secondAdmin.bTemplates）が必要。

**主要な操作・処理内容**：
1. テンプレート一覧の表示 - 登録済みの全テンプレートをリスト形式で表示
2. 新規テンプレート作成 - 「newtemplate」リンクから編集画面へ遷移
3. テンプレート編集 - 各テンプレートの編集アイコンから編集画面へ遷移
4. テンプレートプレビュー - 検索アイコンで新規ウィンドウにプレビュー表示
5. テンプレート複製 - コピーアイコンで既存テンプレートを複製
6. テンプレート削除 - 削除アイコンで確認後にテンプレートを削除
7. デフォルトテンプレート設定 - 「set as default」リンクでデフォルトに指定
8. ZIPテンプレートのアップロード - ZIP形式のテンプレートファイルをインポート
9. オンラインテンプレート検索 - 外部サーバーからテンプレートを検索・インストール
10. カテゴリ別テンプレート閲覧 - ローカルテンプレートをカテゴリ別に表示・インストール

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）、各種設定画面
- 遷移先：テンプレート編集画面（bs_templateEdit.asp）、ZIPアップロード画面（bs_uploadzip.asp）、テンプレート検索画面（bs_templateSearch.asp）

**権限による表示制御**：secondAdmin.bTemplates権限がない場合はアクセス不可。テンプレートが1件以下の場合は削除ボタンが非表示。デフォルトテンプレートには削除ボタンが表示されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | テンプレート一覧 | 主機能 | サイトデザインテンプレートの一覧表示 |
| 26 | テンプレート作成・編集 | 遷移先機能 | テンプレート作成・編集画面への遷移 |
| 30 | デフォルトテンプレート設定 | 補助機能 | デフォルトテンプレートの指定 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_templateList.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| a | 任意 | String | アクション種別（copy/delete/default） |
| itemplateID | 任意 | String | 暗号化されたテンプレートID |
| QS_secCodeURL | 必須 | String | CSRFトークン（アクション実行時） |
| fbMessage | 任意 | String | フィードバックメッセージコード |
| sInstallPath | 任意 | String | インストール対象テンプレートのパス |
| look | 任意 | String | カテゴリ絞り込み用パス |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| カテゴリ選択 | look | Select | - | テンプレートカテゴリの選択 |

### 出力項目（テンプレート一覧）

| 項目名 | 説明 |
|--------|------|
| テンプレート名 | テンプレートの名前（リンク） |
| default表示 | デフォルトテンプレートの場合「(default)」を表示 |
| set as default | デフォルト設定リンク（デフォルト以外のみ表示） |
| 編集アイコン | テンプレート編集画面へのリンク |
| プレビューアイコン | テンプレートプレビューの表示 |
| コピーアイコン | テンプレート複製機能 |
| 削除アイコン | テンプレート削除機能（条件付き表示） |
| iID | テンプレートの内部ID |

## 表示項目

### テンプレート一覧テーブル

| 列名 | データソース | 書式 |
|------|-------------|------|
| テンプレート名 | tblTemplate.sName | リンク形式 |
| ステータス | customer.defaultTemplate との比較 | (default) または (set as default) |
| 編集 | - | アイコンリンク |
| プレビュー | - | アイコンリンク（JavaScript popup） |
| コピー | - | アイコンリンク |
| 削除 | - | アイコンリンク（条件付き） |
| iID | tblTemplate.iId | イタリック表示 |

## イベント仕様

### 1-テンプレート編集リンククリック

テンプレート名または編集アイコンをクリックすると、テンプレート編集画面（bs_templateEdit.asp）に遷移する。暗号化されたテンプレートIDがパラメータとして渡される。

### 2-プレビューアイコンクリック

JavaScriptにより新しいウィンドウでサイトトップページ（default.asp）をプレビューテンプレート指定で表示する。パラメータにはホームページIDと対象テンプレートIDが含まれる。

### 3-コピーアイコンクリック

確認ダイアログ表示後、同ページにa=copyパラメータ付きでリクエストし、cls_templateクラスのcopy()メソッドを呼び出してテンプレートを複製する。複製後は画面がリロードされる。

### 4-削除アイコンクリック

確認ダイアログ表示後、同ページにa=deleteパラメータ付きでリクエストし、cls_templateクラスのremove()メソッドを呼び出してテンプレートを削除する。削除後は画面がリロードされる。

### 5-デフォルト設定リンククリック

同ページにa=defaultパラメータ付きでリクエストし、customerオブジェクトのdefaultTemplateプロパティを更新して保存する。

### 6-新規テンプレート作成リンククリック

テンプレート編集画面（bs_templateEdit.asp）にパラメータなしで遷移し、新規テンプレート作成モードで開く。

### 7-ZIPアップロードリンククリック

ZIPアップロード画面（bs_uploadzip.asp）に遷移する。customer.supportZipperがfalseの場合はリンクが表示されない。

### 8-オンラインテンプレート検索リンククリック

テンプレート検索画面（bs_templateSearch.asp）に遷移する。bBrowseOnlineTemplatesがfalseの場合はリンクが表示されない。

### 9-カテゴリ選択変更

カテゴリ選択プルダウンの変更でフォームが自動送信され、選択したカテゴリのテンプレートが表示される。

### 10-テンプレートインストールリンククリック

ローカルテンプレートの「Install」リンクをクリックすると、installTemplate関数が呼び出され、テンプレートがシステムに登録される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレートコピー | tblTemplate | INSERT | テンプレートレコードを複製 |
| テンプレート削除 | tblTemplate | DELETE | テンプレートレコードを削除 |
| テンプレート削除 | tblPage | UPDATE | 該当テンプレートを参照するページのiTemplateIDをnullに |
| テンプレート削除 | tblCustomer | UPDATE | デフォルトテンプレート参照を解除 |
| デフォルト設定 | tblCustomer | UPDATE | defaultTemplateフィールドを更新 |
| テンプレートインストール | tblTemplate | INSERT | 新規テンプレートレコードを作成 |

### テーブル別更新項目詳細

#### tblTemplate

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT（コピー時） | iId | 自動採番 | 新規レコードID |
| INSERT（コピー時） | sName | "Copy of " + 元sName | 複製テンプレート名 |
| INSERT（コピー時） | sValue | 元sValue | HTMLテンプレート本体 |
| INSERT（コピー時） | iCustomerID | cId | 顧客ID |
| DELETE | - | iId = 指定ID | テンプレート削除 |

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iTemplateID | null | 削除対象テンプレートを使用していたページのテンプレート参照を解除 |

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | defaultTemplate | テンプレートID or null | デフォルトテンプレートの設定・解除 |
| UPDATE | iDefaultMobileTemplate | null | モバイルテンプレート参照の解除（削除時） |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| fb_templateadded | 成功 | テンプレートインストール完了時 | テンプレートが追加されました |
| areyousuretocopy | 確認 | コピー実行前 | コピーしてもよろしいですか？ |
| areyousure | 確認 | 削除実行前 | 削除してもよろしいですか？ |
| notemplate | 情報 | テンプレートが0件の場合 | テンプレートがありません |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| CSRFトークン不正 | checkCSRF()によりエラー |
| テンプレート1件以下で削除試行 | 削除ボタン非表示により防止 |
| デフォルトテンプレートの削除試行 | 削除ボタン非表示により防止 |
| ZIPコンポーネント未インストール | ZIPアップロードリンク非表示、代替メッセージ表示 |
| テンプレートフォルダ不存在 | フォルダ作成を試行 |

## 備考

- テンプレートはArtisteer（デザインツール）やJSTemplates.comで作成したものをインポート可能
- テンプレートの圧縮機能（bCompress）により、本番環境でのパフォーマンス向上が可能
- テンプレートには通常版、印刷版、メール版、モバイル版、WAP版の5種類のバリエーションが存在
- オンラインテンプレート検索機能はbBrowseOnlineTemplates設定により有効化される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレートの基本構造を理解することが重要。cls_templateクラスがテンプレートのデータ構造とビジネスロジックを担当している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | template.asp | `asp/includes/template.asp` | cls_templateクラスの定義。プロパティ（iId, sName, sValue等）とメソッド（pick, save, copy, remove等）を確認 |

**読解のコツ**: ASP/VBScriptではクラスの定義がClass...End Classで行われる。プロパティはPublic/Privateで宣言され、Property Get/Letで定義される。

#### Step 2: エントリーポイントを理解する

テンプレート一覧画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateList.asp | `asp/bs_templateList.asp` | 画面のメインロジック。アクション処理、テンプレート一覧表示、各種機能へのリンク生成 |

**主要処理フロー**:
1. **行1-4**: セキュリティチェック（bs_security.asp）とヘッダーインクルード
2. **行4-18**: アクションパラメータによる処理分岐（copy/delete/default）
3. **行19-26**: テンプレート一覧の取得と表示判定
4. **行25-26**: テンプレート一覧のテーブル表示ループ
5. **行27-39**: ZIPアップロードとオンライン検索機能の表示
6. **行40-82**: カテゴリ別テンプレート表示機能（templateCatList, showTemplateBox関数）
7. **行83-126**: テンプレートインストール機能（installTemplate関数）

#### Step 3: セキュリティとヘッダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | 認証とアクセス制御のロジック |
| 3-2 | begin.asp | `asp/begin.asp` | 共通初期化処理 |
| 3-3 | bs_header.asp | `asp/bs_header.asp` | バックサイトヘッダーメニューの構成 |

**主要処理フロー**:
- **bs_security.asp**: logon.hasaccess secondAdmin.bTemplatesによる権限チェック
- **begin.asp**: データベース接続、セッション管理、共通関数のロード

#### Step 4: テンプレートインストール処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_templateList.asp | `asp/bs_templateList.asp` | installTemplate関数（行83-126） |

**主要処理フロー**:
- **行85-90**: ファイルシステムオブジェクト作成、パス解析
- **行92-99**: cls_templateインスタンス作成、HTMLファイル読み込み
- **行100-111**: テンプレートフォルダの作成とファイルコピー
- **行117-123**: Artisteer/JSTemplates対応処理、各種バリエーション初期化、保存

### プログラム呼び出し階層図

```
bs_templateList.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ データベース接続、セッション管理
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess（権限検証）
    │
    ├─ cls_template（テンプレートクラス）
    │      ├─ pick()     - テンプレート取得
    │      ├─ copy()     - テンプレート複製
    │      ├─ remove()   - テンプレート削除
    │      └─ save()     - テンプレート保存
    │
    ├─ cls_zipper（ZIPコンポーネント）
    │      └─ supportZipper - ZIP機能サポート確認
    │
    └─ customer（顧客オブジェクト）
           ├─ templates      - テンプレートコレクション取得
           ├─ defaultTemplate - デフォルトテンプレート設定
           └─ save()         - 設定保存
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ(a) ───▶ アクション判定 ───▶ copy/delete/default実行
                              │
                              ▼
customer.templates ───▶ テンプレート一覧取得 ───▶ HTMLテーブル生成
                              │
                              ▼
sNewTemplatesPath ───▶ カテゴリテンプレート表示 ───▶ テンプレートプレビュー
                              │
                              ▼
sInstallPath ───▶ installTemplate() ───▶ tblTemplateレコード作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | テンプレート一覧画面のメイン処理 |
| template.asp | `asp/includes/template.asp` | ソース | cls_templateクラス定義 |
| bs_templateEdit.asp | `asp/bs_templateEdit.asp` | ソース | テンプレート編集画面（遷移先） |
| bs_uploadzip.asp | `asp/bs_uploadzip.asp` | ソース | ZIPアップロード画面（遷移先） |
| bs_templateSearch.asp | `asp/bs_templateSearch.asp` | ソース | オンラインテンプレート検索画面（遷移先） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | バックサイトヘッダー |
| bs_templateBack.asp | `asp/bs_templateBack.asp` | ソース | テンプレート画面共通フッター |
