# 画面設計書 72-テンプレート編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるテンプレート編集画面（bs_templateEdit.asp）の設計仕様を定義する。

### 本画面の処理概要

テンプレート編集画面は、サイトデザインの根幹となるHTMLテンプレートの作成・編集を行う画面である。管理者はこの画面を通じて、テンプレートの名前設定、HTMLコードの編集、圧縮オプションの設定、テンプレートのプレビュー、および削除を行うことができる。

**業務上の目的・背景**：CMSにおいてテンプレートはサイト全体の見た目を決定する重要な要素である。本画面は、テンプレートのHTML/CSSを直接編集することで、サイトデザインの完全なカスタマイズを可能にする。Artisteer、JSTemplatesなどのデザインツールで生成されたテンプレートをそのまま利用するだけでなく、細かな調整やオリジナルのテンプレート作成にも対応し、デザイナーや開発者の要求に応える柔軟性を提供する。

**画面へのアクセス方法**：テンプレート一覧画面（bs_templateList.asp）から、新規作成リンクまたは既存テンプレートの編集アイコン/名前リンクをクリックしてアクセスする。管理者権限（secondAdmin.bTemplates）が必要。

**主要な操作・処理内容**：
1. テンプレート名の入力 - テンプレートの識別名を設定
2. HTMLコードの編集 - テキストエリアでHTMLテンプレートを直接編集
3. 圧縮オプションの設定 - 本番環境での圧縮使用を指定
4. テンプレートの保存 - 入力内容をデータベースに保存
5. テンプレートのプレビュー - 新しいウィンドウでプレビュー表示
6. テンプレートの削除 - 確認後にテンプレートを削除

**画面遷移**：
- 遷移元：テンプレート一覧画面（bs_templateList.asp）
- 遷移先：テンプレート一覧画面（削除時）、サイトトップページ（プレビュー時）、変数設定画面（bs_variables.asp）へのリンク

**権限による表示制御**：secondAdmin.bTemplates権限がない場合はアクセス不可。テンプレートが1件以下またはデフォルトテンプレートの場合は削除ボタンが非表示。新規作成時はプレビューボタンと削除ボタンが非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | テンプレート作成・編集 | 主機能 | テンプレートのHTML/CSS編集 |

## 画面種別

登録 / 編集

## URL/ルーティング

`asp/bs_templateEdit.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| itemplateID | 任意 | String | 暗号化されたテンプレートID（編集時） |

### POSTパラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| itemplateId | - | String | 暗号化されたテンプレートID |
| sName | 必須 | String | テンプレート名（最大50文字） |
| sValue | 必須 | Text | HTMLテンプレート本体 |
| bCompress | 任意 | Boolean | 圧縮使用フラグ |
| btnaction | 必須 | String | アクション種別（save/delete/preview） |
| QSSEC | 必須 | String | CSRFトークン |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| テンプレート名 | sName | Text | 必須 | 255 | テンプレートの名前 |
| HTML | sValue | Textarea | 必須 | - | HTMLテンプレート本体 |
| 圧縮使用 | bCompress | Checkbox | - | - | 圧縮版テンプレートをサイトで使用 |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| テンプレート名 | 既存テンプレートの名前 |
| HTMLコード | テンプレートのHTML本体 |
| 圧縮使用フラグ | 圧縮オプションの現在値 |

## 表示項目

### フォーム項目

| 項目名 | フィールド型 | サイズ | 備考 |
|--------|-------------|--------|------|
| Name | text | 40 | 最大255文字 |
| HTML | textarea | 60行x110列 | word-wrap:normal, overflow:auto |
| Use compressed version | checkbox | - | デフォルト：チェック |
| Common variables | リンク | - | bs_variables.aspへのリンク |

## イベント仕様

### 1-保存ボタンクリック（Save）

フォームを自身に送信し、checkCSRF()によるセキュリティチェック後、template.getRequestValues()でフォーム値を取得、template.save()でデータベースに保存する。保存成功時はfb_saveOKメッセージを表示。

### 2-削除ボタンクリック（Delete）

確認ダイアログ表示後、checkCSRF()によるセキュリティチェック後、template.remove()でテンプレートを削除し、テンプレート一覧画面にリダイレクトする。

### 3-プレビューボタンクリック（Preview）

フォームを新しいウィンドウ（target='_new'）で送信し、テンプレートを一時保存後、セッションにテンプレートIDを設定してサイトトップページを表示する。

### 4-Common variablesリンククリック

変数設定画面（bs_variables.asp）に遷移し、テンプレート内で使用可能な変数の一覧を確認できる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規保存 | tblTemplate | INSERT | 新規テンプレートレコードを作成 |
| 更新保存 | tblTemplate | UPDATE | 既存テンプレートレコードを更新 |
| 削除 | tblTemplate | DELETE | テンプレートレコードを削除 |
| 削除 | tblPage | UPDATE | 該当テンプレートを参照するページのiTemplateIDをnullに |
| 削除 | tblCustomer | UPDATE | デフォルトテンプレート参照を解除 |

### テーブル別更新項目詳細

#### tblTemplate

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値（左50文字） | テンプレート名 |
| INSERT/UPDATE | sValue | フォーム入力値 | HTMLテンプレート本体 |
| INSERT/UPDATE | sEmailValue | 初期化値または既存値 | メール用テンプレート |
| INSERT/UPDATE | sPrintValue | 初期化値または既存値 | 印刷用テンプレート |
| INSERT/UPDATE | sMobileValue | 初期化値または既存値 | モバイル用テンプレート |
| INSERT/UPDATE | sWAPValue | 初期化値または既存値 | WAP用テンプレート |
| INSERT/UPDATE | sCompressValue | compressHTML(sValue) | 圧縮版テンプレート |
| INSERT/UPDATE | bCompress | フォーム入力値 | 圧縮使用フラグ |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| DELETE | - | iId = 指定ID | テンプレート削除 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| fb_saveOK | 成功 | 保存成功時 | 保存しました |
| err_mandatory | エラー | 必須項目未入力時 | 必須項目を入力してください |
| areyousure | 確認 | 削除実行前 | 削除してもよろしいですか？ |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| CSRFトークン不正 | checkCSRF()によりエラー |
| 必須項目未入力 | check()関数によりエラーメッセージ表示、保存失敗 |
| テンプレート1件以下で削除試行 | 削除ボタン非表示により防止 |
| デフォルトテンプレートの削除試行 | 削除ボタン非表示により防止 |
| 新規テンプレートで削除/プレビュー試行 | ボタン非表示により防止 |

## 備考

- テキスト方向はLTR（Left-to-Right）に強制設定される（RTL言語対応のため）
- テンプレート内では[SITENAME]、[SITESLOGAN]、[PAGEBODY]などの変数が使用可能
- 圧縮機能はcompressHTML関数によりHTMLの空白・改行を削減
- 新規作成時はtemplate.init()でデフォルトテンプレートがロードされる
- プレビュー時はセッション変数iTemplateIDでテンプレートを一時指定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレートのデータ構造とビジネスロジックを担当するcls_templateクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | template.asp | `asp/includes/template.asp` | cls_templateクラスの定義、特にgetRequestValues、save、check、removeメソッド |

**読解のコツ**:
- 行48-59: Class_Initialize - リクエストパラメータからテンプレートIDを取得しpick()を呼び出す
- 行103-125: pick() - データベースからテンプレートを読み込む
- 行126-136: check() - バリデーション（sName, sValueの必須チェック）
- 行137-176: save() - データベースへの保存処理

#### Step 2: エントリーポイントを理解する

テンプレート編集画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateEdit.asp | `asp/bs_templateEdit.asp` | 画面のメインロジック。フォーム処理、ボタンアクション、画面表示 |

**主要処理フロー**:
1. **行1-4**: セキュリティチェック、テキスト方向設定（LTR）
2. **行4-5**: cls_templateインスタンス作成（コンストラクタでURLパラメータからロード）
3. **行6-28**: btnactionによる処理分岐（save/delete/preview）
4. **行29-33**: 削除可否判定（テンプレート数、デフォルトテンプレート確認）
5. **行33-35**: フォームHTML生成（入力フィールド、ボタン）

#### Step 3: 関連インクルードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_templateBack.asp | `asp/bs_templateBack.asp` | テンプレート画面共通フッター（戻るリンク） |
| 3-2 | bs_security.asp | `asp/bs_security.asp` | 認証とアクセス制御のロジック |

**主要処理フロー**:
- bs_templateBack.asp: テンプレート一覧へ戻るリンクを表示

### プログラム呼び出し階層図

```
bs_templateEdit.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ データベース接続、セッション管理
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bTemplates
    │
    ├─ cls_template（テンプレートクラス）
    │      ├─ Class_Initialize() - pick()呼び出し
    │      ├─ init()             - デフォルトテンプレートロード（新規時）
    │      ├─ getRequestValues() - フォーム値取得
    │      ├─ check()            - バリデーション
    │      ├─ save()             - データベース保存
    │      └─ remove()           - テンプレート削除
    │
    ├─ customer（顧客オブジェクト）
    │      ├─ templates          - テンプレートコレクション
    │      └─ defaultTemplate    - デフォルトテンプレートID
    │
    └─ bs_templateBack.asp
           └─ 戻るリンク表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム送信 ───▶ btnaction判定 ───┬──▶ save: getRequestValues() → save() → fb_saveOK
                                   │
                                   ├──▶ delete: remove() → bs_templateList.aspリダイレクト
                                   │
                                   └──▶ preview: save() → session設定 → default.aspリダイレクト

URLパラメータ ───▶ Class_Initialize ───▶ pick() ───▶ フォーム初期値表示
(itemplateID)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateEdit.asp | `asp/bs_templateEdit.asp` | ソース | テンプレート編集画面のメイン処理 |
| template.asp | `asp/includes/template.asp` | ソース | cls_templateクラス定義 |
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | テンプレート一覧画面（遷移元/遷移先） |
| bs_templateBack.asp | `asp/bs_templateBack.asp` | ソース | テンプレート画面共通フッター |
| bs_variables.asp | `asp/bs_variables.asp` | ソース | 変数設定画面（リンク先） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| template.txt | `asp/template.txt` | テンプレート | デフォルトテンプレートファイル |
