# 画面設計書 73-テンプレート作成

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるテンプレート作成画面（bs_CreateTemplate.asp）の設計仕様を定義する。

### 本画面の処理概要

テンプレート作成画面は、ZIPファイルから解凍されたテンプレートファイルを選択し、システムに登録するための画面である。ZIP解凍画面（bs_unzip.asp）から遷移し、解凍されたフォルダ内のHTMLファイルからテンプレートを作成する。Artisteer、JSTemplatesなどのデザインツールで生成されたテンプレートの自動認識と最適化にも対応している。

**業務上の目的・背景**：外部デザインツールで作成されたテンプレートをCMSに取り込む際、複数のHTMLファイルが含まれる場合がある。本画面は、管理者がテンプレートとして使用するHTMLファイルを選択し、適切な名前を付けてシステムに登録するためのインターフェースを提供する。JSTemplatesやArtisteerで生成されたテンプレートの場合は、自動的に最適化処理が適用され、CMSの変数（[SITENAME]、[PAGEBODY]等）への置換が行われる。

**画面へのアクセス方法**：ZIP解凍画面（bs_unzip.asp）での解凍処理完了後に自動的にリダイレクトされる。または、テンプレート一覧画面でカテゴリ別テンプレートの「Install」リンクからもアクセス可能。管理者権限（secondAdmin.bTemplates）が必要。

**主要な操作・処理内容**：
1. テンプレート名の入力 - テンプレートの名前を設定
2. HTMLファイルの選択 - 解凍されたフォルダ内のHTMLファイルからテンプレートとして使用するファイルを選択
3. JSTemplate認識オプション - Artisteer/JSTemplates形式として処理するかを指定
4. テンプレートの登録 - 選択したHTMLファイルをテンプレートとしてデータベースに登録

**画面遷移**：
- 遷移元：ZIP解凍画面（bs_unzip.asp）、テンプレート一覧画面（bs_templateList.asp）
- 遷移先：テンプレート一覧画面（登録完了後）

**権限による表示制御**：secondAdmin.bTemplates権限がない場合はアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | テンプレート作成・編集 | 主機能 | 新規テンプレートの作成 |

## 画面種別

登録

## URL/ルーティング

`asp/bs_CreateTemplate.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| path | 必須 | String | 解凍されたテンプレートフォルダのパス |

### POSTパラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| postBack | - | Boolean | ポストバック判定フラグ |
| path | 必須 | String | テンプレートフォルダのパス |
| foldername | 必須 | String | テンプレート名 |
| file | 必須 | String | 選択されたHTMLファイルのフルパス |
| bConsiderArtisteer | 任意 | Boolean | JSTemplate/Artisteer形式として処理 |
| QSSEC | 必須 | String | CSRFトークン |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| テンプレート名 | foldername | Text | 必須 | テンプレートの名前（デフォルトはフォルダ名） |
| HTMLファイル選択 | file | Radio | 必須 | テンプレートとして使用するHTMLファイル |
| JSTemplate形式 | bConsiderArtisteer | Checkbox | - | Artisteer/JSTemplates形式として処理するか |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| フォルダ内HTMLファイル一覧 | 解凍されたフォルダ内のHTMLファイルをラジオボタンで表示 |

## 表示項目

### フォーム項目

| 項目名 | フィールド型 | サイズ | 備考 |
|--------|-------------|--------|------|
| Template name | text | 30 | 必須、デフォルトはフォルダ名 |
| Select the html template | radio | - | .htm/.htmlファイルのみ表示、page.html/index.htmlが優先選択 |
| Treat as a JStemplate template? | checkbox | - | HTMLファイル検出時に自動チェック |

## イベント仕様

### 1-Continueボタンクリック

フォームを自身に送信し、バリデーション後にテンプレートを作成・登録する。

**処理詳細**:
1. 必須項目（file, foldername）のバリデーション
2. 選択されたHTMLファイルの読み込み
3. cls_templateインスタンス作成とプロパティ設定
4. bConsiderArtisteer=trueの場合、treatAsArtisteer()メソッドでテンプレート最適化
5. 各種バリエーション（WAP、Print、Mobile、Email）の初期化
6. save()メソッドでデータベースに保存
7. テンプレート一覧画面にリダイレクト（fbMessage=fb_templateadded）

### 2-HTMLファイル自動選択

初回表示時に以下の優先順位でHTMLファイルが自動選択される：
1. page.html / page.htm
2. index.html / index.htm
3. その他の.htm/.htmlファイル

### 3-JSTemplate認識自動判定

解凍されたフォルダ内にpage.html、index.html、または.htmファイルが存在する場合、bConsiderArtisteerが自動的にtrueに設定される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テンプレート登録 | tblTemplate | INSERT | 新規テンプレートレコードを作成 |

### テーブル別更新項目詳細

#### tblTemplate

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sName | フォーム入力値（foldername） | テンプレート名 |
| INSERT | sValue | HTMLファイルの内容（最適化後） | HTMLテンプレート本体 |
| INSERT | sPrintValue | initPrint()で初期化 | 印刷用テンプレート |
| INSERT | sEmailValue | initEmail()で初期化 | メール用テンプレート |
| INSERT | sMobileValue | initMobile()で初期化 | モバイル用テンプレート |
| INSERT | sWAPValue | initWAP()で初期化 | WAP用テンプレート |
| INSERT | bSetFooterVar | true（JSTemplate時） | フッター変数設定フラグ |
| INSERT | bSetRSSLink | true（JSTemplate時） | RSSリンク設定フラグ |
| INSERT | bSetContactVar | true（JSTemplate時） | コンタクト変数設定フラグ |
| INSERT | bSetCustomHL | true（JSTemplate時） | カスタムハイライト設定フラグ |
| INSERT | iCustomerID | cId | 顧客ID |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| fb_templateadded | 成功 | テンプレート登録完了時 | テンプレートが追加されました |
| err_mandatory | エラー | 必須項目未入力時 | 必須項目を入力してください |
| - | エラー | フォルダ不存在時 | The folder cannot be found. Create a new zip file... |
| - | エラー | ルートにファイルなし | Your zip file has no files in its root... |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| pathパラメータのフォルダが存在しない | エラーメッセージ表示 |
| ZIPのルートにファイルがない | フォルダ削除、エラーメッセージ表示 |
| 必須項目未入力 | エラーメッセージ表示、フォーム再表示 |
| 許可されていないファイルタイプ | 自動削除される |

## 備考

- page.html、index.htmlが存在する場合は自動的にJSTemplate/Artisteer形式と判断
- blog.html、home.htmlは表示対象から除外される
- 許可されていないファイルタイプ（allowedFileTypesに定義されていないもの）は自動削除される
- テンプレートフォルダはuserfiles/templates/配下に配置される
- treatAsArtisteer()メソッドでは、テンプレート内の相対パスを絶対パスに変換し、CMS変数への置換が行われる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレートのデータ構造とArtisteer/JSTemplates最適化処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | template.asp | `asp/includes/template.asp` | cls_templateクラス、特にtreatAsArtisteer()、treatAsJSTemplate()メソッド |

**読解のコツ**:
- 行214-263: importArtisteer4() - Artisteer v4テンプレートの変換処理
- 行264-375: treatAsJSTemplate() - JSTemplatesテンプレートの変換処理
- 行376-808: treatAsArtisteer() - 汎用Artisteerテンプレートの変換処理
- 行71-122: 各種バリエーション初期化（initPrint, initEmail, initMobile, initWAP）

#### Step 2: エントリーポイントを理解する

テンプレート作成画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | 画面のメインロジック。フォルダ検証、HTMLファイル列挙、テンプレート作成処理 |

**主要処理フロー**:
1. **行1-9**: インクルードファイル、セキュリティチェック
2. **行10-15**: 変数初期化、パスパラメータ取得
3. **行16-18**: フォルダ存在確認（FileSystemObject使用）
4. **行19-67**: ポストバック処理（バリデーション、テンプレート作成、保存）
5. **行75-120**: HTMLファイル一覧表示、自動選択ロジック、フォーム生成

#### Step 3: 遷移元画面を理解する

ZIP解凍画面からの遷移を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_unzip.asp | `asp/bs_unzip.asp` | ZIP解凍処理、テンプレート作成画面へのリダイレクト |

**主要処理フロー**:
- **行34**: zipper.unpack()でZIPファイルを解凍
- **行48**: bs_CreateTemplate.aspへリダイレクト（pathパラメータにフォルダパスを設定）

### プログラム呼び出し階層図

```
bs_CreateTemplate.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bTemplates
    │
    ├─ FileSystemObject（ファイル操作）
    │      ├─ FolderExists()    - フォルダ存在確認
    │      ├─ GetFolder()       - フォルダオブジェクト取得
    │      ├─ OpenTextFile()    - HTMLファイル読み込み
    │      └─ DeleteFile()      - 不許可ファイル削除
    │
    └─ cls_template（テンプレートクラス）
           ├─ sName設定
           ├─ sValue設定（HTMLファイル内容）
           ├─ treatAsArtisteer() - テンプレート最適化
           ├─ initWAP()          - WAPバリエーション初期化
           ├─ initPrint()        - 印刷バリエーション初期化
           ├─ initMobile()       - モバイルバリエーション初期化
           ├─ initEmail()        - メールバリエーション初期化
           └─ save()             - データベース保存
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ(path) ───▶ フォルダ検証 ───▶ HTMLファイル列挙
                              │
                              ▼
フォーム送信 ───▶ バリデーション ───▶ HTMLファイル読み込み
(file, foldername)            │
                              ▼
bConsiderArtisteer ───▶ treatAsArtisteer() ───▶ テンプレート最適化
                              │
                              ▼
                         init*()各種 ───▶ バリエーション初期化
                              │
                              ▼
                         save() ───▶ tblTemplateレコード作成
                              │
                              ▼
                         リダイレクト ───▶ bs_templateList.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | ソース | テンプレート作成画面のメイン処理 |
| template.asp | `asp/includes/template.asp` | ソース | cls_templateクラス定義 |
| bs_unzip.asp | `asp/bs_unzip.asp` | ソース | ZIP解凍画面（遷移元） |
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | テンプレート一覧画面（遷移先） |
| bs_templateBack.asp | `asp/bs_templateBack.asp` | ソース | テンプレート画面共通フッター |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| art_header.txt | `asp/art_header.txt` | テンプレート | Artisteerテンプレート用ヘッダー |
| template_print.txt | `asp/template_print.txt` | テンプレート | 印刷用デフォルトテンプレート |
| template_email.txt | `asp/template_email.txt` | テンプレート | メール用デフォルトテンプレート |
| template_mobile.txt | `asp/template_mobile.txt` | テンプレート | モバイル用デフォルトテンプレート |
| template_wap.txt | `asp/template_wap.txt` | テンプレート | WAP用デフォルトテンプレート |
