# 画面設計書 74-テンプレート検索

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるテンプレート検索画面（bs_templateSearch.asp）の設計仕様を定義する。

### 本画面の処理概要

テンプレート検索画面は、オンラインテンプレートギャラリーからテンプレートを検索・閲覧し、選択したテンプレートをダウンロード・インストールするための画面である。外部サーバー（sBrowseOnlineTemplatesUrl）からテンプレートリストを取得し、ページング表示する。管理者はプレビューを確認した上でテンプレートをシステムにインストールできる。

**業務上の目的・背景**：CMSの導入時やサイトリニューアル時に、一からテンプレートを作成するのは時間とコストがかかる。本画面は、あらかじめ用意されたオンラインテンプレートギャラリーからプロフェッショナルなデザインのテンプレートを簡単に取得・インストールすることで、サイト構築の効率化とデザイン品質の向上を実現する。

**画面へのアクセス方法**：テンプレート一覧画面（bs_templateList.asp）から「Search for templates online」リンクをクリックしてアクセスする。bBrowseOnlineTemplatesがtrueの場合のみリンクが表示される。管理者権限（secondAdmin.bTemplates）が必要。

**主要な操作・処理内容**：
1. テンプレートギャラリー表示 - オンラインからテンプレート一覧を取得し、サムネイル付きで表示
2. ページング操作 - ページ番号をクリックして表示ページを切り替え
3. テンプレートプレビュー - サムネイルクリックで新しいウィンドウにプレビュー表示
4. テンプレートダウンロード・インストール - 「Download & Install」リンクでテンプレートを取得・登録

**画面遷移**：
- 遷移元：テンプレート一覧画面（bs_templateList.asp）
- 遷移先：テンプレート作成画面（bs_createTemplate.asp）- インストール後

**権限による表示制御**：secondAdmin.bTemplates権限がない場合はアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 29 | オンラインテンプレート検索 | 主機能 | オンラインテンプレートギャラリーからの検索 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_templateSearch.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| iStart | 任意 | Integer | 表示開始ページ番号（デフォルト：1） |
| sBrowseOnlineTemplatesUrl | 任意 | String | カスタムテンプレートギャラリーURL |
| install | 任意 | String | インストール対象テンプレートのパス（sc.png） |

## 入出力項目

### 入力項目

本画面に入力フォームはない。ページング操作とリンククリックで操作する。

### 出力項目

| 項目名 | 説明 |
|--------|------|
| テンプレートサムネイル | 各テンプレートのプレビュー画像（180x180px） |
| プレビューリンク | クリックで新規ウィンドウにテンプレートプレビュー表示 |
| Download & Installリンク | テンプレートのダウンロードとインストール |
| ページング | ページ番号リンクによるナビゲーション |

## 表示項目

### テンプレートグリッド表示

| 項目名 | データソース | 備考 |
|--------|-------------|------|
| サムネイル画像 | 外部サーバー（sc.png） | 180x180px、クリックでプレビュー |
| Download & Install | リンク | 確認ダイアログ付き |

### ページングナビゲーション

| 項目名 | 説明 |
|--------|------|
| ページ番号 | 現在ページは太字、その他は通常表示 |
| 1ページあたり表示数 | 30件（browseBy変数） |

## イベント仕様

### 1-サムネイルクリック（プレビュー）

JavaScriptのbPopupFullWidthNoReloadクラスにより、テンプレートのpage.htmlを新しいポップアップウィンドウで表示する。

### 2-Download & Installリンククリック

確認ダイアログ表示後、テンプレートをダウンロード・インストールする。

**処理詳細**:
1. installパラメータにテンプレートパス（sc.png）を設定してリクエスト
2. MSXML2.ServerXMLHTTPでリモートサーバーからファイルリストを取得
3. templates/配下にディレクトリ構造を作成
4. 各ファイルをダウンロードしてローカルに保存
5. bs_createTemplate.aspにリダイレクトしてテンプレート登録

### 3-ページ番号クリック

iStartパラメータを変更して同画面をリロードし、指定ページのテンプレート一覧を表示する。

## データベース更新仕様

### 操作別データベース影響一覧

本画面ではデータベースの直接更新は行わない。テンプレートのインストール処理後、bs_createTemplate.aspでデータベース登録が行われる。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ダウンロード・インストール | - | ファイル作成 | ローカルファイルシステムへのファイル保存 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 確認 | Download & Install実行前 | Are you sure to download and install this template? |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| 外部サーバー接続失敗 | エラー表示（MSXML2.ServerXMLHTTPエラー） |
| ファイルダウンロード失敗 | status<>200の場合はスキップ |
| フォルダ作成失敗 | On Error Resume Nextで処理継続 |

## 備考

- テンプレートリストは外部サーバー（sBrowseOnlineTemplatesUrl）のlist.aspから取得
- リストはセッション変数（fullListTemplates）にキャッシュされ、同一セッション内では再取得しない
- 1ページあたり30件（browseBy）のテンプレートを表示
- サムネイル画像はsc.png、プレビューHTMLはpage.html
- ファイルダウンロードにはSaveBinaryData関数を使用（バイナリデータ対応）
- インストール先はuserfiles/templates/配下

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

外部サーバーからのレスポンス形式を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_templateSearch.asp | `asp/bs_templateSearch.asp` | 外部APIレスポンス（vbcrlf区切りのファイルパスリスト） |

**読解のコツ**:
- 外部サーバーのlist.aspは、テンプレートのsc.pngファイルパスをvbcrlf区切りで返す
- installパラメータ指定時は、テンプレート内の全ファイルリストがvbcrlf区切りで返される

#### Step 2: エントリーポイントを理解する

テンプレート検索画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateSearch.asp | `asp/bs_templateSearch.asp` | 画面のメインロジック。外部API通信、ファイルダウンロード、ページング |

**主要処理フロー**:
1. **行1-8**: インクルードファイル、セキュリティチェック、初期化
2. **行10-38**: installパラメータ指定時のダウンロード・インストール処理
   - 行11-15: ServerXMLHTTPでファイルリスト取得
   - 行16-26: ディレクトリ構造作成
   - 行27-35: 各ファイルをダウンロード、SaveBinaryDataで保存
   - 行38: bs_createTemplate.aspへリダイレクト
3. **行40-49**: テンプレートリスト取得（キャッシュ使用）
4. **行52-65**: テンプレートグリッド表示（ページング対応）
5. **行66-78**: ページングナビゲーション生成（navbalk関数）

#### Step 3: ファイル保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 共通関数 | （begin.asp等） | SaveBinaryData関数の実装 |

**主要処理フロー**:
- SaveBinaryData関数はresponseBodyをバイナリモードでファイルに保存

### プログラム呼び出し階層図

```
bs_templateSearch.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bTemplates
    │
    ├─ MSXML2.ServerXMLHTTP（HTTP通信）
    │      ├─ list.asp取得（テンプレートリスト）
    │      └─ 各ファイルダウンロード
    │
    ├─ FileSystemObject（ファイル操作）
    │      └─ createfolder（ディレクトリ作成）
    │
    ├─ SaveBinaryData（バイナリファイル保存）
    │
    └─ navbalk（ページングナビ生成）
```

### データフロー図

```
[入力]                         [処理]                           [出力]

URLパラメータ(iStart) ───▶ ページ計算 ───▶ テンプレートグリッド表示
                               │
外部サーバー ───▶ list.asp ───▶ セッションキャッシュ ───▶ ページング表示
                               │
URLパラメータ(install) ───▶ ファイルリスト取得 ───▶ フォルダ作成
                               │
                               ▼
                          ファイルダウンロード ───▶ SaveBinaryData
                               │
                               ▼
                          リダイレクト ───▶ bs_createTemplate.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateSearch.asp | `asp/bs_templateSearch.asp` | ソース | オンラインテンプレート検索画面のメイン処理 |
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | テンプレート一覧画面（遷移元） |
| bs_createTemplate.asp | `asp/bs_CreateTemplate.asp` | ソース | テンプレート作成画面（遷移先） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理、SaveBinaryData関数 |
