# 画面設計書 75-ZIPアップロード

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるZIPアップロード画面（bs_uploadzip.asp）の設計仕様を定義する。

### 本画面の処理概要

ZIPアップロード画面は、テンプレートZIPファイルをサーバーにアップロードするための画面である。JStemplates.comやArtisteerなどのデザインツールで作成したテンプレートをZIP形式で圧縮し、CMSにインポートする際の最初のステップとなる。アップロード成功後はZIP解凍画面（bs_unzip.asp）に遷移する。

**業務上の目的・背景**：外部デザインツールで作成されたテンプレートは、HTML、CSS、画像ファイルなど複数のファイルで構成される。これらをZIP形式にまとめてアップロードすることで、効率的にテンプレートをCMSに取り込むことができる。本画面は、そのアップロード処理を担当し、ファイルタイプとサイズの検証を行う。

**画面へのアクセス方法**：テンプレート一覧画面（bs_templateList.asp）から「Upload zipped template」リンクをクリックしてアクセスする。customer.supportZipperがtrueの場合のみリンクが表示される。管理者権限（secondAdmin.bTemplates）が必要。

**主要な操作・処理内容**：
1. ZIPファイルの選択 - ファイル選択ダイアログでZIPファイルを選択
2. ZIPファイルのアップロード - アップロードボタンで選択したファイルをサーバーに転送
3. ファイル検証 - ファイルタイプ（.zip）の検証
4. 解凍画面への遷移 - アップロード成功後、ZIP解凍画面に自動リダイレクト

**画面遷移**：
- 遷移元：テンプレート一覧画面（bs_templateList.asp）
- 遷移先：ZIP解凍画面（bs_unzip.asp）- アップロード成功後

**権限による表示制御**：secondAdmin.bTemplates権限がない場合はアクセス不可。customer.supportZipperがfalseの場合はテンプレート一覧画面にリダイレクト。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | テンプレートインポート | 主機能 | テンプレートZIPファイルのアップロード |

## 画面種別

登録（ファイルアップロード）

## URL/ルーティング

`asp/bs_uploadzip.asp`

### パラメータ

なし（POSTでマルチパートフォームデータとして送信）

### POSTパラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| sName | 必須 | File | アップロードするZIPファイル |
| QSSEC | 必須 | String | CSRFトークン |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Select ZIP | sName | File | 必須 | アップロードするZIPファイル（.zip形式のみ） |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| アップロード結果 | エラー時のみメッセージ表示 |

## 表示項目

### フォーム項目

| 項目名 | フィールド型 | サイズ | 備考 |
|--------|-------------|--------|------|
| Select ZIP | file | 40 | 最大255文字のファイル名 |
| アップロードボタン | button | - | クリック後に「Please wait...」表示、無効化 |

### 説明テキスト

- JStemplates.comで作成したテンプレートのアップロード用途を説明
- aspEasyZipコンポーネント（John Lohmeyer作）の使用を説明

## イベント仕様

### 1-アップロードボタンクリック

JavaScript処理でボタン表示を「Please wait...」に変更し、ボタンを無効化後にフォームを送信する。

**処理詳細**:
1. FreeASPUploadクラスでマルチパートフォームデータを処理
2. アップロード先ディレクトリ（userfiles）にファイルを保存
3. CSRFトークン検証（checkCSRF_Upload）
4. ファイルタイプ検証（.zip以外はエラー）
5. 検証成功時はbs_unzip.aspにリダイレクト
6. 検証失敗時はエラーメッセージ表示

### 2-ファイル選択

ファイル選択ダイアログでZIPファイルを選択する。選択時の即時検証は行わない。

## データベース更新仕様

### 操作別データベース影響一覧

本画面ではデータベースの更新は行わない。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| ファイルアップロード | ファイルシステム | ファイル作成 | userfiles配下にZIPファイルを保存 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| err_fileType | エラー | 拡張子がzip以外の場合 | ファイルタイプエラー |
| err_newFile | エラー | ファイルが選択されていない場合 | ファイル選択エラー |
| - | エラー | アップロード失敗時 | Something went wrong when uploading... |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| ZIPコンポーネント未サポート | テンプレート一覧画面にリダイレクト |
| CSRFトークン不正 | checkCSRF_Upload()によりエラー |
| ファイルタイプ不正 | ファイル削除、エラーメッセージ表示 |
| アップロード失敗 | エラーメッセージ表示（フォルダ権限、サイズ制限等） |

## 備考

- FreeASPUploadクラスを使用してマルチパートフォームデータを処理
- アップロードサイズ制限はサーバー設定（IIS）に依存（約200KB制限の可能性）
- ZIPコンポーネントはaspEasyZip（John Lohmeyer作）を使用
- アップロードされたZIPファイルはuserfiles直下に保存される
- ENCTYPE="multipart/form-data"が必須
- CSRFトークンは通常のcheckCSRF()ではなくcheckCSRF_Upload()を使用（マルチパート対応）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アップロード処理で使用されるFreeASPUploadクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | （共通インクルード） | - | FreeASPUploadクラスの構造（Save, UploadedFiles, form） |

**読解のコツ**:
- FreeASPUploadはマルチパートフォームデータを解析するクラス
- UploadedFilesコレクションにアップロードされたファイル情報が格納される
- form()メソッドで通常のフォームフィールド（CSRFトークン等）にアクセス

#### Step 2: エントリーポイントを理解する

ZIPアップロード画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_uploadzip.asp | `asp/bs_uploadzip.asp` | 画面のメインロジック。アップロード処理、ファイル検証、リダイレクト |

**主要処理フロー**:
1. **行1-6**: インクルードファイル、セキュリティチェック、ZIPサポート確認
2. **行7-11**: アップロード先ディレクトリ設定、FreeASPUploadインスタンス作成
3. **行12-16**: アップロードエラーハンドリング
4. **行17**: CSRFトークン検証（マルチパート対応版）
5. **行18-35**: アップロードファイル処理ループ
   - 行22-26: ファイルタイプ検証（.zipのみ許可）
   - 行28-30: エラー時はファイル削除
   - 行30: 成功時はbs_unzip.aspへリダイレクト
6. **行36-37**: フォームHTML生成

#### Step 3: 遷移先画面を理解する

ZIP解凍画面への遷移を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_unzip.asp | `asp/bs_unzip.asp` | ZIP解凍処理、テンプレート作成画面へのリダイレクト |

### プログラム呼び出し階層図

```
bs_uploadzip.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bTemplates
    │
    ├─ cls_zipper（ZIPコンポーネント）
    │      └─ supportZipper - ZIP機能サポート確認
    │
    ├─ FreeASPUpload（アップロードクラス）
    │      ├─ Save()          - ファイル保存
    │      ├─ UploadedFiles   - アップロードファイルコレクション
    │      ├─ form()          - フォームフィールドアクセス
    │      └─ delete()        - ファイル削除
    │
    ├─ checkCSRF_Upload()（CSRF検証）
    │
    └─ GetFileExtension()（拡張子取得）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム送信 ───▶ FreeASPUpload.Save() ───▶ userfiles/に保存
(multipart/form-data)      │
                           ▼
                    checkCSRF_Upload() ───▶ トークン検証
                           │
                           ▼
                    GetFileExtension() ───▶ .zip検証
                           │
            ┌──────────────┼──────────────┐
            ▼              ▼              ▼
        成功時         エラー時        エラー時
            │              │              │
            ▼              ▼              ▼
    bs_unzip.asp    ファイル削除    エラーメッセージ
    へリダイレクト   エラー表示      表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_uploadzip.asp | `asp/bs_uploadzip.asp` | ソース | ZIPアップロード画面のメイン処理 |
| bs_unzip.asp | `asp/bs_unzip.asp` | ソース | ZIP解凍画面（遷移先） |
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | テンプレート一覧画面（遷移元） |
| bs_templateBack.asp | `asp/bs_templateBack.asp` | ソース | テンプレート画面共通フッター |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
