# 画面設計書 76-ZIP解凍

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるZIP解凍画面（bs_unzip.asp）の設計仕様を定義する。

### 本画面の処理概要

ZIP解凍画面は、ZIPアップロード画面（bs_uploadzip.asp）でアップロードされたZIPファイルを解凍し、テンプレート作成画面（bs_createTemplate.asp）に引き継ぐための中間処理画面である。管理者は解凍先フォルダの指定、フォルダ名の確認、ZIPファイルの削除オプションを設定できる。

**業務上の目的・背景**：アップロードされたテンプレートZIPファイルを適切なディレクトリ構造で解凍することで、テンプレートのファイル（HTML、CSS、画像等）をCMSで利用可能な状態にする。本画面は、解凍先の指定やZIPファイルの後処理（削除）など、管理者の意図を反映した柔軟な処理を可能にする。

**画面へのアクセス方法**：ZIPアップロード画面（bs_uploadzip.asp）でのアップロード成功後に自動的にリダイレクトされる。管理者権限（secondAdmin.bTemplates）が必要。

**主要な操作・処理内容**：
1. ZIPファイル名の確認 - アップロードされたZIPファイル名を表示
2. 解凍先フォルダの選択 - セレクトボックスで解凍先フォルダを指定
3. テンプレートフォルダ名の確認 - ZIPファイル名（拡張子なし）がデフォルト
4. ZIPファイル削除オプション - 解凍後にZIPファイルを削除するか選択
5. 解凍処理の実行 - Continueボタンで解凍処理を実行

**画面遷移**：
- 遷移元：ZIPアップロード画面（bs_uploadzip.asp）
- 遷移先：テンプレート作成画面（bs_createTemplate.asp）- 解凍成功後

**権限による表示制御**：secondAdmin.bTemplates権限がない場合はアクセス不可。customer.supportZipperがfalseの場合はテンプレート一覧画面にリダイレクト。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | テンプレートインポート | 主機能 | アップロードしたZIPファイルの解凍処理 |

## 画面種別

登録（処理中間画面）

## URL/ルーティング

`asp/bs_unzip.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| zip | 必須 | String | 解凍対象のZIPファイル名 |

### POSTパラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| postBack | - | Boolean | ポストバック判定フラグ |
| zip | 必須 | String | ZIPファイル名 |
| sPath | 任意 | String | 解凍先フォルダパス |
| foldername | 任意 | String | テンプレートフォルダ名 |
| bRemove | 任意 | Boolean | ZIPファイル削除フラグ |
| QSSEC | 必須 | String | CSRFトークン |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 解凍先フォルダ | sPath | Select | - | 解凍先フォルダ（デフォルト：/templates） |
| テンプレートフォルダ名 | foldername | - | - | 表示のみ（ZIPファイル名から自動設定） |
| ZIPファイル削除 | bRemove | Radio | 必須 | Yes/No選択（デフォルト：Yes） |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| ZIPファイル名 | アップロードされたZIPファイルの名前 |
| テンプレートフォルダ名 | 解凍後のフォルダ名（太字表示） |

## 表示項目

### フォーム項目

| 項目名 | フィールド型 | 備考 |
|--------|-------------|------|
| Name zipfile | 表示のみ | ZIPファイル名 |
| Store in folder | select | cls_fileexplorerで生成 |
| Template folder name | 表示のみ（太字） | ZIPファイル名（拡張子なし） |
| Remove zip file? | radio | Yes/No |

## イベント仕様

### 1-Continueボタンクリック

フォームを自身に送信し、ZIPファイルの解凍処理を実行する。

**処理詳細**:
1. postBackフラグがtrueの場合に解凍処理を実行
2. 解凍先フォルダパス（sPath）とフォルダ名（foldername）を取得
3. zipper.unpack()でZIPファイルを解凍
4. bRemove=trueの場合、ZIPファイルを削除
5. Artisteer v4またはJSTemplate形式の判定
6. bs_createTemplate.aspにリダイレクト（pathパラメータに解凍先を設定）
7. 解凍失敗時はエラーメッセージ表示

### 2-解凍先フォルダ選択

セレクトボックスでuserfiles配下のフォルダから解凍先を選択する。デフォルトは/templates。

### 3-ZIPファイル削除オプション選択

ラジオボタンでYes/Noを選択。デフォルトはYes。

## データベース更新仕様

### 操作別データベース影響一覧

本画面ではデータベースの更新は行わない。

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| ZIP解凍 | ファイルシステム | フォルダ/ファイル作成 | userfiles配下にフォルダ構造を展開 |
| ZIPファイル削除 | ファイルシステム | ファイル削除 | bRemove=true時にZIPファイルを削除 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | エラー | 解凍失敗時 | The zip file does not look like a zipped template. |
| - | リンク | 解凍失敗時 | Try again（bs_uploadzip.aspへのリンク） |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| ZIPコンポーネント未サポート | テンプレート一覧画面にリダイレクト |
| 解凍失敗 | エラーメッセージ表示、リトライリンク提供 |
| 不正なZIPファイル | zipper.unpack()がfalseを返し、エラー処理 |

## 備考

- cls_zipperクラスを使用してZIP解凍処理を実行
- 解凍先のデフォルトは/templates（userfiles/templates）
- フォルダ名未指定時はZIPファイル名（拡張子なし）がフォルダ名になる
- Artisteer v4およびJSTemplate形式のテンプレートは自動判定される（bTreatAsArt4, treatASJSTemplate）
- ZIPファイル削除はcls_fileexplorerのdeleteFileメソッドを使用
- 解凍処理はzipper.unpack()メソッドで実行

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ZIP解凍処理で使用されるcls_zipperクラスとcls_fileexplorerクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | （共通インクルード） | - | cls_zipperクラスの構造（unpack, supportZipper, bTreatAsArt4, treatASJSTemplate） |
| 1-2 | （共通インクルード） | - | cls_fileexplorerクラスの構造（SelectBoxFolders, deleteFile） |

**読解のコツ**:
- cls_zipperはZIP解凍機能をカプセル化したクラス
- unpack()メソッドはZIPファイルパスと解凍先パスを受け取り、成功/失敗を返す
- bTreatAsArt4, treatASJSTemplateプロパティでテンプレート形式を判定

#### Step 2: エントリーポイントを理解する

ZIP解凍画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_unzip.asp | `asp/bs_unzip.asp` | 画面のメインロジック。フォーム処理、解凍処理、リダイレクト |

**主要処理フロー**:
1. **行1-15**: インクルードファイル、セキュリティチェック、ZIPサポート確認
2. **行16-21**: 変数初期化、cls_fileexplorerインスタンス作成
3. **行22-57**: ポストバック処理
   - 行23-30: フォーム値取得、フォルダパス構築
   - 行31-34: zipper.unpack()でZIP解凍実行
   - 行36-39: bRemove=trueの場合ZIPファイル削除
   - 行42-48: 解凍先パス調整（テンプレート形式に応じて）
   - 行48: bs_createTemplate.aspへリダイレクト
4. **行58-60**: フォームHTML生成

#### Step 3: 遷移先画面を理解する

テンプレート作成画面への遷移を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | テンプレート登録処理 |

### プログラム呼び出し階層図

```
bs_unzip.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bTemplates
    │
    ├─ cls_zipper（ZIPコンポーネント）
    │      ├─ supportZipper    - ZIP機能サポート確認
    │      ├─ unpack()         - ZIP解凍実行
    │      ├─ bTreatAsArt4     - Artisteer v4判定
    │      └─ treatASJSTemplate - JSTemplate判定
    │
    ├─ cls_fileexplorer（ファイル操作）
    │      ├─ SelectBoxFolders() - フォルダ選択ボックス生成
    │      └─ deleteFile()       - ファイル削除
    │
    └─ GetFileExtension()（拡張子取得）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ(zip) ───▶ ZIPファイル情報表示 ───▶ フォーム表示
                              │
フォーム送信 ───▶ パス構築 ───▶ zipper.unpack() ───▶ フォルダ展開
(sPath, bRemove)              │
                              ▼
                    bRemove=true ───▶ fe.deleteFile() ───▶ ZIPファイル削除
                              │
                              ▼
                    テンプレート形式判定 ───▶ パス調整
                              │
                              ▼
                    リダイレクト ───▶ bs_createTemplate.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_unzip.asp | `asp/bs_unzip.asp` | ソース | ZIP解凍画面のメイン処理 |
| bs_uploadzip.asp | `asp/bs_uploadzip.asp` | ソース | ZIPアップロード画面（遷移元） |
| bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | ソース | テンプレート作成画面（遷移先） |
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | テンプレート一覧画面 |
| bs_templateBack.asp | `asp/bs_templateBack.asp` | ソース | テンプレート画面共通フッター |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
