# 画面設計書 77-テーマ一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるテーマ一覧画面（bs_themesList.asp）の設計仕様を定義する。

### 本画面の処理概要

テーマ一覧画面は、CMSに登録されているテーマ（フォーラム/ブログ）を一覧表示し、管理するための画面である。各テーマのコピー、編集への導線、テーマコード（[QS_THEME:xxx]）の表示機能を提供する。

**業務上の目的・背景**：QuickerSiteでは「テーマ」という概念でフォーラムやブログを管理する。サイト管理者は本画面から既存テーマの確認、新規テーマの作成、テーマのコピーを行う。テーマコードはページ内にテーマを埋め込む際に使用するマークアップタグである。

**画面へのアクセス方法**：管理画面のイントラネットメニューからテーマボタンをクリックしてアクセスする。管理者権限（secondAdmin.bTheme）が必要。

**主要な操作・処理内容**：
1. テーマ一覧の表示 - 登録済みテーマを名前とともに一覧表示
2. 新規テーマ作成 - 「新規テーマ」リンクからテーマ編集画面へ遷移
3. テーマ編集 - テーマ名クリックでテーマ編集画面へ遷移
4. テーマコピー - コピーアイコンクリックで確認後テーマを複製
5. テーマコード表示 - 埋め込み用タグをテキストボックスで表示

**画面遷移**：
- 遷移元：管理画面ヘッダーメニュー（イントラネット > テーマ）
- 遷移先：テーマ編集画面（bs_themeEdit.asp）

**権限による表示制御**：secondAdmin.bTheme権限がない場合はアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | テーマ管理 | 主機能 | テーマの一覧表示・コピー |

## 画面種別

一覧（管理）

## URL/ルーティング

`asp/bs_themesList.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| ithemeID | 任意 | Integer（暗号化） | コピー対象のテーマID |

### POSTパラメータ

なし（GETパラメータでコピー処理を実行）

## 入出力項目

### 入力項目

なし（一覧表示のみ）

### 出力項目

| 項目名 | 説明 |
|--------|------|
| テーマ名 | テーマの表示名（リンク） |
| コピーアイコン | テーマコピー用アイコン |
| テーマコード | [QS_THEME:xxx]形式の埋め込みタグ |
| iID | テーマの内部ID |

## 表示項目

### テーマ一覧テーブル

| 列 | フィールド型 | 備考 |
|------|-------------|------|
| テーマ名 | リンク | bs_themeEdit.aspへ遷移 |
| コピー | アイコン | クリックで確認ダイアログ表示 |
| テーマコード | テキストボックス | クリックで選択、コピー可能 |
| iID | テキスト | 内部ID表示 |

### 上部リンク

| 項目名 | 遷移先 |
|--------|--------|
| 新規テーマ | bs_themeEdit.asp（パラメータなし） |

## イベント仕様

### 1-テーマ名クリック

テーマ編集画面（bs_themeEdit.asp）に遷移し、選択したテーマの編集を行う。

**処理詳細**:
1. encrypt(themeKey)でテーマIDを暗号化してiThemeIDパラメータに設定
2. bs_themeEdit.aspにリダイレクト

### 2-コピーアイコンクリック

確認ダイアログ表示後、テーマをコピーしてテーマ編集画面に遷移する。

**処理詳細**:
1. confirm()で「areyousuretocopy」メッセージ表示
2. OKクリックでbs_themesList.aspにithemeIDパラメータ付きでアクセス
3. cls_theme.copy()でテーマをコピー
4. コピー成功時、新規テーマIDでbs_themeEdit.aspにリダイレクト

### 3-テーマコードテキストボックスクリック

テキストボックス内のテーマコードを全選択する。

**処理詳細**:
1. onclick="javascript:this.select();"で全選択
2. ユーザーがCtrl+Cでコピー可能

### 4-新規テーマリンククリック

パラメータなしでテーマ編集画面に遷移し、新規テーマを作成する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| テーマコピー | themes | INSERT | テーマレコードを複製 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| newtheme | リンク | 常時 | 新規テーマ作成リンク |
| notheme | 情報 | テーマが0件の場合 | テーマが登録されていません |
| areyousuretocopy | 確認 | コピーアイコンクリック時 | コピーしますか？ |
| copyItem | ツールチップ | コピーアイコン | コピー |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| テーマ0件 | 「notheme」メッセージ表示 |
| コピー失敗 | cls_theme.copy()が0を返し、リダイレクトしない |

## 備考

- テーマコードは[QS_THEME:xxx]形式でページに埋め込む
- テーマコードが未設定（isLeeg）の場合はテキストボックス非表示
- コピー時はCSRFトークン（QS_secCodeURL）をパラメータに含める
- customer.themesコレクションから全テーマを取得
- テーマIDはencrypt()で暗号化してURLに含める

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テーマ管理で使用されるcls_themeクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | theme.asp | `asp/includes/theme.asp` | cls_themeクラスの構造（iId, sName, sCode, copy()メソッド） |

**読解のコツ**:
- cls_themeはテーマ（フォーラム/ブログ）を管理するクラス
- copy()メソッドはテーマを複製し、新規IDを返す
- sCodeはテーマ埋め込み用のコード

#### Step 2: エントリーポイントを理解する

テーマ一覧画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_themesList.asp | `asp/bs_themesList.asp` | 画面のメインロジック。テーマ一覧表示、コピー処理 |

**主要処理フロー**:
1. **行1-4**: インクルードファイル、セキュリティチェック、ヘッダー表示
2. **行5-7**: cls_themeインスタンス作成、copy()実行、コピー成功時リダイレクト
3. **行8-9**: customer.themesからテーマ一覧取得、新規テーマリンク表示
4. **行9-10**: テーマループ処理
   - テーマ名リンク生成（bs_themeEdit.aspへ）
   - コピーアイコン生成（getIcon関数）
   - テーマコードテキストボックス生成
   - iID表示

#### Step 3: 遷移先画面を理解する

テーマ編集画面への遷移を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_themeEdit.asp | `asp/bs_themeEdit.asp` | テーマ詳細設定、保存・削除処理 |

### プログラム呼び出し階層図

```
bs_themesList.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bTheme
    │
    ├─ cls_theme（テーマクラス）
    │      └─ copy()      - テーマコピー
    │
    ├─ customer.themes（テーマコレクション）
    │      └─ count       - テーマ件数
    │      └─ (themeKey)  - 個別テーマ取得
    │
    ├─ getIcon()（アイコン生成）
    │
    ├─ encrypt()（ID暗号化）
    │
    └─ sanitize()（HTML無害化）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

画面アクセス ───▶ セキュリティチェック ───▶ 権限確認
                         │
                         ▼
                 ithemeIDパラメータあり？
                         │
            ┌────────────┼────────────┐
            ▼            ▼
      パラメータあり  パラメータなし
            │            │
            ▼            ▼
    cls_theme.copy()  customer.themes取得
            │            │
            ▼            ▼
    コピー成功？      テーマ一覧表示
            │            │
   成功時   ▼            ▼
    bs_themeEdit.asp  テーブルHTML生成
    へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_themesList.asp | `asp/bs_themesList.asp` | ソース | テーマ一覧画面のメイン処理 |
| bs_themeEdit.asp | `asp/bs_themeEdit.asp` | ソース | テーマ編集画面（遷移先） |
| theme.asp | `asp/includes/theme.asp` | ソース | cls_themeクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | 管理画面ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | ソース | 管理画面フッター |
