# 画面設計書 78-テーマ編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるテーマ編集画面（bs_themeEdit.asp）の設計仕様を定義する。

### 本画面の処理概要

テーマ編集画面は、フォーラム/ブログのテーマを詳細に設定・編集するための画面である。テーマの基本情報（名前、コード、タイプ）から、投稿設定、表示設定、通知設定まで幅広い項目を管理できる。

**業務上の目的・背景**：QuickerSiteのテーマは、フォーラム、ブログ、コメントディスカッション、トピックサブスクリプションなど複数の形式をサポートする。管理者は本画面でテーマの動作を細かく制御し、コミュニティ機能の要件に合わせた設定を行う。

**画面へのアクセス方法**：テーマ一覧画面（bs_themesList.asp）からテーマ名をクリック、または「新規テーマ」リンクをクリックしてアクセス。管理者権限（secondAdmin.bTheme）が必要。

**主要な操作・処理内容**：
1. テーマ基本情報の設定 - 名前、コード、タイプの設定
2. 投稿設定 - HTML許可、ファイルアップロード、スマイリー、投稿バリデーション
3. 表示設定 - ページサイズ、幅、カラー設定
4. 返信設定 - 返信許可、匿名返信、文字数制限
5. 通知設定 - トピック通知、返信通知のメールテンプレート
6. テーマの保存・削除

**画面遷移**：
- 遷移元：テーマ一覧画面（bs_themesList.asp）
- 遷移先：テーマ一覧画面（bs_themesList.asp）- 削除後

**権限による表示制御**：secondAdmin.bTheme権限がない場合はアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 45 | テーマ管理 | 主機能 | テーマの作成・編集・削除 |

## 画面種別

登録・編集

## URL/ルーティング

`asp/bs_themeEdit.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| iThemeID | 任意 | Integer（暗号化） | 編集対象のテーマID（新規作成時は省略） |

### POSTパラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| postBack | - | Boolean | ポストバック判定フラグ |
| iThemeId | 任意 | Integer（暗号化） | テーマID |
| sName | 必須 | String | テーマ名 |
| sCode | 任意 | String | テーマコード（埋め込み用） |
| iType | 必須 | Integer | テーマタイプ |
| iContactID | 条件付き | Integer | モデレーター/ブロガーID |
| bForwardPostsToModerator | 任意 | Boolean | モデレーターへ投稿転送 |
| bValidation | 任意 | Boolean | 投稿バリデーション必要 |
| iSubLevel | 任意 | Integer | サブスクリプションレベル |
| iSearchType | 任意 | Integer | サイト検索タイプ |
| bOnline | 任意 | Boolean | オンライン状態 |
| bLocked | 任意 | Boolean | ロック状態 |
| bAllowHTML | 任意 | Boolean | HTML許可 |
| bUpload | 任意 | Boolean | アップロード許可 |
| bEmbed | 任意 | Boolean | 埋め込みオブジェクト許可 |
| bSmileys | 任意 | Boolean | スマイリー許可 |
| bFileUploads | 任意 | Boolean | 添付ファイル許可 |
| bCompactList | 任意 | Boolean | コンパクト表示 |
| iLimitTopicTo | 任意 | Integer | トピック文字数制限 |
| bAllowComments | 任意 | Boolean | 返信許可 |
| bAllowAP | 任意 | Boolean | 匿名返信許可 |
| sLabelYourName | 条件付き | String | 匿名ユーザー名ラベル |
| iLimitReplyTo | 任意 | Integer | 返信文字数制限 |
| iPageSize | 任意 | Integer | 1ページあたりトピック数 |
| sColorEven | 任意 | String | 偶数行の背景色 |
| sColorUnEven | 任意 | String | 奇数行の背景色 |
| iWidth | 任意 | Integer | 表示幅（px） |
| bPushRSS | 任意 | Boolean | RSS配信 |
| sTopicSubjectNotification | 必須 | String | トピック通知件名 |
| sTopicBodyNotification | 必須 | String | トピック通知本文 |
| sSubjectNotification | 必須 | String | 返信通知件名 |
| sBodyNotification | 必須 | String | 返信通知本文 |
| btnaction | - | String | 実行アクション（save/delete） |
| QSSEC | 必須 | String | CSRFトークン |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 名前 | sName | Text(255) | 必須 | テーマ表示名 |
| コード | sCode | Text(45) | - | [QS_THEME:xxx]用コード |
| タイプ | iType | Select | 必須 | フォーラム/ブログ等 |
| モデレーター/ブロガー | iContactID | Select | 条件付き | 管理者選択 |
| モデレーターへ転送 | bForwardPostsToModerator | Checkbox | - | 投稿転送フラグ |
| バリデーション必要 | bValidation | Checkbox | - | 投稿承認フラグ |
| サブスクリプションレベル | iSubLevel | Select | - | 購読レベル |
| サイト検索タイプ | iSearchType | Select | - | 検索包含設定 |
| オンライン | bOnline | Checkbox | - | 公開状態 |
| ロック | bLocked | Checkbox | - | 新規投稿禁止 |
| HTML許可 | bAllowHTML | Checkbox | - | HTML入力許可 |
| アップロード許可 | bUpload | Checkbox | - | ファイルアップロード |
| 埋め込み許可 | bEmbed | Checkbox | - | オブジェクト埋め込み |
| スマイリー | bSmileys | Checkbox | - | スマイリー使用 |
| 添付ファイル | bFileUploads | Checkbox | - | ファイル添付許可 |
| コンパクト表示 | bCompactList | Checkbox | - | タイトルのみ表示 |
| トピック文字数制限 | iLimitTopicTo | Select | - | 500-9000文字 |
| 返信許可 | bAllowComments | Checkbox | - | コメント許可 |
| 匿名返信許可 | bAllowAP | Checkbox | - | 匿名コメント |
| 名前ラベル | sLabelYourName | Text(50) | 条件付き | 匿名用ラベル |
| 返信文字数制限 | iLimitReplyTo | Select | - | 150-3500文字 |
| ページサイズ | iPageSize | Select | - | 1-100件 |
| 偶数行カラー | sColorEven | Text+ColorPicker | - | 背景色 |
| 奇数行カラー | sColorUnEven | Text+ColorPicker | - | 背景色 |
| 幅 | iWidth | Select | - | 150-1500px |
| Push RSS | bPushRSS | Checkbox | - | RSS配信 |
| トピック通知件名 | sTopicSubjectNotification | Text(255) | 必須 | メール件名 |
| トピック通知本文 | sTopicBodyNotification | RichText | 必須 | メール本文 |
| 返信通知件名 | sSubjectNotification | Text(255) | 必須 | メール件名 |
| 返信通知本文 | sBodyNotification | RichText | 必須 | メール本文 |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| テーマ使用箇所 | テーマが使用されているページ一覧 |
| 推奨幅 | 現在のテンプレートに基づく推奨幅（px） |

## 表示項目

### 基本設定セクション

| 項目名 | フィールド型 | 備考 |
|--------|-------------|------|
| 名前 | text(40) | 最大255文字 |
| コード | text(10) | [QS_THEME:xxx]形式で表示 |
| タイプ | select | onchange="submit()" |
| モデレーター/ブロガー | select | タイプにより表示変更 |

### 投稿設定セクション

| 項目名 | フィールド型 | 備考 |
|--------|-------------|------|
| オンライン | checkbox | 公開状態 |
| ロック | checkbox | 新規投稿禁止 |
| HTML許可 | checkbox | onclick="submit()" |
| アップロード許可 | checkbox | HTML許可時のみ表示 |
| 埋め込み許可 | checkbox | HTML許可時のみ表示 |
| スマイリー | checkbox | - |
| 添付ファイル | checkbox | 匿名ユーザーは常に無効 |

### 表示設定セクション

| 項目名 | フィールド型 | 備考 |
|--------|-------------|------|
| コンパクト表示 | checkbox | タイトルのみ表示 |
| トピック文字数制限 | select | HTML非許可時のみ表示 |
| ページサイズ | select | 1-100件 |
| 偶数行カラー | text+colorpicker | JQColorPicker使用 |
| 奇数行カラー | text+colorpicker | JQColorPicker使用 |
| 幅 | select | 推奨幅を表示 |

### 返信設定セクション

| 項目名 | フィールド型 | 備考 |
|--------|-------------|------|
| 返信許可 | checkbox | onclick="submit()" |
| 匿名返信許可 | checkbox | 返信許可時のみ表示 |
| 名前ラベル | text(40) | 匿名返信許可時のみ表示 |
| 返信文字数制限 | select | 返信許可時のみ表示 |

### 通知設定セクション

| 項目名 | フィールド型 | 備考 |
|--------|-------------|------|
| トピック通知件名 | text(40) | 最大255文字 |
| トピック通知本文 | FCKEditor | siteBuilderRichTextSmall |
| 返信通知件名 | text(40) | 最大255文字 |
| 返信通知本文 | FCKEditor | siteBuilderRichTextSmall |

## イベント仕様

### 1-保存ボタンクリック

テーマ設定を保存する。

**処理詳細**:
1. checkCSRF()でトークン検証
2. theme.getRequestValues()でフォーム値取得
3. theme.save()でデータベース保存
4. 成功時「fb_saveOK」メッセージ表示

### 2-削除ボタンクリック

確認ダイアログ表示後、テーマを削除する。

**処理詳細**:
1. confirm()で確認ダイアログ表示
2. checkCSRF()でトークン検証
3. theme.remove()でテーマ削除
4. bs_themesList.aspにリダイレクト

### 3-タイプ変更

タイプ選択時にフォームを自動送信し、表示項目を切り替える。

**処理詳細**:
1. onchange="document.mainform.submit()"で送信
2. postBack=trueで再表示
3. タイプに応じて表示項目を動的に変更

### 4-HTML許可チェックボックス変更

HTML許可状態に応じて関連項目の表示を切り替える。

**処理詳細**:
1. onclick="document.mainform.submit()"で送信
2. bAllowHTML=trueでアップロード許可/埋め込み許可を表示
3. bAllowHTML=falseでトピック文字数制限を表示

### 5-返信許可チェックボックス変更

返信許可状態に応じて関連項目の表示を切り替える。

**処理詳細**:
1. onclick="document.mainform.submit()"で送信
2. bAllowComments=trueで匿名返信許可/返信文字数制限を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存（新規） | themes | INSERT | テーマレコード新規作成 |
| 保存（編集） | themes | UPDATE | テーマレコード更新 |
| 削除 | themes | DELETE | テーマレコード削除 |

### 更新フィールド

| フィールド | 説明 |
|-----------|------|
| sName | テーマ名 |
| sCode | テーマコード |
| iType | テーマタイプ |
| iContactID | モデレーター/ブロガーID |
| bForwardPostsToModerator | 投稿転送フラグ |
| bValidation | バリデーションフラグ |
| iSubLevel | サブスクリプションレベル |
| iSearchType | 検索タイプ |
| bOnline | オンラインフラグ |
| bLocked | ロックフラグ |
| bAllowHTML | HTML許可フラグ |
| bUpload | アップロード許可フラグ |
| bEmbed | 埋め込み許可フラグ |
| bSmileys | スマイリーフラグ |
| bFileUploads | ファイル添付フラグ |
| bCompactList | コンパクト表示フラグ |
| iLimitTopicTo | トピック文字数制限 |
| bAllowComments | 返信許可フラグ |
| bAllowAP | 匿名返信許可フラグ |
| sLabelYourName | 名前ラベル |
| iLimitReplyTo | 返信文字数制限 |
| iPageSize | ページサイズ |
| sColorEven | 偶数行カラー |
| sColorUnEven | 奇数行カラー |
| iWidth | 表示幅 |
| bPushRSS | RSSフラグ |
| sTopicSubjectNotification | トピック通知件名 |
| sTopicBodyNotification | トピック通知本文 |
| sSubjectNotification | 返信通知件名 |
| sBodyNotification | 返信通知本文 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| fb_saveOK | 成功 | 保存成功時 | 保存しました |
| areyousure | 確認 | 削除ボタンクリック時 | 削除しますか？ |
| mandatory | 注意 | 常時 | (*) 必須項目 |
| wherethemeused | 情報 | テーマ使用箇所あり | テーマが使用されている場所 |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| CSRFトークン不正 | checkCSRF()によりエラー |
| 保存失敗 | theme.save()がfalse返却、メッセージ非表示 |
| 必須項目未入力 | バリデーションエラー（詳細未確認） |

## 備考

- テーマタイプ定数：QS_theme_cd（コメントディスカッション）、QS_theme_ts（トピックサブスクリプション）
- タイプがトピックサブスクリプション時はiSubLevel、bPushRSSが隠しフィールドになる
- モデレーター選択はcontactSearchのcs_write,cs_readwrite権限ユーザーから選択
- JQColorPicker()でカラーピッカーUI生成
- createFCKInstance()でリッチテキストエディタ生成
- cls_fullSearchでテーマ使用箇所を検索（[QS_THEME:xxx]パターン）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テーマ管理で使用されるcls_themeクラスと関連リストクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | theme.asp | `asp/includes/theme.asp` | cls_themeクラスの全プロパティ、save(), remove(), getRequestValues()メソッド |
| 1-2 | （共通インクルード） | - | cls_themeTypeList, cls_theme_sublevelList, cls_siteSearchTypeListクラス |

**読解のコツ**:
- cls_themeは30以上のプロパティを持つ複雑なクラス
- getRequestValues()でフォームからプロパティに値をマッピング
- save()は新規/更新を自動判定（iIDの有無で判断）

#### Step 2: エントリーポイントを理解する

テーマ編集画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_themeEdit.asp | `asp/bs_themeEdit.asp` | 画面のメインロジック。フォーム処理、保存・削除、動的表示制御 |

**主要処理フロー**:
1. **行1-4**: インクルードファイル、セキュリティチェック
2. **行5-10**: cls_themeインスタンス作成、postBack処理
3. **行11-22**: ボタンアクション処理（save/delete）
4. **行23-30**: 関連リストクラスのインスタンス作成
5. **行30-37**: フォームHTML生成（条件分岐による表示制御）
6. **行38-49**: テーマ使用箇所検索（cls_fullSearch）

#### Step 3: 関連画面を理解する

テーマ一覧画面との連携を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_themesList.asp | `asp/bs_themesList.asp` | テーマ一覧表示、コピー処理 |

### プログラム呼び出し階層図

```
bs_themeEdit.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bTheme
    │
    ├─ cls_theme（テーマクラス）
    │      ├─ getRequestValues() - フォーム値取得
    │      ├─ save()             - データベース保存
    │      ├─ remove()           - データベース削除
    │      └─ recomWidth         - 推奨幅プロパティ
    │
    ├─ cls_themeTypeList（テーマタイプリスト）
    │      └─ showSelected()     - 選択リスト生成
    │
    ├─ cls_contactSearch（連絡先検索）
    │      └─ showSelected()     - 選択リスト生成
    │
    ├─ cls_theme_sublevelList（サブレベルリスト）
    │      └─ showSelected()     - 選択リスト生成
    │
    ├─ cls_siteSearchTypeList（検索タイプリスト）
    │      └─ showSelected()     - 選択リスト生成
    │
    ├─ cls_fullSearch（全文検索）
    │      ├─ pattern            - 検索パターン設定
    │      └─ search()           - 検索実行
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ JQColorPicker()（カラーピッカー生成）
    │
    ├─ createFCKInstance()（リッチテキストエディタ生成）
    │
    └─ numberList()（数値選択リスト生成）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ───▶ cls_theme取得 ───▶ フォーム初期値設定
(iThemeID)              │
                        ▼
フォーム送信 ───▶ postBack判定 ───▶ getRequestValues()
                        │
                        ▼
btnaction判定 ─────────────────────────────────────┐
        │                                         │
        ▼                                         ▼
    "save"                                    "delete"
        │                                         │
        ▼                                         ▼
checkCSRF() ───▶ theme.save() ───▶ fb_saveOK  checkCSRF() ───▶ theme.remove()
                                                  │
                                                  ▼
                                        bs_themesList.aspへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_themeEdit.asp | `asp/bs_themeEdit.asp` | ソース | テーマ編集画面のメイン処理 |
| bs_themesList.asp | `asp/bs_themesList.asp` | ソース | テーマ一覧画面（遷移元/遷移先） |
| theme.asp | `asp/includes/theme.asp` | ソース | cls_themeクラス定義 |
| urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URLエンコード関数 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | 管理画面ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | ソース | 管理画面フッター |
