# 画面設計書 79-ファビコン設定

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるファビコン設定画面（bs_favicon.asp）の設計仕様を定義する。

### 本画面の処理概要

ファビコン設定画面は、Webサイトのファビコン（ブラウザタブやブックマークに表示されるアイコン）を管理するための画面である。現在のファビコンの確認、新しいファビコンのアップロード、既存ファビコンの削除を行うことができる。

**業務上の目的・背景**：ファビコンはWebサイトのブランド認知に重要な要素であり、ブラウザのタブ、ブックマーク、履歴などに表示される。管理者は本画面を通じて独自のファビコンを設定し、サイトの視認性を向上させることができる。

**画面へのアクセス方法**：管理画面のセットアップメニューからページエレメント設定にアクセスし、ファビコン設定を選択。管理者権限（secondAdmin.bSetupPageElements）が必要。

**主要な操作・処理内容**：
1. 現在のファビコン表示 - 設定済みファビコンの確認
2. ファビコンアップロード - ICO形式のファイルをアップロード
3. ファビコン削除 - 既存ファビコンの削除

**画面遷移**：
- 遷移元：セットアップ > ページエレメントメニュー
- 遷移先：ファビコンアップロード画面（bs_faviconUpload.asp）- フォーム送信時

**権限による表示制御**：secondAdmin.bSetupPageElements権限がない場合はアクセス不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | ファビコン管理 | 主機能 | ファビコンの表示・アップロード・削除 |

## 画面種別

設定

## URL/ルーティング

`asp/bs_favicon.asp`

### パラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| btnaction | 任意 | String | アクション指定（removeFavicon） |

### POSTパラメータ

なし（アップロードはbs_faviconUpload.aspで処理）

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 新しいファビコン | favicon | File | - | アップロードするICOファイル |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| 現在のファビコン | 設定済みファビコンの画像表示 |
| ファビコン未設定メッセージ | ファビコンがない場合のメッセージ |

## 表示項目

### ファビコン情報テーブル

| 項目名 | フィールド型 | 備考 |
|--------|-------------|------|
| 現在のファビコン | 画像/テキスト | 設定時はimg、未設定時はメッセージ |
| 新しいファビコン | file | ICOファイル選択 |
| アップロードボタン | submit | アップロード実行 |
| ファビコン削除リンク | リンク | ファビコン設定時のみ表示 |

### 説明リンク

| 項目名 | 遷移先 |
|--------|--------|
| ファビコンとは？ | http://en.wikipedia.org/wiki/Favicon（外部リンク） |

## イベント仕様

### 1-アップロードボタンクリック

ファビコンファイルをbs_faviconUpload.aspにPOST送信する。

**処理詳細**:
1. ENCTYPE="multipart/form-data"でフォーム送信
2. QS_secCodeHiddenでCSRFトークン付与
3. bs_faviconUpload.aspで検証・保存処理

### 2-ファビコン削除リンククリック

確認ダイアログ表示後、ファビコンを削除する。

**処理詳細**:
1. confirm()で確認ダイアログ表示
2. bs_favicon.asp?btnaction=removeFaviconにアクセス
3. bs_process.aspで削除処理実行

### 3-「ファビコンとは？」リンククリック

Wikipedia（英語）のファビコン解説ページを新しいウィンドウで開く。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|------|---------|------|
| ファビコン削除 | customer | UPDATE | hasFavicon=false |
| ファビコン削除 | ファイルシステム | DELETE | userfiles/favicon.ico削除 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| whatisafavicon | リンク | 常時 | ファビコンとは？（Wikipedia） |
| currentfavicon | ラベル | 常時 | 現在のファビコン |
| nofavicon | 情報 | ファビコン未設定時 | ファビコンがありません |
| newfavicon | ラベル | 常時 | 新しいファビコン |
| upload | ボタン | 常時 | アップロード |
| removefavicon | リンク | ファビコン設定時 | ファビコンを削除 |
| areyousure | 確認 | 削除リンククリック時 | 削除しますか？ |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| 権限なし | セキュリティチェックにより画面アクセス拒否 |
| ファビコン未設定 | 「nofavicon」メッセージ表示 |
| 削除処理失敗 | bs_process.aspでエラー処理 |

## 備考

- ファビコンはuserfiles/favicon.icoとして保存される
- customer.hasFaviconプロパティでファビコン有無を管理
- ICOファイル形式のみ対応（16x16ピクセル推奨）
- bs_process.aspで削除処理（btnaction=removeFavicon）を実行
- IrfanViewなどの無料ツールでICO変換可能（コメント内に記載）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ファビコン管理で使用されるcustomerオブジェクトのプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | （共通インクルード） | - | customer.hasFaviconプロパティの構造 |

**読解のコツ**:
- customer.hasFaviconはBoolean型でファビコンの有無を管理
- ファビコンファイルは固定名（favicon.ico）でuserfiles配下に保存

#### Step 2: エントリーポイントを理解する

ファビコン設定画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_favicon.asp | `asp/bs_favicon.asp` | 画面のメインロジック。ファビコン表示、フォーム生成 |

**主要処理フロー**:
1. **行1-4**: インクルードファイル、セキュリティチェック、ヘッダー表示
2. **行4**: Wikipedia解説リンク表示
3. **行7**: フォーム定義（multipart/form-data、bs_faviconUpload.aspへPOST）
4. **行8**: CSRFトークン埋め込み
5. **行8**: 現在のファビコン表示（customer.hasFaviconで分岐）
6. **行8**: ファイル選択フィールド、アップロードボタン
7. **行8**: ファビコン削除リンク（設定時のみ表示）

#### Step 3: アップロード処理を理解する

ファビコンアップロード画面の処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_faviconUpload.asp | `asp/bs_faviconUpload.asp` | ファイル検証、保存、リダイレクト |

#### Step 4: 削除処理を理解する

bs_process.aspでの削除処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_process.asp | `asp/bs_process.asp` | btnaction=removeFaviconの処理 |

### プログラム呼び出し階層図

```
bs_favicon.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess secondAdmin.bSetupPageElements
    │
    ├─ bs_process.asp（アクション処理）
    │      └─ btnaction=removeFavicon - ファビコン削除
    │
    ├─ customer（顧客オブジェクト）
    │      └─ hasFavicon - ファビコン有無
    │
    └─ フォーム送信
           └─ bs_faviconUpload.asp（アップロード処理）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

画面アクセス ───▶ セキュリティチェック ───▶ 権限確認
                         │
                         ▼
                 customer.hasFavicon確認
                         │
            ┌────────────┼────────────┐
            ▼                         ▼
        true                       false
            │                         │
            ▼                         ▼
    ファビコン画像表示         「nofavicon」表示
    削除リンク表示

ファイル選択 ───▶ アップロードボタン ───▶ bs_faviconUpload.asp
                                              │
                                              ▼
                                        検証・保存・リダイレクト

削除リンク ───▶ confirm() ───▶ bs_process.asp
                                 (removeFavicon)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_favicon.asp | `asp/bs_favicon.asp` | ソース | ファビコン設定画面のメイン処理 |
| bs_faviconUpload.asp | `asp/bs_faviconUpload.asp` | ソース | ファビコンアップロード処理 |
| bs_process.asp | `asp/bs_process.asp` | ソース | 削除処理（removeFavicon） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | 管理画面ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | ソース | 管理画面フッター |
| favicon.ico | `userfiles/favicon.ico` | リソース | ファビコンファイル |
