# 画面設計書 8-コンテンツ付きアイテム編集

## 概要

本ドキュメントは、QuickerSite CMSのコンテンツ付きアイテム（通常ページ）の編集画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、WYSIWYGエディタを使用してページのコンテンツを編集するための主要な編集画面である。タイトル、本文コンテンツ、メタ情報、表示設定など、ページに関する全ての属性を設定できる。

**業務上の目的・背景**：CMSの中核機能として、技術的な知識がなくてもWebページのコンテンツを直感的に編集できることが目的である。WYSIWYGエディタにより、HTMLを知らなくてもWord感覚でページを作成・編集できる。

**画面へのアクセス方法**：ページ作成画面（bs_setupPage.asp）でコンテンツ付きアイテムを選択、またはバックサイトホームの既存ページをクリック、直接 `/asp/bs_editItem.asp?iId={暗号化ID}` へアクセス。

**主要な操作・処理内容**：
1. ページタイトルを入力する
2. WYSIWYGエディタで本文コンテンツを編集する
3. 表示順（ソート順）を設定する
4. 公開/非公開を設定する
5. ホームページフラグを設定する（条件付き）
6. フォーム、カタログ、フィードなどを関連付ける
7. テンプレート、テーマを選択する
8. メタタグ（キーワード、説明）を設定する
9. ユーザーフレンドリーURLを設定する
10. 保存、リセット、削除を実行する

**画面遷移**：
- 遷移元：bs_setupPage.asp（新規作成）、bs_default.asp（既存編集）
- 遷移先：bs_default.asp（保存後）、bs_delete.asp（削除時）、bs_selectPage.asp（移動時）

**権限による表示制御**：
- secondAdmin.bPageBody：本文エディタの表示/非表示
- secondAdmin.bPageSetHomepage：ホームページフラグの表示/非表示
- secondAdmin.bPagePublish：公開設定の表示/非表示
- secondAdmin.bPageOrder：ソート順の表示/非表示
- secondAdmin.bPageUrlRSS：RSS URL設定の表示/非表示
- その他多数の権限フラグで各項目を制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | WYSIWYGエディタによるコンテンツ編集 |
| 37 | アセットマネージャー | 補助機能 | 画像・ファイルの挿入・管理 |

## 画面種別

編集画面

## URL/ルーティング

- `/asp/bs_editItem.asp`
- `/asp/bs_editItem.asp?iId={暗号化ID}`（既存編集）
- `/asp/bs_editItem.asp?iParentID={暗号化ID}`（新規作成）
- `/asp/bs_editItem.asp?bLossePagina=true`（フリーページ作成）

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| ページID | iId | Hidden | 暗号化数値 | - | - | 編集対象ページID |
| 親ページID | iParentID | Hidden | 暗号化数値 | - | - | 親ページID |
| フリーページフラグ | bLossePagina | Hidden | Boolean | - | - | フリーページかどうか |
| ボタンアクション | btnaction | Hidden | 文字列 | - | - | 保存時は多言語「save」 |
| タイトル | sTitle | 入力 | 文字列 | 255 | 必須 | ページタイトル |
| 本文 | sValue | 入力 | HTML | - | - | WYSIWYGエディタで編集 |
| 公開フラグ | bOnline | Checkbox | Boolean | - | - | 公開/非公開 |
| ホームページフラグ | bHomePage | Checkbox | Boolean | - | - | トップページ設定 |
| ソート順 | iRang | 入力 | 数値 | - | - | 表示順序 |
| テンプレートID | iTemplateID | Select | 数値 | - | - | 使用テンプレート |
| フォームID | iFormID | Select | 数値 | - | - | 関連フォーム |
| カタログID | iCatalogId | Select | 数値 | - | - | 関連カタログ |
| フィードID | iFeedId | Select | 数値 | - | - | 関連フィード |
| テーマID | iThemeID | Select | 数値 | - | - | 関連テーマ |
| キーワード | sKeywords | 入力 | 文字列 | - | - | SEO用キーワード |
| 説明 | sDescription | 入力 | 文字列 | - | - | SEO用説明文 |
| ユーザーフレンドリーURL | sUserFriendlyURL | 入力 | 文字列 | 49 | - | SEOフレンドリーURL |
| RSS URL | sRSSLink | 入力 | 文字列 | 250 | - | RSS配信URL |
| リダイレクト先 | sRedirectTo | 入力 | 文字列 | - | - | リダイレクト先URL |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| BOヘッダー | 上部 | バックサイト共通ヘッダー |
| 「Item with content」ヘッダー | フォーム上部 | 画面タイプ表示 |
| 共通項目（bs_common.asp） | フォーム内 | タイトル等の共通入力項目 |
| ソート順（bs_sortorder.asp） | フォーム内 | 表示順序設定 |
| 公開設定（bs_onlineOrNot.asp） | フォーム内 | 公開/非公開設定 |
| WYSIWYGエディタ | 中央 | CKEditor等のリッチエディタ |
| URL設定（bs_url.asp） | フォーム内 | ユーザーフレンドリーURL |
| フィード設定（bs_feed.asp） | フォーム内 | 関連フィード選択 |
| カタログ設定（bs_catalog.asp） | フォーム内 | 関連カタログ選択 |
| フォーム設定（bs_form.asp） | フォーム内 | 関連フォーム選択 |
| アプリケーション設定（bs_application.asp） | フォーム内 | カスタムスクリプト |
| テーマ設定（bs_theme.asp） | フォーム内 | 関連テーマ選択 |
| リダイレクト設定（bs_redirectTO.asp） | フォーム内 | リダイレクト先URL |
| テンプレート設定（bs_template.asp） | フォーム内 | 使用テンプレート選択 |
| メタタグ設定（bs_metaTags.asp） | フォーム内 | SEO用メタ情報 |
| 必須マーク説明 | フォーム下部 | 「(*) mandatory」 |
| 保存ボタン | フォーム下部 | 保存実行 |
| リセットボタン | フォーム下部 | 入力リセット |
| 削除ボタン（bs_deleteButton.asp） | フォーム下部 | 削除実行（条件付き） |

## イベント仕様

### 1-保存ボタン押下

**処理フロー**：
1. CSRFトークンチェック（checkCSRF）
2. page.getRequestValues()でフォーム値を取得
3. page.save()でデータベースに保存
4. 成功時：fb_saveOKメッセージを追加
5. 画面を再表示

### 2-削除ボタン押下

**処理フロー**：
1. JavaScript deletePage()関数でconfirm確認
2. 確認後、btnactionを「delete」に変更してsubmit
3. bs_processPage.aspで削除処理
4. page.bDeleted=true、page.bOnline=false設定
5. 親ページのremoveRang呼び出し
6. リストアイテム削除（deleteListItems）
7. bs_default.aspまたはbs_intranet.aspへリダイレクト

### 3-リセットボタン押下

**処理フロー**：
1. HTMLのtype="reset"によりフォームをリセット

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存（新規） | tblPage | INSERT | 新規ページレコード作成 |
| 保存（更新） | tblPage | UPDATE | 既存ページレコード更新 |
| 削除 | tblPage | UPDATE | bDeleted=true、bOnline=false |

### テーブル別更新項目詳細

#### tblPage（保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sTitle | Request.Form("sTitle") | タイトル |
| INSERT/UPDATE | sValue | Request.Form("sValue") | 本文HTML |
| INSERT/UPDATE | bOnline | Request.Form("bOnline") | 公開フラグ |
| INSERT/UPDATE | bHomepage | Request.Form("bHomePage") | ホームページフラグ |
| INSERT/UPDATE | iRang | Request.Form("iRang") | ソート順 |
| INSERT/UPDATE | iTemplateID | Request.Form("iTemplateID") | テンプレートID |
| INSERT/UPDATE | iFormID | Request.Form("iFormID") | フォームID |
| INSERT/UPDATE | iCatalogId | Request.Form("iCatalogId") | カタログID |
| INSERT/UPDATE | iFeedId | Request.Form("iFeedId") | フィードID |
| INSERT/UPDATE | iThemeID | Request.Form("iThemeID") | テーマID |
| INSERT/UPDATE | sKeywords | Request.Form("sKeywords") | キーワード |
| INSERT/UPDATE | sDescription | Request.Form("sDescription") | 説明文 |
| INSERT/UPDATE | sUserFriendlyURL | Request.Form("sUserFriendlyURL") | フレンドリーURL |
| INSERT/UPDATE | sRSSLink | Request.Form("sRSSLink") | RSS URL |
| INSERT/UPDATE | sRedirectTo | Request.Form("sRedirectTo") | リダイレクト先 |
| INSERT/UPDATE | updatedTS | now() | 更新日時 |
| INSERT | createdTS | now() | 作成日時（新規のみ） |
| INSERT | iCustomerID | cId | 顧客ID（新規のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存完了メッセージ | 保存成功時 |
| deletecomplete | 確認 | 削除確認メッセージ | 削除ボタン押下時 |
| mandatory | 情報 | 必須項目の説明 | 常時表示 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態 | bs_security.aspによりログイン画面へリダイレクト |
| 必須項目未入力 | エラーメッセージ表示、画面再表示 |
| CSRFトークン不正 | エラー処理 |

## 備考

- WYSIWYGエディタはcreateFCKInstance関数で生成される
- エディタの種類はQS_EDITOR変数で切り替え可能（CKEditor等）
- ホームページフラグは親ページが公開中で、現在がホームページでない場合のみ表示
- フリーページ（bLossePagina=true）の場合は特殊な処理が適用される
- 多数のインクルードファイルでモジュール化されており、権限に応じて各セクションが表示制御される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページエンティティの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラスの全プロパティと保存ロジック |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | 権限フラグの定義 |

**読解のコツ**: tblPageテーブルはページの全情報を格納する。sValueがHTMLコンテンツを保持する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editItem.asp | `asp/bs_editItem.asp` | コンテンツ編集画面のメインファイル |

**主要処理フロー**:
1. **行4**: bs_security.asp、bs_process.aspのインクルード
2. **行4**: bs_processPage.aspのインクルード（保存/削除処理）
3. **行4**: createFCKInstance関数でWYSIWYGエディタ生成
4. **行5-8**: ホームページフラグの条件付き表示
5. **行16**: 各種インクルードファイルでフォーム構成

#### Step 3: 保存処理を理解する

ページ保存のロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_processPage.asp | `asp/bs_processPage.asp` | 保存・削除の処理ロジック |
| 3-2 | page.asp | `asp/includes/page.asp` | getRequestValues関数、save関数 |

**主要処理フロー**:
- **bs_processPage.asp 行12-25**: Select Caseで処理分岐
- **page.asp save関数**: INSERT/UPDATEのSQL実行

#### Step 4: エディタを理解する

WYSIWYGエディタの統合方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ckeditor.asp | `asp/includes/ckeditor.asp` | createFCKInstance関数の定義 |

### プログラム呼び出し階層図

```
bs_editItem.asp (エントリーポイント)
    │
    ├─ bs_security.asp (認証チェック)
    │
    ├─ bs_process.asp (共通処理)
    │
    ├─ bs_processPage.asp (保存/削除処理)
    │      ├─ checkCSRF()
    │      ├─ page.getRequestValues()
    │      └─ page.save()
    │
    ├─ createFCKInstance() (エディタ生成)
    │
    └─ インクルードファイル群
           ├─ bs_common.asp (共通項目)
           ├─ bs_sortorder.asp (ソート順)
           ├─ bs_onlineOrNot.asp (公開設定)
           ├─ bs_url.asp (URL設定)
           ├─ bs_feed.asp (フィード)
           ├─ bs_catalog.asp (カタログ)
           ├─ bs_form.asp (フォーム)
           ├─ bs_template.asp (テンプレート)
           └─ bs_metaTags.asp (メタタグ)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ────────▶ getRequestValues() ─────▶ cls_pageオブジェクト
                              │
                              ▼
                         save()
                              │
                              ▼
                         tblPage ──────────────▶ 保存完了メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | コンテンツ編集画面メイン |
| bs_processPage.asp | `asp/bs_processPage.asp` | インクルード | 保存/削除処理 |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| ckeditor.asp | `asp/includes/ckeditor.asp` | インクルード | WYSIWYGエディタ |
| bs_common.asp | `asp/bs_common.asp` | インクルード | 共通入力項目 |
| bs_sortorder.asp | `asp/bs_sortorder.asp` | インクルード | ソート順設定 |
| bs_onlineOrNot.asp | `asp/bs_onlineOrNot.asp` | インクルード | 公開設定 |
| bs_url.asp | `asp/bs_url.asp` | インクルード | URL設定 |
| bs_feed.asp | `asp/bs_feed.asp` | インクルード | フィード選択 |
| bs_catalog.asp | `asp/bs_catalog.asp` | インクルード | カタログ選択 |
| bs_form.asp | `asp/bs_form.asp` | インクルード | フォーム選択 |
| bs_template.asp | `asp/bs_template.asp` | インクルード | テンプレート選択 |
| bs_metaTags.asp | `asp/bs_metaTags.asp` | インクルード | メタタグ設定 |
| bs_deleteButton.asp | `asp/bs_deleteButton.asp` | インクルード | 削除ボタン |
