# 画面設計書 80-ファビコンアップロード

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるファビコンアップロード画面（bs_faviconUpload.asp）の設計仕様を定義する。

### 本画面の処理概要

ファビコンアップロード画面は、ファビコン設定画面（bs_favicon.asp）からのファイルアップロードを処理するバックエンド処理画面である。アップロードされたファイルの検証（ファイル形式、サイズ）、ファイル名の変更（favicon.icoへのリネーム）、データベース更新を行い、処理完了後にファビコン設定画面へリダイレクトする。

**業務上の目的・背景**：ファビコンファイルのアップロード時に、適切な検証とファイル管理を行う。ICOファイル形式のみを許可し、ファイルサイズ制限を設けることで、サーバーリソースの保護とブラウザ互換性を確保する。

**画面へのアクセス方法**：ファビコン設定画面（bs_favicon.asp）のフォーム送信により自動的にアクセスされる。直接アクセスは想定されていない。

**主要な操作・処理内容**：
1. マルチパートフォームデータの受信
2. CSRFトークン検証
3. ファイル形式検証（ICOのみ許可）
4. ファイルサイズ検証（20KB以下）
5. ファイル名変更（favicon.ico）
6. データベース更新（customer.hasFavicon=true）
7. 結果画面へのリダイレクト

**画面遷移**：
- 遷移元：ファビコン設定画面（bs_favicon.asp）- フォームPOST
- 遷移先：ファビコン設定画面（bs_favicon.asp）- 処理完了後リダイレクト

**権限による表示制御**：bs_security.aspをインクルードしないが、CSRFトークン検証で不正アクセスを防止。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | ファビコン管理 | 主機能 | ファビコンファイルのアップロード処理 |

## 画面種別

処理（バックエンド）

## URL/ルーティング

`asp/bs_faviconUpload.asp`

### パラメータ

なし（POSTリクエストのみ受付）

### POSTパラメータ

| パラメータ名 | 必須 | 型 | 説明 |
|-------------|------|-----|------|
| favicon | 必須 | File | アップロードするICOファイル |
| QSSEC | 必須 | String | CSRFトークン |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ファビコンファイル | favicon | File | 必須 | ICO形式、20KB以下 |
| CSRFトークン | QSSEC | Hidden | 必須 | セキュリティトークン |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| リダイレクト | 処理結果に応じてbs_favicon.aspへリダイレクト |

## 表示項目

本画面はバックエンド処理のため、表示項目はなし。

## イベント仕様

### 1-ファイルアップロード処理

マルチパートフォームデータを受信し、ファビコンファイルを処理する。

**処理詳細**:
1. server.MapPath()でuserfilesディレクトリのパスを取得
2. FreeASPUploadクラスでマルチパートデータを解析・保存
3. checkCSRF_Upload()でCSRFトークン検証
4. UploadedFiles.keysでアップロードファイルをループ処理
5. ファイル形式検証（GetFileExtension()でICO以外はエラー）
6. ファイルサイズ検証（20000バイト超過はエラー）
7. エラー時はファイル削除、エラーメッセージを蓄積
8. 成功時はfavicon.icoにリネーム
9. customer.hasFavicon=true、customer.save()でデータベース更新
10. bs_favicon.aspへリダイレクト（エラー時はstrMessageパラメータ付き）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップロード成功 | customer | UPDATE | hasFavicon=true |

### 更新フィールド

| フィールド | 説明 |
|-----------|------|
| hasFavicon | ファビコン有無フラグ（true） |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| err_ICO_file | エラー | 拡張子がico以外の場合 | ICOファイル形式エラー |
| err_ICO_fileSize | エラー | ファイルサイズが20KB超過 | ファイルサイズエラー |
| err_newFile | エラー | ファイルが選択されていない場合 | ファイル未選択エラー |

## 例外処理

| 状況 | 処理内容 |
|------|---------|
| CSRFトークン不正 | checkCSRF_Upload()によりエラー |
| ファイル形式不正 | ファイル削除、err_ICO_fileメッセージ |
| ファイルサイズ超過 | ファイル削除、err_ICO_fileSizeメッセージ |
| ファイル未選択 | err_newFileメッセージ |
| 保存失敗 | customer.save()がfalse、リダイレクトせず |

## 備考

- FreeASPUploadクラスを使用してマルチパートフォームデータを処理
- アップロード先はserver.MapPath(C_VIRT_DIR & Application("QS_CMS_userfiles"))
- ファイルサイズ制限は20KB（20000バイト）
- ICOファイル形式のみ許可（GetFileExtension()で判定）
- アップロード後は固定名「favicon.ico」にリネーム
- 複数エラーがある場合はカンマ区切りで連結（strMessage）
- エラー時はstrMessageをURLエンコードしてリダイレクト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アップロード処理で使用されるFreeASPUploadクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | （共通インクルード） | - | FreeASPUploadクラスの構造（Save, UploadedFiles, form, delete, rename） |

**読解のコツ**:
- FreeASPUploadはマルチパートフォームデータを解析するクラス
- UploadedFilesコレクションにアップロードされたファイル情報が格納
- UploadedFiles(key).FileName, .Length, .delete(), .rename()メソッドが重要

#### Step 2: エントリーポイントを理解する

ファビコンアップロード画面のメインファイルを読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_faviconUpload.asp | `asp/bs_faviconUpload.asp` | 画面のメインロジック。ファイル検証、リネーム、リダイレクト |

**主要処理フロー**:
1. **行1-5**: インクルードファイル、アップロード先ディレクトリ設定
2. **行6-8**: FreeASPUploadインスタンス作成、Save()でファイル保存
3. **行9**: checkCSRF_Upload()でCSRFトークン検証
4. **行10-11**: アップロードファイルキー取得
5. **行12-26**: ファイル処理ループ
   - 行14-16: 拡張子検証（ico以外はエラー）
   - 行17-19: サイズ検証（20KB超過はエラー）
   - 行20-24: エラー時はファイル削除、成功時はリネーム
6. **行27-29**: ファイル未選択エラー
7. **行30-34**: 結果に応じたリダイレクト

#### Step 3: 遷移元画面を理解する

ファビコン設定画面からの遷移を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_favicon.asp | `asp/bs_favicon.asp` | フォーム定義、アップロードボタン |

### プログラム呼び出し階層図

```
bs_faviconUpload.asp
    │
    ├─ begin.asp（共通初期化）
    │
    ├─ FreeASPUpload（アップロードクラス）
    │      ├─ Save()              - ファイル保存
    │      ├─ UploadedFiles       - アップロードファイルコレクション
    │      │      ├─ .keys        - ファイルキー取得
    │      │      ├─ .FileName    - ファイル名
    │      │      ├─ .Length      - ファイルサイズ
    │      │      ├─ .delete()    - ファイル削除
    │      │      └─ .rename()    - ファイル名変更
    │      └─ form()              - フォームフィールドアクセス
    │
    ├─ checkCSRF_Upload()（CSRF検証）
    │
    ├─ GetFileExtension()（拡張子取得）
    │
    └─ customer（顧客オブジェクト）
           ├─ hasFavicon    - ファビコンフラグ設定
           └─ save()        - データベース保存
```

### データフロー図

```
[入力]                    [処理]                         [出力]

POSTデータ ───▶ server.MapPath() ───▶ アップロード先パス取得
(multipart/form-data)     │
                          ▼
                FreeASPUpload.Save() ───▶ ファイル保存
                          │
                          ▼
              checkCSRF_Upload() ───▶ トークン検証
                          │
                          ▼
               ファイル存在確認
                          │
         ┌────────────────┼────────────────┐
         ▼                ▼                ▼
    ファイルあり      ファイルなし
         │                │
         ▼                ▼
  GetFileExtension()  err_newFile
         │
    ico判定
         │
    ┌────┴────┐
    ▼         ▼
  ico      それ以外
    │         │
    ▼         ▼
サイズ検証  err_ICO_file
    │      ファイル削除
    ▼
 20KB以下?
    │
┌───┴───┐
▼       ▼
OK    超過
│       │
▼       ▼
rename  err_ICO_fileSize
"favicon.ico"  ファイル削除
│
▼
customer.hasFavicon=true
customer.save()
│
▼
bs_favicon.aspへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_faviconUpload.asp | `asp/bs_faviconUpload.asp` | ソース | ファビコンアップロード処理 |
| bs_favicon.asp | `asp/bs_favicon.asp` | ソース | ファビコン設定画面（遷移元/遷移先） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理（本画面では未使用） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| favicon.ico | `userfiles/favicon.ico` | リソース | アップロード先ファビコンファイル |
