# 画面設計書 81-ピール設定

## 概要

本ドキュメントは、QuickerSite CMSのピール設定画面（bs_peel.asp）の画面設計書です。ページコーナーに表示されるピール広告（ページめくり効果の広告）の設定機能を提供します。

### 本画面の処理概要

この画面では、ウェブサイトのページコーナーに表示されるピール広告（Page Peel）の設定を行います。ピール広告とは、ページの角がめくれるようなエフェクトで表示される広告形式で、訪問者の注目を集めるマーケティングツールとして使用されます。

**業務上の目的・背景**：サイト運営者がプロモーションや特別なお知らせを目立たせるために、ピール広告を活用することで、通常のバナー広告よりも高いクリック率を期待できます。この機能により、コーディング知識がなくても視覚的に魅力的な広告効果を簡単に設定できます。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、「Setup」メニューから「Page Elements」を選択し、ピール設定画面にアクセスします。アクセスにはsecondAdmin.bSetupPageElements権限が必要です。

**主要な操作・処理内容**：
1. ピールクリック時の遷移先URLを設定
2. フリップカラー（めくれ部分の色）を16種類から選択
3. アイドル時のピールサイズ（50px〜300px）を設定
4. アクティブ時のピールサイズ（200px〜700px）を設定
5. 新しいウィンドウで開くオプションの設定
6. ピール機能の有効/無効切り替え
7. ピール画像のアップロード画面への遷移

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）、設定メニュー
- 遷移先：ピール選択画面（bs_selectPeel.asp）

**権限による表示制御**：secondAdmin.bSetupPageElements権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | ピール広告 | 主機能 | ページコーナーに表示されるピール広告の設定 |

## 画面種別

設定（編集）

## URL/ルーティング

`asp/bs_peel.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| URL | sPeelURL | 入力 | 文字列 | * | 250 | ピールクリック時の遷移先URL |
| 新しいウィンドウで開く | bPeelOINW | 入力 | Boolean | - | - | リンクを新しいウィンドウで開くか |
| フリップカラー | sPeelFlipColor | 入力 | 数値 | * | - | めくれ部分の色（0〜15） |
| アイドル時サイズ | sPeelIdleSize | 入力 | 数値 | - | - | 待機時のサイズ（50〜300px） |
| アクティブ時サイズ | sPeelMOSize | 入力 | 数値 | - | - | マウスオーバー時のサイズ（200〜700px） |
| 有効化 | bPeelEnabled | 入力 | Boolean | - | - | ピール機能の有効/無効 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| フリップカラー選択 | 16種類のカラーパターンを画像で表示 |
| 現在のピール画像 | 設定済みの場合、プレビュー画像を表示 |
| ダウンロードリンク | 現在のピール画像のダウンロードリンク |

## イベント仕様

### 1-保存ボタン押下

保存ボタン（SUBMIT1）押下時、以下の処理が実行されます：
1. CSRF検証（checkCSRF）
2. 入力値のバリデーション（URL、フリップカラーが必須）
3. customerオブジェクトへの値設定
4. データベースへの保存（customer.save）
5. ピール画像が未設定の場合はbs_selectPeel.aspへリダイレクト
6. 設定済みの場合は成功メッセージ付きで自画面へリダイレクト

### 2-削除ボタン押下

削除ボタン（btnDelete）押下時、確認ダイアログ後に以下の処理が実行されます：
1. CSRF検証
2. ピール関連の全項目を初期化
3. データベースへの保存
4. 成功メッセージ付きで自画面へリダイレクト

### 3-ピール画像アップロードリンク

「Upload your peel-image」リンククリック時、bs_selectPeel.aspへ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | ピール設定の保存 |
| 削除ボタン押下 | tblCustomer | UPDATE | ピール設定の初期化 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPeelURL | フォーム入力値（最大255文字） | 遷移先URL |
| UPDATE | bPeelEnabled | フォーム入力値（Boolean） | 有効/無効フラグ |
| UPDATE | bPeelOINW | フォーム入力値（Boolean） | 新しいウィンドウで開く |
| UPDATE | sPeelFlipColor | フォーム入力値（0〜15） | フリップカラー |
| UPDATE | sPeelIdleSize | フォーム入力値（50〜300） | アイドル時サイズ |
| UPDATE | sPeelMOSize | フォーム入力値（200〜700） | アクティブ時サイズ |
| UPDATE | sPeelImage | 空文字（削除時） | ピール画像ファイル名 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存が正常に完了しました | 保存成功時 |
| err_mandatory | エラー | 必須項目が入力されていません | URL・フリップカラー未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | logon.hasaccessでアクセス拒否 |
| CSRFトークン不正 | checkCSRFで処理中断 |
| 必須項目未入力 | エラーメッセージ表示、処理中断 |

## 備考

- ピール画像はPNG、JPG、GIF形式のみ対応
- フリップカラー画像は`/fixedImages/peels/pageflip{0-15}.png`に格納
- デフォルト値：アイドル時サイズ70px、アクティブ時サイズ300px

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ピール設定に関連するデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのピール関連プロパティ（sPeelURL, bPeelEnabled, sPeelImage等）を確認 |

**読解のコツ**: cls_customerクラスの16〜17行目にピール関連のプロパティ宣言があります。Save関数（300行目以降）でデータベースへの保存処理を確認できます。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_peel.asp | `asp/bs_peel.asp` | 画面表示とフォーム構造を理解 |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（bs_security.asp）とアクセス権限確認
2. **5-12行目**: デフォルト値の設定（URL、サイズ）
3. **13-23行目**: フリップカラー選択UIの生成ループ
4. **24-29行目**: 現在のピール画像プレビュー表示

#### Step 3: 保存処理を理解する

フォーム送信後の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | 「savepeel」アクションの処理（185〜213行目） |

**主要処理フロー**:
- **186行目**: CSRF検証
- **187-196行目**: 削除処理（btnDeleteが押された場合）
- **198-212行目**: 保存処理（入力値検証とcustomer.save呼び出し）

### プログラム呼び出し階層図

```
bs_peel.asp
    |
    +-- bs_security.asp (認証・権限チェック)
    |       +-- logon.hasaccess (secondAdmin.bSetupPageElements)
    |
    +-- bs_process.asp (フォーム処理)
    |       +-- checkCSRF() (CSRF検証)
    |       +-- customer.save() (データ保存)
    |
    +-- includes/customer.asp
            +-- cls_customer.Save() (DB更新)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ───────> bs_process.asp ───────> tblCustomer
(URL, カラー,        (savepeel処理)          (UPDATE)
 サイズ設定)                |
                           v
                    customer.save()
                           |
                           v
                    リダイレクト
                    (bs_peel.asp or
                     bs_selectPeel.asp)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_peel.asp | `asp/bs_peel.asp` | ソース | 画面表示・フォーム定義 |
| bs_process.asp | `asp/bs_process.asp` | ソース | フォーム送信処理 |
| bs_selectPeel.asp | `asp/bs_selectPeel.asp` | ソース | ピール画像選択画面 |
| bs_peelUpload.asp | `asp/bs_peelUpload.asp` | ソース | ピール画像アップロード処理 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客データモデル |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| pageflip{0-15}.png | `fixedImages/peels/` | 画像 | フリップカラー画像 |
