# 画面設計書 82-ピール選択

## 概要

本ドキュメントは、QuickerSite CMSのピール選択画面（bs_selectPeel.asp）の画面設計書です。ピール広告に使用する画像をアップロードするためのファイル選択画面を提供します。

### 本画面の処理概要

この画面では、ピール広告として表示する画像ファイルを選択してアップロードするための操作を行います。ピール設定画面（bs_peel.asp）でURL等の基本設定を完了した後、この画面で実際の広告画像を設定します。

**業務上の目的・背景**：ピール広告の視覚的なコンテンツを設定するために、管理者が任意の画像をアップロードできる機能を提供します。PNG、JPG、GIF形式の画像に対応しており、ページコーナーのめくれ効果に適した画像を設定できます。

**画面へのアクセス方法**：ピール設定画面（bs_peel.asp）でStep 1の設定を完了した後、「Upload your peel-image」リンクをクリックしてアクセスします。直接URLでもアクセス可能ですが、secondAdmin.bSetupPageElements権限が必要です。

**主要な操作・処理内容**：
1. アップロードするピール画像ファイルを選択
2. アップロードボタンを押下して画像をサーバーにアップロード
3. アップロード成功時はピール設定画面に戻る
4. エラー時はエラーメッセージ付きで自画面に戻る

**画面遷移**：
- 遷移元：ピール設定画面（bs_peel.asp）
- 遷移先：ピール設定画面（bs_peel.asp）、ピールアップロード処理（bs_peelUpload.asp）

**権限による表示制御**：secondAdmin.bSetupPageElements権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | ピール広告 | 主機能 | ピール画像の選択 |

## 画面種別

アップロード（ファイル選択）

## URL/ルーティング

`asp/bs_selectPeel.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| ピール画像 | peel | 入力 | ファイル | * | 2MB | アップロードする画像ファイル（PNG/JPG/GIF） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ファイル選択フィールド | 画像ファイルを選択するためのinput[type=file] |
| アップロードボタン | ファイルをアップロードするボタン |
| 戻るボタン | ピール設定画面に戻るボタン |

## イベント仕様

### 1-アップロードボタン押下

アップロードボタン押下時、以下の処理が実行されます：
1. ボタンテキストを「Please wait...」に変更
2. ボタンを無効化（二重送信防止）
3. フォームをbs_peelUpload.aspに送信
4. multipart/form-dataエンコーディングでファイルを送信

### 2-戻るボタン押下

戻るボタン押下時、JavaScriptでbs_peel.aspにリダイレクトします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップロードボタン押下 | - | - | この画面自体ではDB更新なし（bs_peelUpload.aspで処理） |

### テーブル別更新項目詳細

この画面はファイル選択のみを行い、実際のデータベース更新はbs_peelUpload.aspで実行されます。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_fileType | エラー | 対応していないファイル形式です | PNG/JPG/GIF以外のファイルの場合 |
| err_fileSize | エラー | ファイルサイズが大きすぎます | 2MB超過の場合 |
| err_newFile | エラー | ファイルが選択されていません | ファイル未選択の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | logon.hasaccessでアクセス拒否 |
| ファイル未選択 | エラーメッセージ付きで自画面にリダイレクト |
| 不正なファイル形式 | アップロードファイルを削除しエラーメッセージ表示 |
| ファイルサイズ超過 | アップロードファイルを削除しエラーメッセージ表示 |

## 備考

- 対応ファイル形式：PNG、JPG、GIF
- 最大ファイルサイズ：2MB（2,000,000バイト）
- アップロード処理はbs_peelUpload.aspで実行される
- CSRFトークンがhiddenフィールドとして含まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ファイルアップロードに関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sPeelImageプロパティの定義を確認 |

**読解のコツ**: ファイルアップロード処理ではFreeASPUploadクラスが使用されています。アップロードされたファイル名はcustomer.sPeelImageに保存されます。

#### Step 2: エントリーポイントを理解する

画面表示の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_selectPeel.asp | `asp/bs_selectPeel.asp` | フォーム構造とファイルアップロードUIを理解 |

**主要処理フロー**:
1. **4行目**: セキュリティチェックと権限確認（secondAdmin.bSetupPageElements）
2. **4行目**: フォーム定義（ENCTYPE="multipart/form-data"、ACTION="bs_PeelUpload.asp"）
3. **5行目**: CSRFトークン（QS_secCodeHidden）
4. **5行目**: ファイル入力フィールド（INPUT TYPE="FILE" NAME="peel"）

#### Step 3: アップロード処理を理解する

ファイル送信後の処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_peelUpload.asp | `asp/bs_peelUpload.asp` | アップロード処理の詳細（検証、保存、リダイレクト） |

**主要処理フロー**:
- **5-8行目**: アップロードディレクトリの設定とファイル保存
- **9行目**: CSRFトークン検証（checkCSRF_Upload）
- **14-18行目**: ファイル形式の検証（png, jpg, gif）
- **22-24行目**: ファイルサイズの検証（2MB上限）
- **29-32行目**: ファイル名の生成とリネーム
- **40行目**: 成功時のリダイレクト（bs_peel.asp）
- **42行目**: エラー時のリダイレクト（自画面）

### プログラム呼び出し階層図

```
bs_selectPeel.asp (ファイル選択画面)
    |
    +-- bs_security.asp (認証・権限チェック)
    |       +-- logon.hasaccess (secondAdmin.bSetupPageElements)
    |
    +-- [フォーム送信]
            |
            v
        bs_peelUpload.asp (アップロード処理)
            |
            +-- FreeASPUpload.Save() (ファイル保存)
            +-- checkCSRF_Upload() (CSRF検証)
            +-- GetFileExtension() (拡張子取得)
            +-- generatePassword() (ランダム文字列生成)
            +-- customer.save() (DB保存)
            |
            +-- [成功] --> bs_peel.asp
            +-- [エラー] --> bs_selectPeel.asp?strMessage=...
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイル選択 ───────> bs_peelUpload.asp ───────> userfiles/
(peel)               FreeASPUpload.Save()        peel_xxx.{ext}
                           |
                           v
                    ファイル検証
                    (形式・サイズ)
                           |
                    +------+------+
                    |             |
                    v             v
                [成功]        [エラー]
                    |             |
                    v             v
            customer.sPeelImage  strMessage
                = peelName        設定
                    |             |
                    v             v
            bs_peel.asp      bs_selectPeel.asp
            へリダイレクト    へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_selectPeel.asp | `asp/bs_selectPeel.asp` | ソース | ファイル選択画面 |
| bs_peelUpload.asp | `asp/bs_peelUpload.asp` | ソース | アップロード処理 |
| bs_peel.asp | `asp/bs_peel.asp` | ソース | ピール設定画面（遷移元/先） |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客データモデル |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| FreeASPUpload | 外部ライブラリ | ソース | ファイルアップロード処理クラス |
