# 画面設計書 83-ピールアップロード

## 概要

本ドキュメントは、QuickerSite CMSのピールアップロード画面（bs_peelUpload.asp）の画面設計書です。ピール選択画面から送信されたファイルを処理し、サーバーに保存する処理を担当します。

### 本画面の処理概要

この画面は、ピール選択画面（bs_selectPeel.asp）から送信されたピール画像ファイルを受け取り、検証・保存を行うバックエンド処理画面です。ユーザーに表示されるUIはなく、処理完了後は自動的にリダイレクトされます。

**業務上の目的・背景**：ピール広告機能において、管理者がアップロードした画像ファイルを安全に受け取り、適切な場所に保存するためのサーバーサイド処理を提供します。ファイル形式やサイズの検証を行い、不正なファイルのアップロードを防止します。

**画面へのアクセス方法**：この画面はピール選択画面からのフォーム送信（POST）によってのみアクセスされます。直接アクセスはセキュリティチェックにより拒否されます。

**主要な操作・処理内容**：
1. アップロードファイルをサーバーの一時領域に保存
2. CSRFトークンの検証
3. ファイル形式の検証（PNG/JPG/GIF）
4. ファイルサイズの検証（2MB以下）
5. 検証成功時はファイルをリネームして保存
6. customerオブジェクトに画像ファイル名を設定
7. データベースに保存
8. 処理結果に応じてリダイレクト

**画面遷移**：
- 遷移元：ピール選択画面（bs_selectPeel.asp）からのPOST
- 遷移先：ピール設定画面（bs_peel.asp）または エラー時ピール選択画面

**権限による表示制御**：bs_security.aspによるセッション認証が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | ピール広告 | 主機能 | ピール画像のアップロード |

## 画面種別

処理（バックエンド処理画面）

## URL/ルーティング

`asp/bs_peelUpload.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| CSRFトークン | QSSEC | 入力 | 文字列 | * | - | CSRF検証用トークン |
| ピール画像 | peel | 入力 | ファイル | * | 2MB | アップロードする画像ファイル |

## 表示項目

この画面にはUIがなく、表示項目はありません。処理完了後は自動的にリダイレクトされます。

## イベント仕様

### 1-ファイル受信・検証処理

ピール選択画面からのPOSTを受信した際の処理：

1. **ファイル保存**：FreeASPUploadクラスを使用してアップロードファイルを一時保存
2. **CSRF検証**：checkCSRF_Upload関数でトークンを検証
3. **ファイル形式検証**：拡張子がpng, jpg, gif以外の場合はエラー
4. **ファイルサイズ検証**：2MBを超える場合はエラー
5. **エラー時処理**：一時ファイルを削除し、エラーメッセージをURLパラメータに設定してリダイレクト
6. **成功時処理**：ファイルをリネーム（peel_[ランダム文字列].[拡張子]）して保存

### 2-データベース更新処理

ファイル検証成功後：
1. customer.sPeelImageにファイル名を設定
2. customer.hasFaviconをtrueに設定（ピール画像あり）
3. customer.save()でデータベースに保存
4. bs_peel.aspにリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイルアップロード成功 | tblCustomer | UPDATE | ピール画像ファイル名の保存 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPeelImage | peel_[ランダム文字列].[拡張子] | アップロードされたファイル名 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| err_fileType | エラー | 対応していないファイル形式です | PNG/JPG/GIF以外の場合 |
| err_fileSize | エラー | ファイルサイズが大きすぎます | 2MB超過の場合 |
| err_newFile | エラー | ファイルが選択されていません | ファイル未送信の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| セッション無効 | bs_security.aspでアクセス拒否 |
| CSRFトークン不正 | checkCSRF_Uploadで処理中断 |
| ファイル未選択 | err_newFileエラーでリダイレクト |
| 不正なファイル形式 | err_fileTypeエラー、一時ファイル削除後リダイレクト |
| ファイルサイズ超過 | err_fileSizeエラー、一時ファイル削除後リダイレクト |

## 備考

- 処理画面のためUIなし（バックエンド処理のみ）
- ファイル名には衝突を避けるためランダム文字列（generatePassword）を使用
- アップロードディレクトリはApplication("QS_CMS_userfiles")で定義
- FreeASPUploadクラス（サードパーティ）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アップロード処理に関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sPeelImage, hasFaviconプロパティの定義を確認 |

**読解のコツ**: customer.sPeelImageにはファイル名のみが保存され、フルパスはApplication("QS_CMS_userfiles")と組み合わせて構築されます。

#### Step 2: エントリーポイントを理解する

処理の流れを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_peelUpload.asp | `asp/bs_peelUpload.asp` | 全体の処理フローを理解（1-43行目） |

**主要処理フロー**:
1. **4-5行目**: アップロードディレクトリのパス構築（server.MapPath使用）
2. **7-8行目**: FreeASPUploadオブジェクト生成とファイル保存
3. **9行目**: CSRF検証（checkCSRF_Upload）
4. **12行目**: アップロードファイルの有無確認（UBound(ks) <> -1）
5. **14-18行目**: ファイル形式検証（select case GetFileExtension）
6. **22-24行目**: ファイルサイズ検証（2000000バイト上限）
7. **25-26行目**: エラー時の一時ファイル削除
8. **29-32行目**: 成功時のファイルリネームと保存
9. **38-42行目**: リダイレクト処理（成功/エラー）

#### Step 3: ユーティリティ関数を理解する

使用されている補助関数を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 共通関数 | `asp/includes/` | GetFileExtension, generatePassword, checkCSRF_Upload関数 |

### プログラム呼び出し階層図

```
bs_peelUpload.asp
    |
    +-- bs_security.asp (セッション認証)
    |
    +-- FreeASPUpload.Save() (ファイルを一時保存)
    |
    +-- checkCSRF_Upload() (CSRF検証)
    |
    +-- GetFileExtension() (拡張子取得)
    |
    +-- [検証処理]
    |       |
    |       +-- [形式エラー] --> err_fileType
    |       +-- [サイズエラー] --> err_fileSize
    |       +-- [ファイルなし] --> err_newFile
    |
    +-- generatePassword() (ランダム文字列生成)
    |
    +-- Upload.UploadedFiles(fileKey).rename() (リネーム)
    |
    +-- customer.save() (DB保存)
    |
    +-- Response.Redirect() (リダイレクト)
```

### データフロー図

```
[入力]                      [処理]                          [出力]

POSTデータ ─────────> FreeASPUpload.Save() ─────────> 一時ファイル
(multipart/form-data)                                (userfiles/)
                                |
                                v
                        checkCSRF_Upload()
                                |
                                v
                        ファイル形式検証
                        GetFileExtension()
                                |
                                v
                        ファイルサイズ検証
                        (Length > 2000000?)
                                |
                    +-----------+-----------+
                    |                       |
                    v                       v
                [エラー]                [成功]
                    |                       |
                    v                       v
            一時ファイル削除         ファイルリネーム
                    |            peel_xxx.{ext}
                    |                       |
                    v                       v
            bs_selectPeel.asp      customer.sPeelImage
            ?strMessage=...        = peelName
                                           |
                                           v
                                    customer.save()
                                           |
                                           v
                                    bs_peel.asp
                                    へリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_peelUpload.asp | `asp/bs_peelUpload.asp` | ソース | アップロード処理メイン |
| bs_selectPeel.asp | `asp/bs_selectPeel.asp` | ソース | ファイル選択画面（遷移元） |
| bs_peel.asp | `asp/bs_peel.asp` | ソース | ピール設定画面（遷移先） |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客データモデル |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
