# 画面設計書 84-クッキー警告

## 概要

本ドキュメントは、QuickerSite CMSのクッキー警告設定画面（bs_cookiewarning.asp）の画面設計書です。GDPR（EU一般データ保護規則）に対応するためのCookie使用警告の設定機能を提供します。

### 本画面の処理概要

この画面では、ウェブサイト訪問者に対して表示するCookie警告（Cookie Consent Banner）の設定を行います。EUのGDPR規制に準拠するために、Cookie使用に関する同意を取得するバナーの内容やデザインをカスタマイズできます。

**業務上の目的・背景**：EUのGDPR（一般データ保護規則）および各国のCookie法制に対応するため、ウェブサイト訪問者にCookie使用について通知し、同意を取得する必要があります。この画面により、法的要件を満たすCookie警告を技術知識なしで設定できます。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、Cookie警告設定メニューからアクセスします。secondAdmin.bCookieWarning権限が必要です。

**主要な操作・処理内容**：
1. Cookie警告の有効/無効切り替え
2. 表示位置（上部/下部）の選択
3. 表示回数の設定（0=常時表示）
4. 開示文（Disclosure）のHTML編集
5. 文字色、リンク色、背景色の設定
6. 承認テキストとボタンテキストの設定
7. エラーメッセージのカスタマイズ
8. デフォルト設定/最小設定のロード
9. プレビュー機能

**画面遷移**：
- 遷移元：バックサイトホーム、設定メニュー
- 遷移先：プレビュー画面（新しいウィンドウ）

**権限による表示制御**：secondAdmin.bCookieWarning権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Cookie警告設定 | 主機能 | Cookie使用に関する警告表示設定（GDPR対応） |

## 画面種別

設定（編集）

## URL/ルーティング

`asp/bs_cookiewarning.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| Cookie警告有効 | bCookieWarning | 入力 | Boolean | - | - | 警告機能の有効/無効 |
| 表示位置 | sCWLocation | 入力 | 文字列 | - | - | top/bottom |
| 表示回数 | sCWNumber | 入力 | 数値 | - | - | 0〜20（0=常時） |
| 開示文 | sCWText | 入力 | HTML | - | - | WYSIWYGエディタで編集 |
| 文字色 | sCWTextColor | 入力 | 文字列 | - | - | 16進カラーコード |
| リンク色 | sCWLinkColor | 入力 | 文字列 | - | - | 16進カラーコード |
| 背景色 | sCWBackgroundColor | 入力 | 文字列 | - | - | 16進カラーコード |
| 承認ブロック非表示 | bCWUseAsNormalPP | 入力 | Boolean | - | - | 承認チェックボックスの非表示 |
| 承認テキスト | sCWAccept | 入力 | 文字列 | - | 250 | 「同意する」チェックボックスのラベル |
| 続行ボタンテキスト | sCWContinue | 入力 | 文字列 | - | 50 | ボタンのラベル |
| ボタンCSSクラス | sCWButtonClass | 入力 | 文字列 | - | 50 | ボタンに適用するCSSクラス |
| エラーメッセージ | sCWError | 入力 | 文字列 | - | 250 | 未同意時のエラーメッセージ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| カラーピッカー | 各色設定用のカラーピッカーUI |
| WYSIWYGエディタ | 開示文編集用のリッチテキストエディタ |
| デフォルト設定ロードボタン | 標準設定をロードするボタン |
| 最小設定ロードボタン | 簡易版設定をロードするボタン |
| プレビューボタン | 設定をプレビューするボタン |

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時、以下の処理が実行されます：
1. postback=1でフォーム送信を識別
2. 各フォーム項目をcustomerオブジェクトに設定
3. customer.save()でデータベースに保存
4. 成功時はfb_saveOKメッセージ付きでリダイレクト

### 2-デフォルト設定ロード

「load default settings」ボタン押下時（loaddefault=1）：
1. 確認ダイアログ表示
2. 言語設定に応じたデフォルト値を設定（英語/オランダ語）
3. データベースに保存
4. 成功メッセージ付きでリダイレクト

### 3-最小設定ロード

「load minimal settings」ボタン押下時（loadminimal=1）：
1. 確認ダイアログ表示
2. 最小限の設定値をロード（開示文なし、承認テキストにリンク含む）
3. データベースに保存
4. 成功メッセージ付きでリダイレクト

### 4-プレビュー

「Preview」ボタン押下時：
1. 新しいウィンドウでホームページを開く
2. QSbcwp=1パラメータでCookie警告を強制表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | Cookie警告設定の保存 |
| デフォルト設定ロード | tblCustomer | UPDATE | デフォルト値での上書き |
| 最小設定ロード | tblCustomer | UPDATE | 最小設定での上書き |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bCookieWarning | Boolean | Cookie警告有効フラグ |
| UPDATE | sCWLocation | "top" or "bottom" | 表示位置 |
| UPDATE | sCWNumber | 0〜20の整数 | 表示回数（0=無制限） |
| UPDATE | sCWText | HTMLテキスト | 開示文 |
| UPDATE | sCWAccept | テキスト | 承認チェックラベル |
| UPDATE | sCWContinue | テキスト | ボタンラベル |
| UPDATE | sCWError | テキスト | エラーメッセージ |
| UPDATE | sCWBackgroundColor | カラーコード | 背景色（デフォルト#000000） |
| UPDATE | sCWButtonClass | CSSクラス名 | ボタンのCSSクラス |
| UPDATE | sCWTextColor | カラーコード | 文字色（デフォルト#FFFFFF） |
| UPDATE | sCWLinkColor | カラーコード | リンク色 |
| UPDATE | bCWUseAsNormalPP | Boolean | 承認ブロック非表示フラグ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存が正常に完了しました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | logon.hasaccessでアクセス拒否 |
| 保存失敗 | customer.save()がfalseを返した場合、リダイレクトなし |

## 備考

- 多言語対応：英語とオランダ語（language=2）のデフォルト設定を用意
- bCWUseAsNormalPP=trueの場合、通常の注意喚起バナーとして使用可能（Cookie同意機能なし）
- プレビュー用JavaScriptファイル：`/js/CookieDirective15.js`
- カラーピッカーはjQueryプラグインを使用（JQColorPicker関数）
- デフォルト色：背景#000000（黒）、文字#FFFFFF（白）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Cookie警告に関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのCookie警告関連プロパティ（17行目：bCookieWarning, sCWLocation等） |

**読解のコツ**: 17行目に全てのCookie警告関連プロパティが宣言されています。sCookieJS関数（1562-1610行目）でフロントエンド用JavaScriptを生成しています。

#### Step 2: エントリーポイントを理解する

画面表示と設定ロード処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_cookiewarning.asp | `asp/bs_cookiewarning.asp` | 画面全体の処理フロー（1-88行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（secondAdmin.bCookieWarning権限）
2. **6-36行目**: デフォルト設定ロード処理（loaddefault=1）
3. **37-67行目**: 最小設定ロード処理（loadminimal=1）
4. **68-84行目**: 通常のフォーム保存処理（postback=1）
5. **84-87行目**: フォームUI定義

#### Step 3: デフォルト設定を理解する

言語別のデフォルト値を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_cookiewarning.asp | `asp/bs_cookiewarning.asp` | case 2（オランダ語）とcase else（英語）の違い（7-32行目） |

**デフォルト値（英語）**:
- sCWLocation: "top"
- sCWNumber: "0"（常時表示）
- sCWContinue: "Continue"
- sCWAccept: "I accept cookies from this site"
- sCWBackgroundColor: "#000000"
- sCWTextColor: "#FFFFFF"

### プログラム呼び出し階層図

```
bs_cookiewarning.asp
    |
    +-- bs_security.asp (認証・権限チェック)
    |       +-- logon.hasaccess (secondAdmin.bCookieWarning)
    |
    +-- [loaddefault=1] --> デフォルト設定ロード
    |       +-- customer.language による分岐
    |       +-- customer.save()
    |
    +-- [loadminimal=1] --> 最小設定ロード
    |       +-- customer.save()
    |
    +-- [postback=1] --> フォーム保存
    |       +-- customer.save()
    |
    +-- includes/urlenCodeJS.asp
    |
    +-- dumpFCKInstance() (WYSIWYGエディタ生成)
    +-- JQColorPicker() (カラーピッカー生成)
    +-- JQDatePicker() (日付ピッカー - 未使用)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ──────> loaddefault/loadminimal ──────> tblCustomer
(loaddefault=1                処理                    (UPDATE)
 loadminimal=1)                |
                               v
                        customer.save()
                               |
                               v
                        bs_cookiewarning.asp
                        ?fbMessage=fb_saveOK

フォームPOST ─────────> postback処理 ─────────────> tblCustomer
(bCookieWarning,        customer.save()           (UPDATE)
 sCWLocation,                  |
 sCWText, ...)                 v
                        bs_cookiewarning.asp
                        ?fbMessage=fb_saveOK

                                                [フロントエンド]
                        customer.sCookieJS ───────> HTML出力
                               |                CookieDirective15.js
                               v                による表示制御
                        JavaScript変数設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_cookiewarning.asp | `asp/bs_cookiewarning.asp` | ソース | Cookie警告設定画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客データモデル・sCookieJS関数 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URLエンコード用JavaScript |
| CookieDirective15.js | `js/CookieDirective15.js` | JavaScript | Cookie同意バナー制御 |
| cookiespolicy.html | `cookiepolicy/cookiespolicy.html` | HTML | Cookieポリシー説明ページ |
| cookiebeleid.html | `cookiepolicy/cookiebeleid.html` | HTML | Cookieポリシー説明（オランダ語） |
