# 画面設計書 85-モバイル設定

## 概要

本ドキュメントは、QuickerSite CMSのモバイル設定画面（bs_mobileSetup.asp）の画面設計書です。モバイルデバイスからのアクセス時に使用するテンプレートやリダイレクト先を設定する機能を提供します。

### 本画面の処理概要

この画面では、特定のブラウザ（主にモバイルデバイス）からのアクセス時に、専用テンプレートを使用するか、別URLにリダイレクトするかを設定します。HTTP_USER_AGENTを解析してモバイルデバイスを識別し、レスポンシブ対応を行います。

**業務上の目的・背景**：スマートフォンやタブレットからのアクセスが増加する中、PCサイトとは異なるモバイル専用の表示を提供する必要があります。この画面により、モバイル専用テンプレートの適用や、モバイルサイトへのリダイレクトを設定できます。

**画面へのアクセス方法**：バックサイト管理画面にログイン後、設定メニューからモバイル設定画面にアクセスします。bs_security.aspによるセッション認証が必要です。

**主要な操作・処理内容**：
1. モバイルデバイス識別用のHTTP_USER_AGENTキーワードを設定
2. モバイル用テンプレートの選択
3. リダイレクト先URLの設定（テンプレート未使用時）
4. 最近のHTTP_USER_AGENTの確認

**画面遷移**：
- 遷移元：バックサイトホーム、設定メニュー
- 遷移先：自画面（保存後リダイレクト）

**権限による表示制御**：bs_security.aspによるセッション認証で管理者のみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 31 | モバイル設定 | 主機能 | モバイル端末向けテンプレート・表示設定 |

## 画面種別

設定（編集）

## URL/ルーティング

`asp/bs_mobileSetup.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| HTTP_USER_AGENTキーワード | sMOBBrowsers | 入力 | テキスト | - | - | モバイル判定用キーワード（複数行） |
| モバイル用テンプレート | iDefaultMobileTemplate | 入力 | 数値 | - | - | 使用するテンプレートID |
| リダイレクトURL | sMOBUrl | 入力 | 文字列 | - | 255 | モバイル用サイトURL |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| HTTP_USER_AGENTキーワード入力欄 | 複数行テキストエリア（400px幅） |
| テンプレート選択ドロップダウン | 登録済みテンプレートの一覧 |
| リダイレクトURL入力欄 | モバイルサイトURL入力フィールド |
| 最近のHTTP_USER_AGENT | アクセスログから取得した最近のユーザーエージェント一覧 |

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時、以下の処理が実行されます：
1. postback=1でフォーム送信を識別
2. セッション変数"checkMobileBrowser"をクリア（キャッシュ無効化）
3. 各フォーム項目をcustomerオブジェクトに設定
4. btnaction=l("save")の場合、customer.save()でデータベースに保存
5. 成功時はfb_saveOKメッセージ付きで自画面にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | モバイル設定の保存 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sMOBBrowsers | テキストエリア入力値（trim処理） | HTTP_USER_AGENTキーワード |
| UPDATE | sMOBUrl | 入力値（trim処理） | リダイレクト先URL |
| UPDATE | iDefaultMobileTemplate | 選択されたテンプレートID（decrypt処理） | モバイル用テンプレート |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存が正常に完了しました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| セッション無効 | bs_security.aspでアクセス拒否 |
| テンプレートID復号エラー | decrypt関数でエラー時、0に変換 |

## 備考

- sMOBBrowsersは改行区切りで複数キーワードを設定可能
- テンプレートとリダイレクトURLは排他利用（テンプレート優先）
- 最近のHTTP_USER_AGENTはapplication("QSmostrecentUA")に格納
- デフォルトURLは"http://"で初期化される
- セッション変数"checkMobileBrowser"はモバイル判定キャッシュとして使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

モバイル設定に関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのモバイル関連プロパティ（16行目：sMOBBrowsers, sMOBurl, iDefaultMobileTemplate） |

**読解のコツ**: 16行目にモバイル関連プロパティがまとめて宣言されています。Pick関数内（190-192行目）でデータベースからの読み込み、Save関数内（437-439行目）で保存処理が定義されています。

#### Step 2: エントリーポイントを理解する

画面表示と保存処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_mobileSetup.asp | `asp/bs_mobileSetup.asp` | 画面全体の処理フロー（1-17行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（bs_security.asp）
2. **4-6行目**: sMOBUrlが空の場合"http://"で初期化
3. **7-12行目**: postback=1の場合、フォーム値をcustomerに設定
4. **8行目**: モバイル判定キャッシュのクリア
5. **13-15行目**: 保存処理とリダイレクト
6. **16行目**: フォームUIと最近のHTTP_USER_AGENT表示

#### Step 3: テンプレート選択を理解する

テンプレート一覧の取得方法を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | showSelectedtemplate関数（1018-1034行目） |

### プログラム呼び出し階層図

```
bs_mobileSetup.asp
    |
    +-- bs_security.asp (セッション認証)
    |
    +-- [postback=1] --> フォーム保存処理
    |       |
    |       +-- session("checkMobileBrowser")="" (キャッシュクリア)
    |       +-- customer.sMOBBrowsers = 入力値
    |       +-- customer.sMOBUrl = 入力値
    |       +-- customer.iDefaultMobileTemplate = decrypt(入力値)
    |       |
    |       +-- [btnaction=l("save")]
    |               +-- customer.save()
    |               +-- Response.Redirect (fb_saveOK)
    |
    +-- customer.showSelectedtemplate("option", ...) (テンプレート一覧)
    |
    +-- application("QSmostrecentUA") (最近のUA表示)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォームPOST ─────────> postback処理 ─────────────> tblCustomer
(sMOBBrowsers,          customer.save()           (UPDATE)
 iDefaultMobileTemplate,       |
 sMOBUrl)                      v
                        bs_mobileSetup.asp
                        ?fbMessage=fb_saveOK

                        [フロントエンドでの利用]

HTTP_USER_AGENT ────> モバイル判定処理 ────> テンプレート適用
(request.ServerVariables)    |                 または
                             |                 リダイレクト
                             v
                    session("checkMobileBrowser")
                    (判定結果キャッシュ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_mobileSetup.asp | `asp/bs_mobileSetup.asp` | ソース | モバイル設定画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客データモデル |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダー・メニュー表示 |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
