# 画面設計書 86-変数設定

## 概要

本ドキュメントは、QuickerSite CMSの変数設定画面（bs_variables.asp）の画面設計書です。テンプレート内で使用可能な変数（プレースホルダー）の一覧を表示する参照画面です。

### 本画面の処理概要

この画面では、テンプレートファイル内で使用できる変数（プレースホルダー）の一覧を参照できます。テンプレート編集時にどのような変数が使用可能かを確認するためのヘルプ画面として機能します。

**業務上の目的・背景**：テンプレートをカスタマイズする際に、サイト名、ページタイトル、メニュー、検索フォームなどの動的コンテンツを挿入するための変数（タグ）を参照できます。この画面により、テンプレート編集者が利用可能な変数を容易に確認・コピーできます。

**画面へのアクセス方法**：テンプレート編集画面やヘルプメニューからアクセスします。静的なHTML表示のため、特別な権限は必要ありません。

**主要な操作・処理内容**：
1. 利用可能な変数の一覧表示
2. 各変数の説明確認
3. 変数のコピー（クリックで選択状態になる）

**画面遷移**：
- 遷移元：テンプレート編集画面、ヘルプメニュー
- 遷移先：なし（参照のみ）

**権限による表示制御**：認証不要の静的ページです。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | サイト基本設定 | 主機能 | サイト変数・パラメータの設定 |

## 画面種別

参照（ヘルプ）

## URL/ルーティング

`asp/bs_variables.asp`

## 入出力項目

この画面は参照専用のため、入力項目はありません。

## 表示項目

| 項目名 | 変数タグ | 説明 |
|--------|---------|------|
| サイト名 | [SITENAME] | サイトの名前を表示 |
| サイトスローガン | [SITESLOGAN] | サイトのスローガンを表示 |
| Bootstrapメニュー | [QS_BOOTSTRAPMENU_3] | Bootstrap 3形式の水平メニュー |
| Artisteer水平メニュー | [QS_ARTISTEER_FULLMENU_V4] | Artisteer 4専用の水平メニュー |
| Artisteer垂直メニュー | [QS_ARTISTEER_FULLVMENU_V4] | Artisteer 4専用の垂直メニュー |
| ページタイトル | [PAGETITLE] | 現在のページタイトル |
| ページコンテンツ | [PAGEBODY]等 | ページのメインコンテンツ |
| 検索フォーム | 複数行テンプレート | サイト内検索フォームのHTML |
| バナー1タイトル | [QSHIGHLIGHTSLABEL] | ハイライトバナーのタイトル |
| バナー1テキスト | [QSHIGHLIGHTS] | ハイライトバナーの内容 |
| バナー2タイトル | [QSCONTACTINFOLABEL] | コンタクト情報バナーのタイトル |
| バナー2テキスト | [BANNER] | コンタクト情報バナーの内容 |
| フッター | [QSSITEFOOTER] | サイト共通フッター |
| RSSアイコン | [RSSLINKART] | RSSフィードへのリンクアイコン |
| Google Analytics | [GOOGLEANALYTICS] | Google AnalyticsのJavaScript |
| レンダリング時間 | [PAGERENDERTIME] | ページ生成時間（ミリ秒） |

## イベント仕様

### 1-変数テキストボックスクリック

各変数のテキストボックスをクリックすると、JavaScriptで全選択状態（select）になり、コピーが容易になります。

## データベース更新仕様

この画面はデータベース更新を行いません。

## メッセージ仕様

この画面にはメッセージ表示がありません。

## 例外処理

この画面は静的コンテンツのため、例外処理はありません。

## 備考

- 純粋なHTMLページとして実装（ASPコードなし）
- onclick="javascript:this.select()"でクリック時に全選択
- 検索フォームはtextareaで複数行のHTMLテンプレートを表示
- Artisteer関連の変数はArtisteer 4で作成したテンプレート専用
- [PAGERENDERTIME]はHTMLコメントとして埋め込む（<!--[PAGERENDERTIME]-->）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面構造を理解する

この画面は静的HTMLのため、ファイル内容を直接確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_variables.asp | `asp/bs_variables.asp` | 変数一覧のテーブル構造（1-14行目） |

**読解のコツ**: この画面はASP処理がなく、純粋なHTMLとして実装されています。各変数は`<input type="text">`で表示され、onclick属性でクリック時の全選択を実現しています。

#### Step 2: 変数の実際の処理を理解する

各変数が実際にどのように処理されるかを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | テンプレート処理 | 各種テンプレート関連ファイル | 変数置換処理（treatconstants関数等） |

### プログラム呼び出し階層図

```
bs_variables.asp
    |
    +-- [静的HTML表示]
            |
            +-- input[onclick=this.select()] (各変数タグ)
            +-- textarea[onclick=this.select()] (検索フォームテンプレート)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

なし ─────────────────> 静的HTML表示 ─────────────────> ブラウザ表示
                        (変数一覧テーブル)

        [テンプレートでの変数使用時]

テンプレートHTML ────> 変数置換処理 ────> 最終HTML
([SITENAME]等)         treatconstants()   (実際の値)
                             |
                             v
                    customer.siteName等
                    (データベース値)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_variables.asp | `asp/bs_variables.asp` | HTML | 変数一覧参照画面 |
| テンプレートファイル | `templates/` | テンプレート | 変数を使用するテンプレート |
| customer.asp | `asp/includes/customer.asp` | ソース | 変数値の取得元（siteName等） |

### 変数一覧詳細

| カテゴリ | 変数 | 説明 | 取得元 |
|---------|------|------|--------|
| サイト情報 | [SITENAME] | サイト名 | customer.siteName |
| サイト情報 | [SITESLOGAN] | スローガン | customer.sSiteSlogan |
| メニュー | [QS_BOOTSTRAPMENU_3] | Bootstrap 3メニュー | 動的生成 |
| メニュー | [QS_ARTISTEER_FULLMENU_V4] | Artisteer水平メニュー | 動的生成 |
| メニュー | [QS_ARTISTEER_FULLVMENU_V4] | Artisteer垂直メニュー | 動的生成 |
| ページ | [PAGETITLE] | ページタイトル | page.sTitle |
| ページ | [PAGEBODY] | ページ本文 | page.sValue |
| ページ | [PAGELIST] | リストページコンテンツ | 動的生成 |
| ページ | [PAGEFORM] | フォームコンテンツ | 動的生成 |
| ページ | [PAGECATALOG] | カタログコンテンツ | 動的生成 |
| ページ | [PAGEFEED] | フィードコンテンツ | 動的生成 |
| ページ | [PAGEAPPLICATION] | アプリケーションコンテンツ | 動的生成 |
| ページ | [PAGETHEME] | テーマコンテンツ | 動的生成 |
| ページ | [PAGEBREADCRUMBS] | パンくずリスト | 動的生成 |
| バナー | [QSHIGHLIGHTSLABEL] | ハイライトラベル | customer.sHighlights |
| バナー | [QSHIGHLIGHTS] | ハイライト内容 | customer.sLeftBanner |
| バナー | [QSCONTACTINFOLABEL] | コンタクト情報ラベル | customer.sContactInfo |
| バナー | [BANNER] | コンタクト情報 | customer.sRightBanner |
| フッター | [QSSITEFOOTER] | サイトフッター | customer.sFooter |
| その他 | [RSSLINKART] | RSSアイコン | 動的生成 |
| その他 | [GOOGLEANALYTICS] | GA JavaScript | customer.googleAnalytics |
| その他 | [PAGERENDERTIME] | レンダリング時間 | 実行時計測 |
