# 画面設計書 87-定数一覧

## 概要

本ドキュメントは、QuickerSite CMSの定数一覧画面（bs_constantList.asp）の画面設計書です。サイト内で使用するカスタム定数（変数・定数・VBScript）の一覧を表示し、管理するための画面です。

### 本画面の処理概要

この画面では、テンプレートやページ内で使用できるカスタム定数の一覧を表示します。定数は[CONSTANT_NAME]の形式でテンプレートに埋め込むことで、動的なコンテンツを挿入できます。テキスト、HTML、VBScriptの3種類の定数タイプをサポートしています。

**業務上の目的・背景**：サイト全体で共通して使用する文言や動的コンテンツを一元管理するために、カスタム定数機能を提供します。これにより、複数ページで同じ内容を表示する場合の更新作業が効率化されます。VBScript定数を使用すると、動的な処理結果をテンプレートに挿入することも可能です。

**画面へのアクセス方法**：バックサイトホーム画面から「定数一覧」リンクをクリックするか、ナビゲーションメニューからアクセスします。secondAdmin.bHomeConstants権限が必要です。

**主要な操作・処理内容**：
1. 登録済み定数の一覧表示
2. 各定数の種別（テキスト/HTML/VBScript）確認
3. 各定数のオンライン/オフライン状態確認
4. 定数編集画面への遷移
5. 新規定数作成画面への遷移

**画面遷移**：
- 遷移元：バックサイトホーム（bs_default.asp）
- 遷移先：定数編集画面（bs_constantEdit.asp）、ページ一覧（bs_default.asp）、スクリプト一覧（bs_scriptlist.asp）

**権限による表示制御**：secondAdmin.bHomeConstants権限を持つユーザーのみアクセス可能です。VBScript関連はsecondAdmin.bHomeVBScript権限も必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | 定数一覧 | 主機能 | サイト全体で使用する定数の一覧表示 |
| 95 | 定数作成・編集 | 遷移先機能 | 定数編集画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

`asp/bs_constantList.asp`

## 入出力項目

この画面は一覧表示のため、入力項目はありません。

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 定数タグ | テンプレートで使用する形式（[CONSTANT_NAME]） |
| 定数名リンク | 編集画面へのリンク |
| 種別 | テキスト/HTML/VBScript |
| ID | 定数のデータベースID |
| ステータス | オンライン/オフライン状態 |

## イベント仕様

### 1-ページ一覧リンククリック

「Page List」リンククリック時、bs_default.aspにリダイレクトします。

### 2-新規作成リンククリック

「New Item」リンククリック時、bs_constantEdit.aspに遷移します。

### 3-ASP/VBScriptsリンククリック

条件：customer.bApplication=trueかつsecondAdmin.bHomeVBScript=trueの場合のみ表示
「ASP/VBScripts」リンククリック時、bs_scriptlist.aspに遷移します。

### 4-定数名リンククリック

各定数の名前リンククリック時、暗号化されたiContentIDを付与してbs_constantEdit.aspに遷移します。

### 5-定数タグテキストボックスクリック

定数タグのテキストボックスをクリックすると、JavaScriptで全選択状態になりコピーが容易になります。

## データベース更新仕様

この画面はデータベース更新を行いません（参照のみ）。

## メッセージ仕様

この画面にはメッセージ表示がありません。

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | logon.hasaccessでアクセス拒否 |

## 備考

- VBScript定数（iType=QS_VBScript）は一覧から除外（bs_scriptlist.aspで管理）
- 定数タグは[大文字]形式で表示
- オフライン定数は色付きでステータス表示
- cls_formatListクラスで定数タイプの表示名を取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

定数に関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constant.asp | `asp/includes/constant.asp` | cls_constantクラスの構造（2-112行目） |

**読解のコツ**: cls_constantクラスはiId, sConstant, sValue, iType, dOnlineFrom, dOnlineUntill, sParameters, sGlobalプロパティを持ちます。iTypeで定数の種類（テキスト/HTML/VBScript）を管理します。

#### Step 2: エントリーポイントを理解する

画面表示処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_constantList.asp | `asp/bs_constantList.asp` | 画面全体の処理フロー（1-14行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（secondAdmin.bHomeConstants権限）
2. **4行目**: ヘッダー表示（getBOHeader(btn_Home)）
3. **5-6行目**: customer.constantsで定数コレクション取得
4. **9-10行目**: VBScript以外の定数をループ表示
5. **10行目**: 各定数の情報（タグ、リンク、タイプ、ID、ステータス）表示

#### Step 3: 定数コレクションの取得を理解する

customer.constantsプロパティの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | constants関数（1103-1118行目） |

**主要処理フロー**:
- tblConstantテーブルから該当顧客の定数を取得
- cls_constantオブジェクトを生成しDictionaryに格納

### プログラム呼び出し階層図

```
bs_constantList.asp
    |
    +-- bs_security.asp (認証・権限チェック)
    |       +-- logon.hasaccess (secondAdmin.bHomeConstants)
    |
    +-- bs_process.asp (フォーム処理 - この画面では未使用)
    |
    +-- getBOHeader(btn_Home) (ヘッダー表示)
    |
    +-- customer.constants (定数コレクション取得)
    |       +-- db.execute (tblConstant SELECT)
    |       +-- cls_constant.pick (各定数オブジェクト生成)
    |
    +-- cls_formatList.showSelected (タイプ表示名取得)
    |
    +-- getArtLink (リンク生成)
    |
    +-- encrypt (iContentID暗号化)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

なし ─────────────────> customer.constants ───────────> 定数一覧表示
                              |
                              v
                        tblConstant
                        (SELECT)
                              |
                              v
                        cls_constant
                        オブジェクト生成
                              |
                              v
                        [iType <> QS_VBScript]
                        フィルタリング
                              |
                              v
                        HTML出力
                        (タグ, 名前, タイプ, ID, ステータス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_constantList.asp | `asp/bs_constantList.asp` | ソース | 定数一覧画面 |
| bs_constantEdit.asp | `asp/bs_constantEdit.asp` | ソース | 定数編集画面 |
| bs_scriptlist.asp | `asp/bs_scriptlist.asp` | ソース | VBScript一覧画面 |
| constant.asp | `asp/includes/constant.asp` | ソース | 定数クラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客データモデル（constants関数） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |

### 定数タイプ一覧

| タイプコード | タイプ名 | 説明 |
|-------------|---------|------|
| QS_textonly | テキスト | プレーンテキストとして挿入 |
| QS_html | HTML | HTMLとしてレンダリング |
| QS_VBScript | VBScript | サーバーサイドで実行される動的コンテンツ |
