# 画面設計書 88-定数編集

## 概要

本ドキュメントは、QuickerSite CMSの定数編集画面（bs_constantEdit.asp）の画面設計書です。カスタム定数（テキスト/HTML/VBScript）を作成・編集するための画面です。

### 本画面の処理概要

この画面では、テンプレートやページ内で使用するカスタム定数を作成・編集します。定数タイプに応じて入力UIが動的に変わり、テキスト、HTML（WYSIWYGエディタ）、VBScript（コードエディタ）の3種類をサポートします。VBScriptの場合はテスト実行機能も提供します。

**業務上の目的・背景**：サイト全体で共通して使用する文言や動的コンテンツを定義するために、カスタム定数の作成・編集機能を提供します。HTML定数はリッチテキストエディタで編集でき、VBScript定数は動的な処理を実装できます。

**画面へのアクセス方法**：定数一覧画面（bs_constantList.asp）から「新規作成」または既存定数をクリックしてアクセスします。secondAdmin.bHomeConstants権限が必要です。

**主要な操作・処理内容**：
1. 定数名の設定（大文字に自動変換）
2. 定数タイプの選択（テキスト/HTML/VBScript）
3. 定数値の入力（タイプに応じたエディタ）
4. オンライン期間の設定（開始日〜終了日）
5. VBScriptの場合はパラメータとグローバルコードの設定
6. VBScriptのテスト実行
7. 定数の使用箇所検索（どのページで使われているか）

**画面遷移**：
- 遷移元：定数一覧（bs_constantList.asp）、スクリプト一覧（bs_scriptlist.asp）
- 遷移先：定数一覧（bs_constantList.asp）、スクリプト一覧（bs_scriptlist.asp）、定数テスト（bs_constantTest.asp）

**権限による表示制御**：secondAdmin.bHomeConstants権限を持つユーザーのみアクセス可能です。VBScriptテスト実行にはsecondAdmin.bHomeVBScript権限も必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | 定数作成・編集 | 主機能 | テンプレート内で使用する変数・定数の管理 |

## 画面種別

登録/編集

## URL/ルーティング

`asp/bs_constantEdit.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 定数名 | sConstant | 入力 | 文字列 | * | 20 | 定数名（自動大文字変換） |
| タイプ | iType | 入力 | 数値 | - | - | テキスト/HTML/VBScript |
| オンライン開始日 | dOnlinefrom | 入力 | 日付 | - | - | 有効期間開始 |
| オンライン終了日 | dOnlineUntill | 入力 | 日付 | - | - | 有効期間終了 |
| 値（テキスト） | sValue | 入力 | テキスト | * | - | タイプ=テキストの場合 |
| 値（HTML） | sValue | 入力 | HTML | * | - | タイプ=HTMLの場合（FCKEditor） |
| 値（VBScript） | sValue | 入力 | コード | * | - | タイプ=VBScriptの場合 |
| パラメータ | sParameters | 入力 | 文字列 | - | 200 | VBScriptの引数定義 |
| グローバルコード | sGlobal | 入力 | コード | - | - | VBScriptの共通関数・クラス |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 戻るリンク | 定数一覧またはスクリプト一覧へ戻る |
| 削除アイコン | 既存定数の場合に表示 |
| 日付ピッカー | オンライン期間設定用 |
| WYSIWYGエディタ | HTML定数の場合に表示 |
| コードエリア | VBScript定数の場合に表示 |
| テストボタン | VBScriptの場合に表示 |
| 使用箇所 | 定数がどのページで使われているか表示 |

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時、以下の処理が実行されます：
1. CSRF検証（checkCSRF）
2. constant.getRequestValues()でフォーム値を取得
3. constant.save()でバリデーションと保存
4. 成功時はfb_saveOKメッセージを追加

### 2-削除アイコンクリック

削除アイコンクリック時、確認ダイアログ後：
1. CSRF検証
2. constant.remove()で定数削除
3. タイプに応じて定数一覧またはスクリプト一覧にリダイレクト

### 3-タイプ変更

タイプ選択ドロップダウン変更時：
1. onchangeでフォーム送信
2. 選択されたタイプに応じたUIを再表示

### 4-テストボタン押下（VBScriptの場合）

テストボタン押下時：
1. 入力値をscriptformにコピー
2. bs_constantTest.aspに新しいウィンドウで送信
3. 実行結果を確認

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下（新規） | tblConstant | INSERT | 新規定数の作成 |
| 保存ボタン押下（更新） | tblConstant | UPDATE | 既存定数の更新 |
| 削除アイコンクリック | tblConstant | DELETE | 定数の削除 |

### テーブル別更新項目詳細

#### tblConstant

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sConstant | 入力値（大文字変換、最大50文字） | 定数名 |
| INSERT/UPDATE | sValue | 入力値 | 定数の値 |
| INSERT/UPDATE | iType | 選択されたタイプコード | 定数タイプ |
| INSERT/UPDATE | iCustomerID | cId | 顧客ID |
| INSERT/UPDATE | dOnlineFrom | 日付ピッカー入力値 | オンライン開始日 |
| INSERT/UPDATE | dOnlineUntill | 日付ピッカー入力値 | オンライン終了日 |
| INSERT/UPDATE | sParameters | 入力値 | VBScriptパラメータ |
| INSERT/UPDATE | sGlobal | 入力値 | グローバルコード |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存が正常に完了しました | 保存成功時 |
| err_mandatory | エラー | 必須項目が入力されていません | sConstantまたはsValueが空の場合 |
| err_constant | エラー | 定数名が重複しています | 同名の定数が既に存在する場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | logon.hasaccessでアクセス拒否 |
| CSRFトークン不正 | checkCSRFで処理中断 |
| 必須項目未入力 | エラーメッセージ表示 |
| 定数名重複 | エラーメッセージ表示 |

## 備考

- 定数名は自動的に大文字に変換され、[]は自動除去される
- オンライン期間はisBetween関数で判定
- VBScriptはcustomer.cacheConstants()でキャッシュに反映
- 使用箇所検索はcls_fullSearchクラスで正規表現検索
- VBScriptのテスト時は実行エラーがテストモードでのみ表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

定数に関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constant.asp | `asp/includes/constant.asp` | cls_constantクラスの全機能（1-112行目） |

**読解のコツ**:
- 3行目: プロパティ宣言
- 11-27行目: Pick関数（データ読み込み）
- 29-48行目: Check関数（バリデーション）
- 49-77行目: Save関数（保存処理）
- 78-86行目: getRequestValues関数（フォーム取得）
- 97-104行目: remove関数（削除処理）

#### Step 2: エントリーポイントを理解する

画面表示と保存処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_constantEdit.asp | `asp/bs_constantEdit.asp` | 画面全体の処理フロー（1-46行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（secondAdmin.bHomeConstants）
2. **4-8行目**: 定数オブジェクト初期化とpostback処理
3. **9-24行目**: btnaction別の処理分岐（保存/削除）
4. **26-32行目**: タイプ別のUI切り替え（テキスト/HTML/VBScript）
5. **33-44行目**: 使用箇所検索とVBScriptテストフォーム

#### Step 3: バリデーションを理解する

入力値の検証処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | constant.asp | `asp/includes/constant.asp` | Check関数（29-48行目） |

**バリデーション項目**:
- sConstantが空でないこと
- sValueが空でないこと
- 同名の定数が存在しないこと（重複チェック）

### プログラム呼び出し階層図

```
bs_constantEdit.asp
    |
    +-- bs_security.asp (認証・権限チェック)
    |       +-- logon.hasaccess (secondAdmin.bHomeConstants)
    |
    +-- cls_constant (定数オブジェクト)
    |       +-- pick() (データ読み込み)
    |       +-- getRequestValues() (フォーム値取得)
    |       +-- check() (バリデーション)
    |       +-- save() (保存)
    |       +-- remove() (削除)
    |
    +-- checkCSRF() (CSRF検証)
    |
    +-- cls_formatList (タイプ選択肢生成)
    |
    +-- createFCKInstance() (HTMLエディタ生成)
    |       +-- [iType=QS_html の場合]
    |
    +-- JQDatePicker() (日付ピッカー生成)
    |
    +-- cls_fullSearch (使用箇所検索)
    |       +-- search() (正規表現検索)
    |
    +-- customer.cacheConstants() (キャッシュ更新)
    |
    +-- [VBScriptテスト] --> bs_constantTest.asp
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォームPOST ─────────> cls_constant ──────────────> tblConstant
(sConstant,             getRequestValues()          (INSERT/UPDATE)
 iType,                        |
 sValue, ...)                  v
                        check() バリデーション
                               |
                               v
                        save() 保存
                               |
                               v
                        customer.cacheConstants()
                        (アプリケーションキャッシュ更新)
                               |
                               v
                        message.Add("fb_saveOK")

                        [使用箇所検索]

cls_fullSearch ────────> 正規表現検索 ────────────> 使用ページ一覧
(pattern)               tblPage.sValue等             HTML出力
                        から検索
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_constantEdit.asp | `asp/bs_constantEdit.asp` | ソース | 定数編集画面 |
| bs_constantList.asp | `asp/bs_constantList.asp` | ソース | 定数一覧画面 |
| bs_constantTest.asp | `asp/bs_constantTest.asp` | ソース | VBScriptテスト画面 |
| bs_scriptlist.asp | `asp/bs_scriptlist.asp` | ソース | VBScript一覧画面 |
| constant.asp | `asp/includes/constant.asp` | ソース | 定数クラス定義 |
| customer.asp | `asp/includes/customer.asp` | ソース | cacheConstants関数 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
