# 画面設計書 89-定数テスト

## 概要

本ドキュメントは、QuickerSite CMSの定数テスト画面（bs_constantTest.asp）の画面設計書です。VBScript定数の動作確認を行うためのテスト実行画面です。

### 本画面の処理概要

この画面では、定数編集画面で作成したVBScriptコードをテスト実行します。本番環境に反映する前に、コードが正常に動作するか確認するための開発者向け機能です。エラーが発生した場合もテストモードでのみ表示され、実際のサイトには影響しません。

**業務上の目的・背景**：VBScript定数はサーバーサイドで実行されるため、構文エラーや実行時エラーがあるとサイト全体に影響を与える可能性があります。この画面により、本番適用前にコードの動作確認を安全に行えます。

**画面へのアクセス方法**：定数編集画面（bs_constantEdit.asp）でVBScript定数を編集中に「Test!」ボタンをクリックすると、新しいウィンドウでこの画面が開きます。secondAdmin.bHomeVBScript権限が必要です。

**主要な操作・処理内容**：
1. VBScriptコードの受け取り
2. パラメータがある場合は入力フォーム表示
3. executeConstant関数によるコード実行
4. 実行結果の表示

**画面遷移**：
- 遷移元：定数編集画面（bs_constantEdit.asp）からPOST送信
- 遷移先：なし（結果表示のみ）

**権限による表示制御**：secondAdmin.bHomeVBScript権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | 定数作成・編集 | 主機能 | 定数の動作テスト |

## 画面種別

処理（テスト実行）

## URL/ルーティング

`asp/bs_constantTest.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| VBScriptコード | customScript | 入力 | コード | * | - | テスト対象のVBScriptコード |
| パラメータ定義 | sParameters | 入力 | 文字列 | - | - | 関数のパラメータ定義 |
| パラメータ値 | sParametersValues | 入力 | 文字列 | - | - | パラメータの実際の値（ダブルクォートで囲む） |
| グローバルコード | sGlobal | 入力 | コード | - | - | 共通関数・クラス定義 |
| CSRFトークン | QSSEC | 入力 | 文字列 | * | - | CSRF検証用 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| パラメータ入力フォーム | パラメータがある場合に表示 |
| パラメータ値入力欄 | パラメータの値を入力（ダブルクォートで囲む） |
| テストボタン | パラメータ付きで再実行 |
| 実行結果 | VBScriptの実行結果（Response.Writeまたは戻り値） |

## イベント仕様

### 1-テスト実行（パラメータなし）

パラメータ定義がない場合、即座に実行：
1. CSRF検証（checkCSRF）
2. executeConstant関数でVBScript実行
3. 結果をHTML出力

### 2-テスト実行（パラメータあり）

パラメータ定義がある場合：
1. パラメータ入力フォームを表示
2. ユーザーがパラメータ値を入力して「Test!」ボタン押下
3. CSRF検証
4. executeConstant関数でパラメータ付き実行
5. 結果をHTML出力

## データベース更新仕様

この画面はデータベース更新を行いません（テスト実行のみ）。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| (実行結果) | 情報 | VBScript実行結果 | 正常実行時 |
| (エラー) | エラー | VBScriptエラーメッセージ | 実行時エラー発生時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | logon.hasaccessでアクセス拒否 |
| CSRFトークン不正 | checkCSRFで処理中断 |
| VBScript実行エラー | エラーメッセージをテスト画面に表示（本番には影響なし） |

## 備考

- テストモード専用の画面（本番サイトには影響しない）
- パラメータ値はダブルクォートで囲んで入力する必要がある
- executeConstant関数の第2引数（true）でテストモードを指定
- 実行エラーはテストモードでのみ表示される
- 背景色は白（#FFF）
- 簡易ヘッダー（commonheader.asp）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト実行に関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_constantTest.asp | `asp/bs_constantTest.asp` | 受け取るパラメータ構造 |

**読解のコツ**: この画面は定数編集画面からPOSTされたVBScriptコードを受け取り、executeConstant関数で実行します。パラメータがある場合は追加の入力フォームを表示します。

#### Step 2: エントリーポイントを理解する

画面処理の流れを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_constantTest.asp | `asp/bs_constantTest.asp` | 画面全体の処理フロー（1-10行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（secondAdmin.bHomeVBScript）
2. **4行目**: パラメータ有無の判定（sParameters <> ""）
3. **4行目**: パラメータフォームの表示
4. **5行目**: CSRF検証（checkCSRF）
5. **6-7行目**: 実行条件の判定（パラメータなし、またはパラメータ値あり）
6. **7行目**: executeConstant関数の呼び出し

#### Step 3: executeConstant関数を理解する

VBScript実行処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 共通関数ファイル | `asp/includes/` | executeConstant関数の実装 |

**executeConstant関数のパラメータ**:
- 第1引数: VBScriptコード + QS_VBScriptIdentifier + パラメータ定義
- 第2引数: テストモードフラグ（true=テストモード）
- 第3引数: パラメータ値
- 第4引数: グローバルコード

### プログラム呼び出し階層図

```
bs_constantEdit.asp (定数編集画面)
    |
    +-- [テストボタン押下]
            |
            +-- scriptform (hidden form)
            |       +-- customScript (VBScriptコード)
            |       +-- sParameters (パラメータ定義)
            |       +-- sGlobal (グローバルコード)
            |       +-- QSSEC (CSRFトークン)
            |
            v
bs_constantTest.asp (テスト実行画面)
    |
    +-- bs_security.asp (認証・権限チェック)
    |       +-- logon.hasaccess (secondAdmin.bHomeVBScript)
    |
    +-- [sParameters <> ""]
    |       +-- パラメータ入力フォーム表示
    |       +-- [Test!ボタン押下]
    |               +-- checkCSRF()
    |               +-- executeConstant()
    |
    +-- [sParameters = "" または sParametersValues あり]
            +-- checkCSRF()
            +-- executeConstant(customScript, true, sParametersValues, sGlobal)
                    |
                    +-- VBScript動的実行
                    +-- 結果またはエラー出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

定数編集画面 ─────────> bs_constantTest.asp ──────────> 実行結果
(customScript,          checkCSRF()                   (HTML出力)
 sParameters,                 |
 sGlobal)                     v
                        executeConstant()
                              |
                        +-----+-----+
                        |           |
                        v           v
                    [正常]      [エラー]
                        |           |
                        v           v
                    Response.Write  エラーメッセージ
                    or             表示
                    CustomFunction
                    戻り値

            [パラメータあり＆値なしの場合]

                        パラメータ入力フォーム表示
                              |
                              v
                        sParametersValues入力
                              |
                              v
                        再度executeConstant()実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_constantTest.asp | `asp/bs_constantTest.asp` | ソース | テスト実行画面 |
| bs_constantEdit.asp | `asp/bs_constantEdit.asp` | ソース | 定数編集画面（遷移元） |
| commonheader.asp | `asp/includes/commonheader.asp` | ソース | 簡易ヘッダー |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| bs_endBack.asp | `asp/bs_endBack.asp` | ソース | バックサイト終了処理 |

### VBScript実行の仕組み

VBScript定数は以下の形式で実行されます：

```vbscript
' グローバルコード（sGlobal）がある場合は先に評価

function CustomFunction(パラメータ)
    ' sValue（customScript）の内容
    ' Response.WriteまたはCustomFunctionへの代入で出力
end function
```

- `QS_VBScriptIdentifier`でコードとパラメータを区切る
- テストモード（第2引数=true）の場合、エラーを画面に表示
- 本番モードの場合、エラーは抑制されサイトに影響しない
