# 画面設計書 9-リストページ編集

## 概要

本ドキュメントは、QuickerSite CMSのリストページ管理画面について、その機能仕様・画面構成・処理フローを詳細に記述した画面設計書である。

### 本画面の処理概要

この画面は、リストページに属するリストアイテムの一覧表示と管理を行う画面である。リストアイテムの追加、編集、コピー、削除などの操作が可能である。

**業務上の目的・背景**：QuickerSiteのリストページは、ニュース、ブログ記事、FAQ、製品カタログなど、同種のアイテムを一覧形式で表示するためのページタイプである。この画面はリストに含まれるアイテムの管理を効率的に行うためのインターフェースを提供する。

**画面へのアクセス方法**：バックサイトホーム（bs_default.asp）からリストページをクリック、またはリストページ編集画面（bs_editList.asp）から「Manage list」リンク、直接 `/asp/bs_listPage.asp?iId={暗号化ID}` へアクセス。

**主要な操作・処理内容**：
1. リストページのプロパティを編集する（bs_editList.aspへ遷移）
2. 新規リストアイテムを追加する（bs_editListItem.aspへ遷移）
3. 既存リストアイテムを編集する
4. リストアイテムをコピーする
5. リストアイテムを削除する
6. リストアイテムのプレビューを表示する
7. リストアイテムの画像を設定する（条件付き）
8. リストページを通常ページに変換する

**画面遷移**：
- 遷移元：bs_default.asp（バックサイトホーム）、bs_editList.asp（リストページ編集）
- 遷移先：bs_editList.asp（リストページ設定）、bs_editListItem.asp（リストアイテム編集）、bs_editpictureLI.asp（画像設定）、bs_uploadpictureLI.asp（画像アップロード）

**権限による表示制御**：secondAdmin.bPagesAddがtrueのユーザーがアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | ページ作成・編集 | 主機能 | リストページおよびリストアイテムの管理 |
| 37 | アセットマネージャー | 補助機能 | リストアイテム画像の管理 |

## 画面種別

一覧画面 / 管理画面

## URL/ルーティング

- `/asp/bs_listPage.asp`
- `/asp/bs_listPage.asp?iId={暗号化ID}`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 最大長 | 必須 | 説明 |
|--------|--------|----------|----------|--------|------|------|
| ページID | iId | QueryString | 暗号化数値 | - | - | リストページID |
| 削除対象ID | iDeleteLIID | QueryString | 暗号化数値 | - | - | 削除するリストアイテムID |
| コピー対象ID | iCopyIid | QueryString | 暗号化数値 | - | - | コピーするリストアイテムID |
| ボタンアクション | btnaction | QueryString | 文字列 | - | - | makenormalpageで通常ページ変換 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| BOヘッダー | 上部 | バックサイト共通ヘッダー |
| リストページタイトル | フォーム上部 | 「Manage list: '{ページタイトル}'」 |
| リストページ編集リンク | 上部 | bs_editList.aspへのリンク |
| 新規アイテム追加リンク | 上部 | bs_editListItem.aspへのリンク |
| リストアイテム一覧 | メインエリア | UL/LI形式のアイテムリスト |
| アイテムタイトル | 各行 | クリック可能なリンク |
| アイテムID | 各行 | iId表示（デバッグ用） |
| 編集ボタン | 各行 | bs_editListItem.aspへ遷移 |
| プレビューボタン | 各行 | フロントサイトでプレビュー |
| 画像設定ボタン | 各行 | 画像設定ダイアログ（条件付き） |
| コピーボタン | 各行 | アイテムコピー（確認付き） |
| 削除ボタン | 各行 | アイテム削除（確認付き） |
| 通常ページ変換リンク | 下部 | リストページを通常ページに変換 |
| 確認リンク | 下部 | フロントサイトでページ確認 |

## イベント仕様

### 1-リストアイテム削除

**処理フロー**：
1. 削除確認ダイアログ表示（l("deletecomplete")）
2. iDeleteLIIDパラメータ付きでGETリクエスト
3. checkCSRF()でトークン検証
4. cls_pageオブジェクトでpick
5. bDeleted=true、bOnline=false設定
6. save()で保存
7. fb_topicremoved メッセージでリダイレクト

### 2-リストアイテムコピー

**処理フロー**：
1. コピー確認ダイアログ表示（l("areyousure")）
2. iCopyIidパラメータ付きでGETリクエスト
3. checkCSRF()でトークン検証
4. cls_pageオブジェクトでpick
5. iId=null、sCode=""、sUserFriendlyURL=""設定
6. sTitle に " (copy)" を追加
7. save()で新規保存
8. リストページにリダイレクト

### 3-通常ページ変換

**処理フロー**：
1. 変換確認ダイアログ表示（l("areyousure")）
2. btnaction=makenormalpage でGETリクエスト
3. bs_process.aspで処理
4. リストページを通常ページに変換

### 4-画像設定（colorbox）

**処理フロー**：
1. colorboxでbs_editpictureLI.asp をiframe表示
2. 画像設定完了後、location.reload(true)で画面更新

### 5-画像アップロード（colorbox）

**処理フロー**：
1. colorboxでbs_uploadpictureLI.asp をiframe表示
2. アップロード完了後、location.reload(true)で画面更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アイテム削除 | tblPage | UPDATE | bDeleted=true、bOnline=false |
| アイテムコピー | tblPage | INSERT | 新規レコード作成（タイトルに"copy"付加） |
| 通常ページ変換 | tblPage | UPDATE | ページタイプの変更 |

### テーブル別更新項目詳細

#### tblPage（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bDeleted | true | 論理削除フラグ |
| UPDATE | bOnline | false | 非公開設定 |

#### tblPage（コピー時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iId | null（自動採番） | 新規ID |
| INSERT | sCode | "" | コードクリア |
| INSERT | sUserFriendlyURL | "" | URLクリア |
| INSERT | sTitle | 元タイトル + " (copy)" | コピー識別 |
| INSERT | その他 | 元レコードと同一 | 内容コピー |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| areyousure | 確認 | 操作確認メッセージ | コピー・変換操作時 |
| deletecomplete | 確認 | 削除確認メッセージ | 削除操作時 |
| fb_topicremoved | 成功 | アイテム削除完了 | 削除成功時 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|----------|
| 未認証状態 | bs_security.aspによりログイン画面へリダイレクト |
| CSRFトークン不正 | checkCSRF()によりエラー処理 |
| 対象アイテムなし | iId=0の場合、処理スキップ |

## 備考

- リストアイテム一覧はpage.listitems(false)で取得
- 各アイテムにgetClickLink(true)でリンク生成
- 画像機能はcustomer.bListItemPic設定に依存
- 画像パスは Application("QS_CMS_userfiles") & "listitemimages/" & iId & "." & sItemPicture
- UserFriendlyURL設定時はそのURLでプレビュー、未設定時はdefault.asp?iId形式
- colorboxライブラリでモーダルダイアログ表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストページとリストアイテムの関係を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | cls_pageクラス、listitems関数 |
| 1-2 | customer.asp | `asp/includes/customer.asp` | bListItemPicプロパティ |

**読解のコツ**: リストアイテムはtblPageテーブルのiListPageIDで親リストページに紐付けられる。listitems関数はDictionary形式で子アイテムを返す。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_listPage.asp | `asp/bs_listPage.asp` | リストページ管理画面のメインファイル |

**主要処理フロー**:
1. **行2-3**: bs_security.asp、bs_process.aspのインクルード
2. **行8-19**: iDeleteLIIDによる削除処理
3. **行21-36**: iCopyIidによるコピー処理
4. **行38**: cls_pageオブジェクトの初期化
5. **行41-42**: page.listitems(false)でアイテム一覧取得
6. **行45-78**: For Eachループでアイテム一覧表示

#### Step 3: 削除・コピー処理を理解する

アイテム操作のロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_listPage.asp | `asp/bs_listPage.asp` | 行8-36の削除・コピー処理 |

**削除処理（行8-19）**:
- **行9**: checkCSRF()でトークン検証
- **行10-11**: cls_pageでpick
- **行13-14**: bDeleted=true、bOnline=false設定
- **行15-16**: save()で保存、リダイレクト

**コピー処理（行22-36）**:
- **行23**: checkCSRF()でトークン検証
- **行28-31**: iId=null、sCode=""、sUserFriendlyURL=""、タイトル変更
- **行32-33**: save()で保存、リダイレクト

### プログラム呼び出し階層図

```
bs_listPage.asp (エントリーポイント)
    │
    ├─ bs_security.asp (認証チェック)
    │
    ├─ bs_process.asp (共通処理)
    │
    ├─ 削除処理 (iDeleteLIID)
    │      ├─ checkCSRF()
    │      ├─ cls_page.pick()
    │      └─ cls_page.save()
    │
    ├─ コピー処理 (iCopyIid)
    │      ├─ checkCSRF()
    │      ├─ cls_page.pick()
    │      └─ cls_page.save()
    │
    ├─ page.listitems(false) (アイテム一覧取得)
    │
    └─ アイテム一覧表示
           ├─ getClickLink(true)
           ├─ 編集リンク
           ├─ プレビューリンク
           ├─ 画像設定 (colorbox)
           ├─ コピーリンク
           └─ 削除リンク
```

### データフロー図

```
[入力]                    [処理]                         [出力]

iDeleteLIID ─────────▶ checkCSRF() ──────────▶ 削除処理
                              │
                              ▼
                        pick() → save()
                              │
                              ▼
                        リダイレクト（fb_topicremoved）

iCopyIid ────────────▶ checkCSRF() ──────────▶ コピー処理
                              │
                              ▼
                        pick() → 値変更 → save()
                              │
                              ▼
                        リダイレクト

page.iId ────────────▶ listitems(false) ─────▶ アイテム一覧表示
                              │
                              ▼
                        For Each item
                              │
                              ▼
                        getClickLink, 各種ボタン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | リストページ管理画面メイン |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証チェック |
| bs_process.asp | `asp/bs_process.asp` | インクルード | 共通処理 |
| page.asp | `asp/includes/page.asp` | インクルード | cls_pageクラス |
| customer.asp | `asp/includes/customer.asp` | インクルード | 顧客設定（bListItemPic） |
| bs_editList.asp | `asp/bs_editList.asp` | 関連画面 | リストページ設定編集 |
| bs_editListItem.asp | `asp/bs_editListItem.asp` | 関連画面 | リストアイテム編集 |
| bs_editpictureLI.asp | `asp/bs_editpictureLI.asp` | 関連画面 | 画像設定ダイアログ |
| bs_uploadpictureLI.asp | `asp/bs_uploadpictureLI.asp` | 関連画面 | 画像アップロードダイアログ |
| bs_editPageBlocksInc.asp | `asp/bs_editPageBlocksInc.asp` | インクルード | ページブロック編集 |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | バックサイト用ヘッダー |
| bs_endBack.asp | `asp/bs_endBack.asp` | テンプレート | バックサイト用フッター |
| bs_back.asp | `asp/bs_back.asp` | インクルード | 戻るリンク |
