# 画面設計書 90-フッター編集

## 概要

本ドキュメントは、QuickerSite CMSのフッター編集画面（bs_editFooter.asp）の画面設計書です。サイト共通のフッター領域に表示するHTMLコンテンツを編集するための画面です。

### 本画面の処理概要

この画面では、サイト全ページに共通して表示されるフッター領域のHTMLコンテンツを編集します。WYSIWYGエディタ（FCKEditor）を使用して、視覚的にフッターの内容を作成・編集できます。

**業務上の目的・背景**：サイト全体で統一されたフッター（著作権表示、連絡先、リンク集など）を管理するため、一箇所で編集できる機能を提供します。フッターはすべてのページテンプレートで共通して使用されます。

**画面へのアクセス方法**：管理画面メニューの「設定」>「ページ要素」からアクセスします。secondAdmin.bSetupPageElements権限が必要です。

**主要な操作・処理内容**：
1. 現在のフッターHTMLの表示
2. WYSIWYGエディタでの編集
3. 保存ボタンでの更新

**画面遷移**：
- 遷移元：管理メニュー（設定 > ページ要素）
- 遷移先：なし（同一画面で編集継続）

**権限による表示制御**：secondAdmin.bSetupPageElements権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | フッター編集 | 主機能 | サイト共通フッターの編集 |

## 画面種別

編集

## URL/ルーティング

`asp/bs_editFooter.asp`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| フッターHTML | sFooter | 入力 | HTML | - | - | フッター領域に表示するHTMLコンテンツ |
| CSRFトークン | QSSEC | 入力 | 文字列 | * | - | CSRF検証用 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| フッターラベル | "Footer:"の表示 |
| WYSIWYGエディタ | フッターHTMLの編集領域（FCKEditor） |
| 保存ボタン | フォーム送信用（hidden） |

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時、以下の処理が実行されます：
1. CSRF検証（checkCSRF）
2. convertStr()でフォーム値を変換
3. customer.sFooterにフッターHTMLを設定
4. customer.save()で保存
5. 成功時はfb_saveOKメッセージを追加

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | フッターHTMLの更新 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sFooter | フォーム入力値（removeEmptyP処理後） | フッターHTML |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| fb_saveOK | 成功 | 保存が正常に完了しました | 保存成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | logon.hasaccessでアクセス拒否 |
| CSRFトークン不正 | checkCSRFで処理中断 |

## 備考

- フッターHTMLはremoveEmptyP()で空のpタグを除去してから保存される
- FCKEditorの設定は"siteBuilderFooter"を使用
- テーブル幅は640px、高さは80%
- 保存後は同じ画面に留まり、編集を継続可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フッターに関連するデータ構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのsFooterプロパティ（11, 138, 322, 383行目） |

**読解のコツ**:
- 11行目: sFooterプロパティの宣言
- 138行目: データベースからの読み込み（Pick関数内）
- 322行目: removeEmptyP()による空pタグ除去（Save関数内）
- 383行目: データベースへの保存（Save関数内）

#### Step 2: エントリーポイントを理解する

画面処理の流れを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editFooter.asp | `asp/bs_editFooter.asp` | 画面全体の処理フロー（1-9行目） |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（secondAdmin.bSetupPageElements）
2. **4行目**: btnaction="save"の場合の処理分岐
3. **5行目**: CSRF検証（checkCSRF）
4. **6行目**: convertStr()でフォーム値を変換してcustomer.sFooterに設定
5. **7行目**: customer.save()で保存、成功時メッセージ追加
6. **8行目**: フォーム表示（FCKEditor）

#### Step 3: FCKEditorの初期化を理解する

WYSIWYGエディタの設定を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editFooter.asp | `asp/bs_editFooter.asp` | createFCKInstance呼び出し（8行目） |

**createFCKInstance関数のパラメータ**:
- 第1引数: 初期値（customer.sFooter）
- 第2引数: エディタ設定名（"siteBuilderFooter"）
- 第3引数: フィールド名（"sFooter"）

### プログラム呼び出し階層図

```
bs_editFooter.asp (フッター編集画面)
    |
    +-- bs_security.asp (認証・権限チェック)
    |       +-- logon.hasaccess (secondAdmin.bSetupPageElements)
    |
    +-- getBOHeader(btn_Setup)
    |       +-- 管理画面ヘッダー表示
    |
    +-- getBOSetupMenu(btn_pageelements)
    |       +-- 設定サブメニュー表示
    |
    +-- [btnaction="save"の場合]
    |       +-- checkCSRF()
    |       +-- convertStr(Request.Form("sFooter"))
    |       +-- customer.sFooter = 変換値
    |       +-- customer.save()
    |               +-- removeEmptyP(sFooter)
    |               +-- tblCustomer UPDATE
    |       +-- message.Add("fb_saveOK")
    |
    +-- <form> フォーム表示
            +-- QS_secCodeHidden (CSRFトークン)
            +-- createFCKInstance()
                    +-- FCKEditor初期化
                    +-- "siteBuilderFooter"設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォームPOST ─────────> bs_editFooter.asp ───────────> tblCustomer
(sFooter)               checkCSRF()                   (UPDATE)
                              |
                              v
                        convertStr(sFooter)
                              |
                              v
                        customer.sFooter = 値
                              |
                              v
                        customer.save()
                              |
                              v
                        removeEmptyP(sFooter)
                        空<p></p>タグ除去
                              |
                              v
                        rs("sFooter") = sFooter
                              |
                              v
                        message.Add("fb_saveOK")
                              |
                              v
                        画面再表示（保存後の値）

[フロントサイドでの使用]

テンプレート ────────> [FOOTER] タグ ──────────────> customer.sFooter表示
(*.asp)                 置換処理                    HTMLレンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editFooter.asp | `asp/bs_editFooter.asp` | ソース | フッター編集画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス（sFooterプロパティ） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| bs_endBack.asp | `asp/bs_endBack.asp` | ソース | バックサイト終了処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | 管理画面ヘッダー |

### フッターの使用箇所

フッターHTMLは以下の方法でフロントサイトに表示されます：

```
1. テンプレート内に [FOOTER] タグを配置
2. ページレンダリング時に置換処理
3. customer.sFooterの内容がHTMLとして出力
```

- フッターはcls_customerクラスのsFooterプロパティとして管理
- tblCustomerテーブルのsFooterカラムに保存
- removeEmptyP()関数で空のpタグを除去してからDBに保存
