# 画面設計書 91-ヘッダー編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるヘッダー表示処理機能について記述する。bs_header.aspはヘッダーメニュー構築のための共通インクルードファイルであり、サイト管理者向けのナビゲーションメニューを動的に生成する。

### 本画面の処理概要

本ファイルは、バックサイト管理画面のヘッダーメニューを構築するための共通処理ファイルである。単独の画面としてではなく、他のバックサイト画面にインクルードされて使用される。

**業務上の目的・背景**：バックサイト管理画面では、複数の機能（ページ管理、フォーム、ギャラリー、ニュースレター等）へのアクセスが必要となる。ヘッダーメニューを共通化することで、一貫したユーザーインターフェースを提供し、管理者が各機能に効率的にアクセスできるようにする。また、secondAdmin（サブ管理者）の権限に応じてメニュー項目を動的に表示/非表示することで、セキュリティとユーザビリティを両立している。

**画面へのアクセス方法**：本ファイルは直接アクセスする画面ではなく、バックサイト管理画面（bs_*.asp）から`<!-- #include file="bs_header.asp"-->`によりインクルードされる。

**主要な操作・処理内容**：
1. buildMenu関数でメニューテーブルの構築（HTMLテーブル形式でアイコン付きメニューを生成）
2. getMenuArray関数でメインメニュー配列の取得（ホーム、設定、フォーム等の項目）
3. getBSArtMenu関数でARTテーマ形式のメニュー生成（ドロップダウンサブメニュー付き）
4. 各種補助メニュー配列取得（イントラネット、BOセットアップ、テンプレート等）
5. secondAdmin権限に基づくメニュー項目の表示制御

**画面遷移**：本処理は画面遷移の起点となり、以下の画面への遷移リンクを提供する
- bs_default.asp（バックサイトホーム）
- bs_admin.asp（一般設定）
- bs_stats.asp（統計）
- bs_templateList.asp（テンプレート一覧）
- bs_FormList.asp（フォーム一覧）
- bs_Intranet.asp（イントラネット管理）
- その他各モジュールへのリンク

**権限による表示制御**：secondAdminオブジェクトの各権限フラグに基づき、以下の制御を行う
- bSetupGeneral: 一般設定へのアクセス
- bStats: 統計画面へのアクセス
- bTemplates: テンプレート管理へのアクセス
- bForms: フォーム管理へのアクセス
- bIntranet: イントラネット管理へのアクセス
- bCatalog, bFeed, bGallery, bPoll, bGuestbook, bPopup, bNewsletter: 各モジュールへのアクセス

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | バナーメニュー編集 | 主機能 | サイトヘッダーの表示処理 |
| 8 | ページ一覧 | 遷移先機能 | ホームメニューからページ一覧への遷移 |
| 91 | アクセス統計表示 | 遷移先機能 | 設定メニューから統計画面への遷移 |
| 3 | セカンドアドミン管理 | 補助機能 | 権限に基づくメニュー表示制御 |

## 画面種別

共通インクルードファイル（ヘッダーメニュー）

## URL/ルーティング

```
asp/bs_header.asp（直接アクセス不可）
```

## 入出力項目

本ファイルは入力項目を持たない。出力としてHTML形式のメニューを生成する。

### 出力項目

| 項目名 | 内容 | 備考 |
|--------|------|------|
| メニューHTML | 動的生成されたナビゲーションメニュー | テーブル形式またはリスト形式 |

## 表示項目

### メニュー項目一覧

| 項目 | アイコン | 表示条件 | 遷移先 |
|------|----------|----------|--------|
| Help | - | 常時 | MYQS_urlSupport（外部） |
| Setup | settings | 権限あり | bs_admin.asp等 |
| Home | - | 常時 | bs_default.asp |
| Files | - | bFiles | bs_assetmanager.asp |
| Forms | - | bForms | bs_FormList.asp |
| Intranet | vpn_lock | bIntranet | bs_Intranet.asp |
| Catalog | - | bCatalog | bs_catalogList.asp |
| Feed | - | bFeed | bs_feedList.asp |
| Gallery | - | bGallery (QS_ASPX) | bs_galleryList.asp |
| Poll | - | bPoll | bs_pollList.asp |
| Guestbook | - | bGuestbook | bs_gbList.asp |
| Popup | - | bPopup | bs_popupList.asp |
| Newsletter | - | bNewsletter | bs_newsletterList.asp |
| Availability Calendars | - | bAvailabilityCal | bs_ac.asp |
| Check | preview | 常時 | ../default.asp（プレビュー） |
| Exit | - | 常時 | bs_logoff.asp |

## イベント仕様

### 1-メニュー項目クリック

各メニュー項目をクリックすると、対応する管理画面へ遷移する。外部リンク（HelpやCheck）は新しいウィンドウで開く。

## データベース更新仕様

本ファイルはデータベースの更新を行わない（参照のみ）。

## メッセージ仕様

本ファイルはメッセージを表示しない。

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | getBSArtMenu関数内でセッション認証を確認し、未認証の場合はログインメニューのみ表示 |
| Cookie認証モード | QS_enableCookieModeがtrueの場合、Cookie認証を試行 |

## 備考

- Material Symbolsアイコンフォントを使用
- ARTテーマテンプレートとの統合を前提とした設計
- セッション変数にメニューHTMLをキャッシュして再利用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メニュー構造は2次元配列で管理されており、各メニュー項目は5つの要素を持つ。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_header.asp | `asp/bs_header.asp` | arrMenu配列の構造（0:ボタン種別、1:URL、2:ラベル、3:ターゲット、4:カテゴリ） |

**読解のコツ**: arrMenu (0,x)からarrMenu (4,x)までの5要素で1つのメニュー項目を定義。カテゴリ(4)がサブメニューのグループ化に使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_header.asp | `asp/bs_header.asp` | getBOHeader関数、getBSArtMenu関数が他の画面から呼び出されるエントリーポイント |

**主要処理フロー**:
1. **行56-58**: getBOHeader関数（obsolete、現在は未使用）
2. **行59-188**: getMenuArray関数でメインメニュー配列を構築
3. **行189-293**: getBSArtMenu関数でHTML形式のメニューを生成

#### Step 3: メニュー構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_header.asp | `asp/bs_header.asp` | buildMenu関数（行4-54）でHTMLテーブル形式のメニューを生成 |
| 3-2 | bs_header.asp | `asp/bs_header.asp` | select case文（行25-42）でアイコンを決定 |

**主要処理フロー**:
- **行4-54**: buildMenu関数 - 配列からHTMLテーブルを生成
- **行20-42**: Material Symbolsアイコンの選択ロジック
- **行189-293**: getBSArtMenu関数 - ARTテーマ形式のドロップダウンメニュー生成

#### Step 4: 権限制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_security.asp | `asp/bs_security.asp` | secondAdminオブジェクトの権限フラグ定義 |
| 4-2 | bs_header.asp | `asp/bs_header.asp` | if secondAdmin.bXxx then による条件分岐 |

**主要処理フロー**:
- **行70-80**: Setup項目の遷移先を権限に応じて決定
- **行86-176**: 各モジュールの表示可否をsecondAdmin権限で判定

### プログラム呼び出し階層図

```
バックサイト画面 (bs_*.asp)
    │
    ├── #include "bs_header.asp"
    │       │
    │       ├── getBOHeader(btn) [obsolete]
    │       │
    │       ├── getMenuArray()
    │       │       └── メニュー配列を構築
    │       │
    │       ├── getBSArtMenu()
    │       │       ├── getMenuArray()
    │       │       ├── getIntranetMenuArray()
    │       │       ├── getBOSetupMenuArr()
    │       │       ├── getTemplateMenuArr()
    │       │       ├── getNLMenuArr()
    │       │       ├── getPEMenuArr()
    │       │       └── getHomeMenuArr()
    │       │
    │       └── buildMenu(arrMenu, btn, iCols)
    │               └── HTMLテーブル生成
    │
    └── Response.Write メニューHTML
```

### データフロー図

```
[入力]               [処理]                    [出力]

secondAdmin     ───▶ getMenuArray()      ───▶ メニュー配列
（権限情報）          （配列構築）
                          │
                          ▼
customer        ───▶ getBSArtMenu()      ───▶ HTML文字列
（顧客設定）          （HTML生成）
                          │
                          ▼
session         ───▶ メニューキャッシュ   ───▶ 高速レスポンス
（セッション）        （再利用）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_header.asp | `asp/bs_header.asp` | ソース | メインヘッダーメニュー処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| includes/header.asp | `asp/includes/header.asp` | ソース | HTMLヘッダー出力 |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
