# 画面設計書 92-バナーメニュー編集

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるバナーメニュー編集画面について記述する。bs_editBannerMenu.aspはサイトのヘッダー領域に表示されるバナー（左バナー、メニュー下バナー、右バナー）を編集するための画面である。

### 本画面の処理概要

本画面では、サイトのヘッダー領域に表示される各種バナーコンテンツをWYSIWYGエディタ（FCKEditor）を使用して編集できる。デフォルトテンプレートの有無により、編集可能な項目が変化する。

**業務上の目的・背景**：Webサイトのヘッダー領域は訪問者が最初に目にする重要な部分である。本画面を使用することで、サイト管理者はプログラミング知識なしにヘッダーのビジュアル要素（ロゴ、バナー画像、ナビゲーションメニュー等）をカスタマイズできる。これにより、サイトのブランディングやユーザーエクスペリエンスの向上が可能となる。

**画面へのアクセス方法**：バックサイトホーム → セットアップ → ページ要素 → バナーメニュー編集、またはbs_pageelements.aspからのリンクでアクセス

**主要な操作・処理内容**：
1. 左バナー（sLeftBanner）の編集 - デフォルトテンプレート未設定時のみ
2. メニュー下バナー（sBannerMenu）の編集
3. 右バナー（sRightBanner）の編集
4. ハイライトラベル（sHighlights）の編集 - デフォルトテンプレート設定時
5. 連絡先情報ラベル（sContactInfo）の編集 - デフォルトテンプレート設定時
6. アプリケーションパス（bannerApplication）の編集 - bApplication有効時

**画面遷移**：
- 遷移元：bs_pageelements.asp（ページ要素管理）、bs_admin.asp（一般設定）
- 遷移先：保存成功時は自画面にリダイレクト（メッセージ表示）

**権限による表示制御**：
- secondAdmin.bSetupPageElements権限が必要
- secondAdmin.bApplicationpath権限がある場合のみアプリケーションパス編集可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | バナーメニュー編集 | 主機能 | サイトヘッダーのバナー画像・メニュー編集 |
| 5 | サイト基本設定 | 補助機能 | サイト全体の設定との連携 |

## 画面種別

編集画面

## URL/ルーティング

```
asp/bs_editBannerMenu.asp
```

## 入出力項目

### 入力項目

| 項目名 | 物理名 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| 左バナー | sLeftBanner | Memo | - | - | 左側バナーHTML（FCKEditor） |
| メニュー下バナー | sBannerMenu | Memo | - | - | メニュー下部バナーHTML（FCKEditor） |
| 右バナー | sRightBanner | Memo | - | - | 右側バナーHTML（FCKEditor） |
| ハイライト | sHighlights | Text | - | 50 | ハイライトラベル |
| 連絡先情報 | sContactInfo | Text | - | 50 | 連絡先情報ラベル |
| アプリケーションパス | bannerApplication | Text | - | 255 | アプリケーション用パス |
| 保存ボタン | btnaction | Text | YES | - | 保存アクション識別子 |

## 表示項目

### デフォルトテンプレート未設定時

| 項目名 | 説明 |
|--------|------|
| 左バナー | WYSIWYGエディタ |
| メニュー下バナー | WYSIWYGエディタ |
| 右バナー | WYSIWYGエディタ |
| アプリケーションパス | テキスト入力（条件付き） |

### デフォルトテンプレート設定時

| 項目名 | 説明 |
|--------|------|
| 連絡先情報 | テキスト入力 |
| ハイライト | テキスト入力 |
| メニュー下バナー | WYSIWYGエディタ |
| 右バナー | WYSIWYGエディタ |

## イベント仕様

### 1-保存ボタン押下

保存ボタン（btnaction=l("save")）を押下すると、以下の処理が実行される。

1. CSRF検証（checkCSRF()）
2. フォームデータの取得と加工
   - removeEmptyP関数で空のPタグを除去（sLeftBanner, sBannerMenu, sRightBanner）
3. customerオブジェクトへの値設定
4. customer.save()によるデータベース保存
5. 成功時：message.Add("fb_saveOK")でメッセージ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | バナー関連カラムの更新 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sLeftBanner | フォーム入力値（空P除去後） | Memo型 |
| UPDATE | sBannerMenu | フォーム入力値（空P除去後） | Memo型 |
| UPDATE | sRightBanner | フォーム入力値（空P除去後） | Memo型 |
| UPDATE | sHighlights | フォーム入力値 | Text(50) |
| UPDATE | sContactInfo | フォーム入力値 | Text(50) |
| UPDATE | bannerApplication | フォーム入力値 | 条件付き |

## メッセージ仕様

| 種別 | メッセージID | 内容 | 表示条件 |
|------|-------------|------|----------|
| 成功 | fb_saveOK | 保存が完了しました | 保存成功時 |

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| CSRF検証失敗 | checkCSRF()でエラー、処理中断 |
| 権限不足 | logon.hasaccess secondAdmin.bSetupPageElementsでアクセス拒否 |
| 保存失敗 | customer.save()がfalseを返す場合、メッセージ非表示 |

## 備考

- FCKEditorを使用したWYSIWYGエディタによる編集
- createFCKInstance関数でエディタインスタンスを生成
- デフォルトテンプレートの設定有無で表示項目が変化
- QS_secCodeHiddenによるCSRF対策

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バナー情報はtblCustomerテーブルに格納される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblCustomerのsLeftBanner, sBannerMenu, sRightBannerカラム |

**読解のコツ**: tblCustomer.sLeftBanner等はMemo型でHTML文字列を格納。customer.defaultTemplateの値によって編集対象が変わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editBannerMenu.asp | `asp/bs_editBannerMenu.asp` | POSTリクエスト処理とフォーム表示 |

**主要処理フロー**:
1. **行1**: begin.aspのインクルード
2. **行4**: bs_security.aspで権限確認
3. **行4-12**: POSTリクエスト時の保存処理
4. **行13-14**: フォーム表示（デフォルトテンプレート有無で分岐）

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editBannerMenu.asp | `asp/bs_editBannerMenu.asp` | 行4-12のif文内 |

**主要処理フロー**:
- **行5**: checkCSRF()でセキュリティ検証
- **行6**: sLeftBannerの取得とremoveEmptyP処理
- **行7**: sBannerMenuの取得
- **行8**: sRightBannerの取得
- **行9-10**: sHighlights, sContactInfoの取得
- **行11**: bannerApplicationの条件付き取得
- **行12**: customer.save()で保存、成功時メッセージ追加

#### Step 4: 表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_editBannerMenu.asp | `asp/bs_editBannerMenu.asp` | 行13-14のフォーム表示部分 |

**主要処理フロー**:
- **行13**: customer.defaultTemplate=0の場合（3カラムレイアウト）
- **行14**: それ以外の場合（2カラムレイアウト + テキスト入力）
- createFCKInstance関数でWYSIWYGエディタを生成

### プログラム呼び出し階層図

```
bs_editBannerMenu.asp
    │
    ├── #include "begin.asp"
    │       └── 共通初期化処理
    │
    ├── #include "bs_security.asp"
    │       └── logon.hasaccess(secondAdmin.bSetupPageElements)
    │
    ├── checkCSRF()
    │       └── CSRF検証
    │
    ├── removeEmptyP()
    │       └── 空のPタグを除去
    │
    ├── customer.save()
    │       └── tblCustomerへの保存
    │
    ├── createFCKInstance()
    │       └── FCKEditor初期化
    │
    └── #include "includes/footer.asp"
            └── フッター出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

POSTデータ      ───▶ checkCSRF()         ───▶ 検証結果
（バナーHTML）        （セキュリティ検証）
       │
       ▼
フォーム入力    ───▶ removeEmptyP()      ───▶ 整形済みHTML
（sLeftBanner等）     （HTML整形）
       │
       ▼
整形済みデータ  ───▶ customer.save()     ───▶ tblCustomer
                      （DB保存）              （更新）
       │
       ▼
保存結果       ───▶ message.Add()        ───▶ フィードバック表示
                      （メッセージ設定）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editBannerMenu.asp | `asp/bs_editBannerMenu.asp` | ソース | メイン画面処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダーメニュー |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| bs_endBack.asp | `asp/bs_endBack.asp` | ソース | バックサイト終了処理 |
