# 画面設計書 93-矢印アップ設定

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるスクロールトップボタン（Scroll To Top）設定画面について記述する。bs_arrowup.aspはページ下部に表示される「ページトップへ戻る」ボタンの矢印デザインを選択・設定するための画面である。

### 本画面の処理概要

本画面では、Webサイトのフロントエンドに表示されるスクロールトップボタン（ページトップへ戻るボタン）の矢印画像を選択できる。サーバー上のfixedImages/arrowsフォルダに格納されている矢印画像から1つを選択するか、表示しない設定を選択できる。

**業務上の目的・背景**：長いWebページではユーザーがページトップに戻るためにスクロールする必要があり、ユーザビリティが低下する。スクロールトップボタンを設置することで、ワンクリックでページトップに戻ることができ、ユーザーエクスペリエンスが向上する。本画面により、サイトのデザインに合った矢印画像を管理者が選択できる。

**画面へのアクセス方法**：バックサイトホーム → セットアップ → Scroll To Top、またはbs_header.aspのセットアップメニュー（getBOSetupMenuArr関数内のリンク）からアクセス

**主要な操作・処理内容**：
1. 現在設定されている矢印画像の確認
2. 利用可能な矢印画像の一覧表示
3. 矢印画像の選択（ラジオボタン）
4. 「No arrow」オプションで矢印非表示設定
5. 保存ボタン押下で設定を反映

**画面遷移**：
- 遷移元：bs_admin.asp、bs_pageelements.asp、セットアップメニュー
- 遷移先：保存成功時は自画面にリダイレクト（fbMessage=fb_saveOK）

**権限による表示制御**：
- バックサイトへのログイン認証が必要
- 特別な権限チェックは行われていない（一般的な管理者権限で編集可能）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | Scroll To Top設定 | 主機能 | スクロールトップボタンの設定 |
| 5 | サイト基本設定 | 補助機能 | サイト全体の設定との連携 |

## 画面種別

設定画面

## URL/ルーティング

```
asp/bs_arrowup.asp
```

## 入出力項目

### 入力項目

| 項目名 | 物理名 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| 矢印画像 | sArrowUP | Text | - | 255 | 選択した矢印画像ファイル名（空文字で非表示） |
| ポストバックフラグ | postback | Boolean | - | - | フォーム送信フラグ |

## 表示項目

### 矢印選択エリア

| 項目名 | 説明 |
|--------|------|
| No arrow | 矢印を表示しないオプション（ラジオボタン） |
| 矢印画像一覧 | fixedImages/arrowsフォルダ内の画像を動的に一覧表示 |
| 各矢印画像 | 画像プレビューとラジオボタン |
| 保存ボタン | 設定を保存 |

## イベント仕様

### 1-保存ボタン押下

保存ボタン（btnaction）を押下すると、以下の処理が実行される。

1. postbackフラグの確認
2. sArrowUP値の取得（選択された矢印ファイル名または空文字）
3. customer.sArrowUP への値設定
4. customer.save() によるデータベース保存
5. 成功時：bs_arrowUp.asp?fbMessage=fb_saveOK にリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | tblCustomer | UPDATE | sArrowUPカラムの更新 |

### テーブル別更新項目詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sArrowUP | 選択した矢印画像ファイル名（空文字で非表示） | Text(255) |

## メッセージ仕様

| 種別 | メッセージID | 内容 | 表示条件 |
|------|-------------|------|----------|
| 成功 | fb_saveOK | 保存が完了しました | 保存成功時（URLパラメータで渡される） |

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | bs_security.aspで認証チェック、未認証時はnoaccess.htmにリダイレクト |
| 保存失敗 | customer.save()がfalseを返す場合、リダイレクトされない |
| フォルダ不存在 | FileSystemObjectでフォルダが存在しない場合、画像一覧が空になる |

## 備考

- FileSystemObject（scripting.filesystemobject）を使用してサーバー上の画像ファイルを動的に取得
- C_DIRECTORY_QUICKERSITE定数でQuickerSiteのルートディレクトリを参照
- 矢印画像はfixedImages/arrowsフォルダに格納されている
- 選択状態はcustomer.sArrowUPと比較して現在選択されている画像を判定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

矢印設定はtblCustomerテーブルのsArrowUPカラムに格納される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblCustomerのsArrowUPカラム（行108） |

**読解のコツ**: sArrowUPはText(255)型で、画像ファイル名を格納。空文字の場合は矢印非表示。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_arrowup.asp | `asp/bs_arrowup.asp` | 全体の処理フロー |

**主要処理フロー**:
1. **行1-3**: インクルードファイル読み込み
2. **行4-16**: POSTリクエスト処理（postback=trueの場合）
3. **行20-55**: フォーム表示（矢印選択UI）

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_arrowup.asp | `asp/bs_arrowup.asp` | 行7-15のif文内 |

**主要処理フロー**:
- **行5**: postbackフラグの取得
- **行7-15**: postback=trueの場合の処理
- **行9**: customer.sArrowUPへの値設定
- **行12-13**: customer.save()成功時にリダイレクト

#### Step 4: 画像一覧取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_arrowup.asp | `asp/bs_arrowup.asp` | 行34-48のfor each文 |

**主要処理フロー**:
- **行35-37**: FileSystemObjectの作成とフォルダ取得
- **行38**: server.mapPathでサーバー上の物理パスを取得
- **行40-47**: フォルダ内の各ファイルをループ処理
- **行43-44**: 画像表示とラジオボタン生成

### プログラム呼び出し階層図

```
bs_arrowup.asp
    │
    ├── #include "begin.asp"
    │       └── 共通初期化処理
    │
    ├── #include "bs_security.asp"
    │       └── 認証チェック
    │
    ├── #include "includes/header.asp"
    │       └── HTMLヘッダー出力
    │
    ├── POST処理（postback=true）
    │       │
    │       ├── customer.sArrowUP = request.form("sArrowUP")
    │       │
    │       └── customer.save()
    │               └── tblCustomerへの保存
    │
    ├── フォーム表示
    │       │
    │       ├── FileSystemObject.getFolder()
    │       │       └── 矢印画像フォルダを取得
    │       │
    │       └── for each file in folder.files
    │               └── 各画像のラジオボタンを生成
    │
    └── #include "includes/footer.asp"
            └── フッター出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

POSTデータ      ───▶ postbackフラグ確認   ───▶ 処理分岐
（sArrowUP）
       │
       ▼
選択値         ───▶ customer.sArrowUP    ───▶ オブジェクト設定
                      （プロパティ設定）
       │
       ▼
customerオブジェクト ─▶ customer.save()    ───▶ tblCustomer
                         （DB保存）              （更新）
       │
       ▼
保存結果       ───▶ response.redirect    ───▶ 画面リフレッシュ
                      （リダイレクト）            + メッセージ

[画像一覧取得]

サーバーパス   ───▶ FileSystemObject     ───▶ ファイル一覧
                      （フォルダ読み込み）
       │
       ▼
ファイル一覧   ───▶ for each file        ───▶ HTML生成
                      （ループ処理）              （ラジオボタン）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_arrowup.asp | `asp/bs_arrowup.asp` | ソース | メイン画面処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダーメニュー |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
| includes/urlenCodeJS.asp | `asp/includes/urlenCodeJS.asp` | ソース | URLエンコード用JavaScript |
| fixedImages/arrows/* | `QuickerSite/fixedImages/arrows/` | 画像 | 矢印画像ファイル |
