# 画面設計書 94-スクリプト一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるASP/VBScript一覧画面について記述する。bs_scriptList.aspはサイトに登録されているカスタムVBScript（定数タイプがQS_VBScriptのもの）を一覧表示し、管理するための画面である。

### 本画面の処理概要

本画面では、サイトに登録されているカスタムVBScriptの一覧を表示する。これらのスクリプトはテンプレート内で[定数名]の形式で参照され、動的なコンテンツ生成に使用される。管理者はこの画面からスクリプトの新規作成画面や編集画面に遷移できる。

**業務上の目的・背景**：CMSの標準機能だけでは実現できないカスタム処理（動的コンテンツ生成、外部API連携、条件分岐表示等）を実装するため、VBScriptを登録・管理する機能が必要である。本画面により、登録済みのスクリプトを一覧で確認し、効率的に管理できる。

**画面へのアクセス方法**：バックサイトホーム → ページ一覧メニュー → ASP/VBScripts、またはホームメニューのサブメニューからアクセス（secondAdmin.bHomeVBScript権限が必要）

**主要な操作・処理内容**：
1. 登録済みVBScriptの一覧表示
2. 各スクリプトのコード（テンプレート参照用）の表示
3. スクリプト名とパラメータの表示
4. スクリプトのステータス（オンライン/オフライン）の表示
5. 新規スクリプト作成画面への遷移
6. 既存スクリプト編集画面への遷移
7. 定数一覧画面への遷移

**画面遷移**：
- 遷移元：bs_default.asp（バックサイトホーム）、ホームメニューのASP/VBScriptsリンク
- 遷移先：bs_constantEdit.asp（スクリプト編集）、bs_constantList.asp（定数一覧）

**権限による表示制御**：
- secondAdmin.bHomeVBScript権限が必要
- customer.bApplicationがfalseの場合、bs_constantList.aspにリダイレクト

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 96 | スクリプト管理 | 主機能 | カスタムASP/VBScriptの一覧表示・管理 |
| 94 | 定数一覧 | 遷移先機能 | 定数一覧画面への遷移 |
| 95 | 定数作成・編集 | 遷移先機能 | 新規スクリプト作成・編集画面への遷移 |

## 画面種別

一覧画面

## URL/ルーティング

```
asp/bs_scriptList.asp
```

## 入出力項目

本画面は入力項目を持たない（表示専用）。

## 表示項目

### スクリプト一覧

| 項目名 | 説明 | データソース |
|--------|------|--------------|
| コード入力欄 | テンプレート参照用コード [定数名] | tblConstant.sConstant |
| スクリプト名 | スクリプトの名称（リンク） | tblConstant.sConstant |
| パラメータ | スクリプトのパラメータ定義 | tblConstant.sParameters |
| ID | スクリプトのID | tblConstant.iId |
| ステータス | オンライン/オフラインの状態 | tblConstant.bOnline（statusString） |

### ナビゲーションリンク

| 項目名 | 遷移先 |
|--------|--------|
| ページ一覧 | bs_default.asp |
| 新規アイテム | bs_constantEdit.asp?iType=QS_VBScript |
| 定数一覧 | bs_constantlist.asp |

## イベント仕様

### 1-スクリプト名リンククリック

スクリプト名（リンク）をクリックすると、該当スクリプトの編集画面（bs_constantEdit.asp）に遷移する。

### 2-新規アイテムリンククリック

「新規アイテム」リンクをクリックすると、新規スクリプト作成画面（bs_constantEdit.asp?iType=QS_VBScript）に遷移する。

### 3-コード入力欄クリック

コード入力欄をクリックすると、テキストが全選択され、コピーしやすくなる（javascript:this.select()）。

## データベース更新仕様

本画面はデータベースの更新を行わない（参照のみ）。

### 参照テーブル

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblConstant | SELECT | iCustomerID=cId AND iType=QS_VBScript |

## メッセージ仕様

本画面は特別なメッセージを表示しない。

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | bs_security.aspで認証チェック、未認証時はnoaccess.htmにリダイレクト |
| 権限不足 | logon.hasaccess secondAdmin.bHomeVBScriptでアクセス拒否 |
| アプリケーション無効 | customer.bApplication=falseの場合、bs_constantList.aspにリダイレクト |
| スクリプト0件 | customer.constants.count>0の条件分岐で空の場合はリストを表示しない |

## 備考

- QS_VBScript定数でスクリプトタイプを識別
- customer.constantsプロパティでスクリプト一覧を取得
- encrypt関数でIDを暗号化してURLパラメータに使用
- sanitize関数でXSS対策を実施

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スクリプト情報はtblConstantテーブルに格納される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblConstantテーブルの構造（行612-628） |

**読解のコツ**: tblConstant.iTypeでタイプを識別。QS_VBScriptタイプのレコードがVBScriptを表す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_scriptList.asp | `asp/bs_scriptList.asp` | 全体の処理フロー |

**主要処理フロー**:
1. **行1-4**: インクルードファイル読み込みと権限チェック
2. **行4**: customer.bApplication確認、falseならリダイレクト
3. **行4-11**: 一覧表示処理

#### Step 3: 一覧表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_scriptList.asp | `asp/bs_scriptList.asp` | 行6-11のfor each文 |

**主要処理フロー**:
- **行6-7**: customer.constantsを取得
- **行8**: cconstants.count>0で件数確認
- **行8-10**: for each keyconstantsでループ
- **行9**: iType=QS_VBScriptでフィルタリング
- **行9**: 各スクリプトの情報をHTML出力

#### Step 4: リンク構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_scriptList.asp | `asp/bs_scriptList.asp` | 行4-5のgetArtLink関数呼び出し |

**主要処理フロー**:
- **行4**: ページ一覧リンク（bs_default.asp）
- **行5**: 新規アイテムリンク（bs_constantEdit.asp?iType=QS_VBScript）
- **行5**: 定数一覧リンク（bs_constantlist.asp）

### プログラム呼び出し階層図

```
bs_scriptList.asp
    │
    ├── #include "begin.asp"
    │       └── 共通初期化処理
    │
    ├── #include "bs_security.asp"
    │       └── logon.hasaccess(secondAdmin.bHomeVBScript)
    │
    ├── customer.bApplication確認
    │       └── false → bs_constantList.aspにリダイレクト
    │
    ├── #include "bs_process.asp"
    │       └── 共通処理（この画面では使用しない）
    │
    ├── customer.constants
    │       └── tblConstantからスクリプト一覧を取得
    │
    ├── for each keyconstants in cconstants
    │       │
    │       └── QS_VBScript=cconstants(keyconstants).iType
    │               └── VBScriptのみ表示
    │
    └── #include "includes/footer.asp"
            └── フッター出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

なし            ───▶ 認証・権限確認       ───▶ アクセス許可/拒否
                      │
                      ▼
customer        ───▶ customer.constants   ───▶ スクリプト一覧
（オブジェクト）       （プロパティ取得）
                      │
                      ▼
tblConstant     ───▶ iType=QS_VBScript    ───▶ フィルタ済み一覧
（テーブル）          （フィルタリング）
                      │
                      ▼
スクリプト一覧  ───▶ for each ループ      ───▶ HTML出力
                      （HTML生成）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_scriptList.asp | `asp/bs_scriptList.asp` | ソース | メイン画面処理 |
| bs_constantEdit.asp | `asp/bs_constantEdit.asp` | ソース | スクリプト編集画面 |
| bs_constantList.asp | `asp/bs_constantList.asp` | ソース | 定数一覧画面 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| bs_process.asp | `asp/bs_process.asp` | ソース | 共通処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダーメニュー |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
