# 画面設計書 95-統計画面

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるサイト統計画面について記述する。bs_stats.aspはサイトの各ページのヒット数（閲覧数）と訪問者数を一覧表示し、アクセス状況を把握するための画面である。

### 本画面の処理概要

本画面では、サイト内の全ページのアクセス統計情報を一覧形式で表示する。cls_searchクラスを使用してページ情報を取得し、ヒット数の降順でソートして表示する。また、RSSフィード経由のアクセス数も別途表示される。

**業務上の目的・背景**：サイト管理者はコンテンツの人気度やアクセス傾向を把握する必要がある。本画面により、どのページが多く閲覧されているか、1日あたりの平均アクセス数はどの程度かを確認でき、コンテンツ戦略の立案やサイト改善に活用できる。

**画面へのアクセス方法**：バックサイトホーム → セットアップ → 統計、またはセットアップメニューからアクセス

**主要な操作・処理内容**：
1. 全ページのアクセス統計一覧表示（タイトル、ヒット数、ヒット数/日、訪問者数、訪問者数/日）
2. RSSフィード経由のアクセス数表示（オレンジ色で表示）
3. 統計データのリセット（確認ダイアログ付き）
4. リファラー一覧画面への遷移（bScanreferer有効時）

**画面遷移**：
- 遷移元：bs_admin.asp、セットアップメニュー
- 遷移先：bs_referers.asp（リファラー一覧）、自画面（統計リセット後）

**権限による表示制御**：
- secondAdmin.bStats権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | アクセス統計表示 | 主機能 | ページ別のヒット数・訪問者数の確認 |
| 93 | 統計リセット | 補助機能 | アクセス統計のリセット処理 |
| 92 | 参照元サイト一覧 | 遷移先機能 | リファラー一覧画面への遷移 |

## 画面種別

一覧画面

## URL/ルーティング

```
asp/bs_stats.asp
```

## 入出力項目

### 入力項目

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| リセットアクション | btnaction | Text | - | "ResetStats"で統計リセット |

## 表示項目

### 統計一覧テーブル

| 項目名 | 説明 | データソース |
|--------|------|--------------|
| タイトル | ページタイトル | tblPage.sTitle |
| ヒット数 | 総閲覧数（RSSフィード数は別表示） | tblPage.iHits, iHitsRSS |
| ヒット数/日 | 1日あたり平均ヒット数 | iHits / aantalDagen |
| 訪問者数 | ユニーク訪問者数 | tblPage.iVisitors |
| 訪問者数/日 | 1日あたり平均訪問者数 | iVisitors / aantalDagen |

### フッター情報

| 項目名 | 説明 |
|--------|------|
| 統計リセット日 | 統計がリセットされた日時 |
| リセットリンク | 統計データをリセットするリンク |
| リファラーリンク | リファラー一覧画面へのリンク（条件付き） |

## イベント仕様

### 1-統計リセットリンククリック

「リセット」リンクをクリックすると、以下の処理が実行される。

1. JavaScript確認ダイアログ表示（l("areyousure")）
2. 確認OKの場合、btnaction=ResetStatsでリクエスト送信
3. bs_process.aspでcheckCSRF()とcustomer.resetStats()が実行される

### 2-リファラーリンククリック

「リファラー」リンクをクリックすると、bs_referers.asp（リファラー一覧画面）に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 統計リセット | tblPage | UPDATE | iHits, iHitsRSS, iVisitorsを0にリセット |
| 統計リセット | tblCustomer | UPDATE | dResetStatsに現在日時を設定 |

### テーブル別更新項目詳細

#### tblPage（統計リセット時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iHits | 0 | 全ページ対象 |
| UPDATE | iHitsRSS | 0 | 全ページ対象 |
| UPDATE | iVisitors | 0 | 全ページ対象 |

#### tblCustomer（統計リセット時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | dResetStats | now() | リセット日時を記録 |

## メッセージ仕様

| 種別 | メッセージID | 内容 | 表示条件 |
|------|-------------|------|----------|
| 説明 | hitsexpl | ヒット数の説明 | 常時表示 |
| 説明 | visitsexpl | 訪問者数の説明 | 常時表示 |
| 確認 | areyousure | 本当に実行しますか？ | リセット実行前 |

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | bs_security.aspで認証チェック、未認証時はnoaccess.htmにリダイレクト |
| 権限不足 | logon.hasaccess secondAdmin.bStatsでアクセス拒否 |

## 備考

- cls_searchクラスを使用してページ情報を取得
- sortableクラスでテーブルのソート機能を提供（JavaScriptライブラリ使用）
- aantalDagen（customer.aantalDagen）で統計リセットからの経過日数を取得
- RSSフィード経由のアクセス数はオレンジ色（#ffa500）で区別表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

統計情報はtblPageテーブルのiHits, iHitsRSS, iVisitorsカラムに格納される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblPageのiHits, iHitsRSS, iVisitorsカラム（行224-225） |
| 1-2 | search.asp | `asp/includes/search.asp` | cls_searchクラスの構造 |

**読解のコツ**: cls_searchクラスのresultsプロパティでページ一覧を取得。orderby="iHits desc"でヒット数降順ソート。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_stats.asp | `asp/bs_stats.asp` | 全体の処理フロー |

**主要処理フロー**:
1. **行1-4**: インクルードファイル読み込みと権限チェック
2. **行4-12**: cls_searchオブジェクトの初期化と設定
3. **行13-17**: 統計一覧テーブルの生成

#### Step 3: 検索処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_stats.asp | `asp/bs_stats.asp` | 行4-12のcls_search設定 |
| 3-2 | search.asp | `asp/includes/search.asp` | resultsプロパティの実装 |

**主要処理フロー**:
- **行4-5**: cls_searchオブジェクト作成
- **行6**: value=""（検索条件なし）
- **行7**: orderby="iHits desc"（ヒット数降順）
- **行8**: includeURL=false（外部URL除外）
- **行9**: allowEmptyString=true（空文字許可）
- **行10-11**: パスワード保護・イントラネットページも含める
- **行12**: results取得

#### Step 4: 統計リセット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_process.asp | `asp/bs_process.asp` | 行17-19のResetStats処理 |

**主要処理フロー**:
- **行17**: case "ResetStats"
- **行18**: checkCSRF()でCSRF検証
- **行19**: customer.resetStats()で統計リセット

### プログラム呼び出し階層図

```
bs_stats.asp
    │
    ├── #include "begin.asp"
    │       └── 共通初期化処理
    │
    ├── #include "bs_security.asp"
    │       └── logon.hasaccess(secondAdmin.bStats)
    │
    ├── #include "bs_process.asp"
    │       └── case "ResetStats" → customer.resetStats()
    │
    ├── cls_search
    │       │
    │       ├── value = ""
    │       ├── orderby = "iHits desc"
    │       ├── includeURL = false
    │       ├── allowEmptyString = true
    │       ├── includePasswordProtected = true
    │       ├── includeIntranet = true
    │       │
    │       └── results
    │               └── tblPageから統計情報取得
    │
    ├── customer.aantalDagen
    │       └── 統計リセットからの経過日数
    │
    └── for each item in stats
            └── 統計一覧をHTML出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

なし            ───▶ cls_search.results    ───▶ ページ統計一覧
                      （検索実行）
                      │
                      ▼
tblPage         ───▶ orderby iHits desc   ───▶ ソート済み一覧
（テーブル）          （ソート処理）
                      │
                      ▼
統計データ      ───▶ for each item        ───▶ HTML出力
                      （ループ処理）

[リセット処理]

btnaction       ───▶ bs_process.asp       ───▶ 処理分岐
= ResetStats          （アクション判定）
       │
       ▼
checkCSRF()     ───▶ customer.resetStats() ──▶ DB更新
（セキュリティ検証）   （統計リセット）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_stats.asp | `asp/bs_stats.asp` | ソース | メイン画面処理 |
| bs_referers.asp | `asp/bs_referers.asp` | ソース | リファラー一覧画面 |
| bs_process.asp | `asp/bs_process.asp` | ソース | 共通処理（ResetStats） |
| includes/search.asp | `asp/includes/search.asp` | ソース | cls_searchクラス |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダーメニュー |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | バックサイト初期化 |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
