# 画面設計書 96-リファラー一覧

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるリファラー（参照元サイト）一覧画面について記述する。bs_referers.aspは外部サイトからの流入情報を様々な切り口で分析・表示するための画面である。

### 本画面の処理概要

本画面では、外部サイトからサイトに訪問してきたユーザーの参照元情報を一覧表示する。グループ化条件（参照元URL、参照元サイト、IPアドレス、言語、ランディングページ、検索クエリ、フルログ）を切り替えることで、様々な観点からアクセス解析が可能である。

**業務上の目的・背景**：Webサイトへのトラフィックを分析するためには、どこからユーザーが訪問してきているかを把握することが重要である。本画面により、検索エンジンからの流入、他サイトからのリンク経由のアクセス、検索キーワード等を確認でき、SEO対策やマーケティング戦略の立案に活用できる。

**画面へのアクセス方法**：バックサイトホーム → セットアップ → 統計 → リファラー、またはbs_stats.aspからのリンクでアクセス

**主要な操作・処理内容**：
1. グループ化条件の選択（ドロップダウン）
2. 期間指定（開始日〜終了日）
3. リファラーデータの一覧表示
4. リファラーデータのリセット

**画面遷移**：
- 遷移元：bs_stats.asp（統計画面）、セットアップメニュー
- 遷移先：自画面（条件変更時）、bs_stats.asp（統計画面へ戻る）

**権限による表示制御**：
- secondAdmin.bStats権限が必要
- customer.bScanreferer=falseの場合、bs_statsにリダイレクト

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 92 | 参照元サイト一覧 | 主機能 | 外部サイトからの流入元の確認 |
| 91 | アクセス統計表示 | 遷移先機能 | 統計画面への遷移 |

## 画面種別

一覧画面（検索・フィルター機能付き）

## URL/ルーティング

```
asp/bs_referers.asp
```

## 入出力項目

### 入力項目

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| グループ化条件 | groupBy | Text | - | sb_ref_REFERER等の定数値 |
| 開始日 | dFrom | Date | - | 検索期間の開始日（デフォルト：7日前） |
| 終了日 | dUntill | Date | - | 検索期間の終了日（デフォルト：本日） |
| リセットアクション | pageAction | Text | - | "Reset"でリファラーデータリセット |

### グループ化条件一覧

| 値 | 名称 | 説明 |
|----|------|------|
| sb_ref_REFERER | 参照元URL | 完全なリファラーURL |
| sb_ref_URL | 参照元サイト | ドメイン単位の参照元 |
| sb_ref_USERIP | IP | ユーザーのIPアドレス |
| sb_ref_LA | 言語 | ブラウザの言語設定 |
| sb_ref_LP | ランディングページ | 最初にアクセスしたページ |
| sb_ref_QUERY | 検索クエリ | 検索エンジンからのキーワード |
| sb_ref_LOGFILE | フルログ | 全情報を含むログ形式 |

## 表示項目

### グループ化表示（REFERER, URL, USERIP, LP, LA, QUERY）

| 項目名 | 説明 |
|--------|------|
| グループ化項目 | 選択した条件でグループ化された値 |
| 件数 | 該当する件数 |

### フルログ表示（LOGFILE）

| 項目名 | 説明 | データソース |
|--------|------|--------------|
| 参照元サイト | リファラーURL | tblSession.Referer |
| ランディングページ | 最初にアクセスしたページ | tblSession.startpage |
| 言語 | ブラウザの言語設定 | tblSession.sLanguage |
| IP | ユーザーのIPアドレス | tblSession.UserIP |
| 日時 | アクセス日時 | tblSession.dTS |

## イベント仕様

### 1-グループ化条件変更

グループ化条件（selectボックス）を変更すると、onchangeイベントでフォームが自動送信され、選択した条件で一覧が再表示される。

### 2-検索実行

「Go!」ボタンをクリックすると、指定された条件（グループ化、期間）でリファラーデータを検索し、一覧表示する。

### 3-リファラーデータリセット

「リセット」リンクをクリックすると、以下の処理が実行される。

1. JavaScript確認ダイアログ表示
2. 確認OKの場合、pageAction=Resetでリクエスト送信
3. checkCSRF()でCSRF検証
4. removeReferers()でtblSessionからリファラーデータを削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リファラーリセット | tblSession | DELETE | 該当顧客のリファラーデータを全削除 |

### テーブル別更新項目詳細

#### tblSession（リセット時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | 全レコード | WHERE iCustomerID=cId | 顧客別に削除 |

## メッセージ仕様

| 種別 | メッセージID | 内容 | 表示条件 |
|------|-------------|------|----------|
| 確認 | areyousure | 本当に実行しますか？ | リセット実行前 |

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | bs_security.aspで認証チェック、未認証時はnoaccess.htmにリダイレクト |
| 権限不足 | logon.hasaccess secondAdmin.bStatsでアクセス拒否 |
| リファラースキャン無効 | customer.bScanreferer=falseでbs_statsにリダイレクト |
| データなし | 一覧が空の状態で表示 |

## 備考

- cls_refGroupByListクラスでグループ化条件の選択肢を管理
- getReferersArr関数でtblSessionからリファラーデータを取得
- filterURL関数でURLからドメインを抽出
- filterQuery関数で検索クエリを抽出
- URLDecode2関数でURLエンコードされた文字列をデコード
- JQDatePicker関数でjQuery UIの日付ピッカーを生成
- sortableクラスでテーブルのソート機能を提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リファラー情報はtblSessionテーブルに格納される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblSessionテーブルの構造（行28） |
| 1-2 | logvisit.asp | `asp/includes/logvisit.asp` | getReferersArr関数の実装 |
| 1-3 | groupRefByList.asp | `asp/includes/groupRefByList.asp` | cls_refGroupByListクラス |

**読解のコツ**: tblSessionにはReferer, Browser, startpage, UserIP, sLanguage, dTSなどが格納される。グループ化条件によって表示カラムが変わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_referers.asp | `asp/bs_referers.asp` | 全体の処理フロー（行1-84） |

**主要処理フロー**:
1. **行1-4**: インクルードファイル読み込みと権限チェック
2. **行4-31**: URLDecode2関数の定義
3. **行24-32**: 検索条件の取得と初期化
4. **行33-83**: 検索実行と結果表示

#### Step 3: リファラー取得処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | logvisit.asp | `asp/includes/logvisit.asp` | getReferersArr関数（行46-63） |

**主要処理フロー**:
- **行46-54**: SQL文構築（tblSessionからSELECT）
- **行52-53**: 日付範囲条件の追加
- **行55-61**: 結果取得とgetRows()

#### Step 4: グループ化表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_referers.asp | `asp/bs_referers.asp` | 行42-83の表示処理 |

**主要処理フロー**:
- **行42-56**: groupByに応じたkeyValue設定
- **行57-79**: for文でarrRefをループ、refDictに集計
- **行79-80**: refDictをループしてHTML出力

### プログラム呼び出し階層図

```
bs_referers.asp
    │
    ├── #include "begin.asp"
    │       └── 共通初期化処理
    │
    ├── #include "bs_security.asp"
    │       └── logon.hasaccess(secondAdmin.bStats)
    │
    ├── customer.bScanreferer確認
    │       └── false → bs_statsにリダイレクト
    │
    ├── cls_refGroupByList
    │       └── グループ化条件の選択肢を管理
    │
    ├── getReferersArr(dFrom, dUntill, total)
    │       └── tblSessionからリファラーデータ取得
    │
    ├── pageAction=Reset の場合
    │       ├── checkCSRF()
    │       └── removeReferers()
    │               └── tblSessionからデータ削除
    │
    └── groupByに応じた表示処理
            ├── sb_ref_LOGFILE → 全カラム表示
            └── その他 → グループ化集計表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索条件        ───▶ getReferersArr()     ───▶ リファラー配列
（groupBy, 期間）     （DB検索）
                      │
                      ▼
arrRef          ───▶ groupByに応じた      ───▶ refDict
（配列）              集計処理                   （辞書）
                      │
                      ▼
refDict         ───▶ for each ループ      ───▶ HTML出力
（辞書）              （HTML生成）

[リセット処理]

pageAction      ───▶ checkCSRF()          ───▶ 検証結果
= Reset               │
                      ▼
              ───▶ removeReferers()       ───▶ tblSession
                      （DELETE実行）            （削除）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_referers.asp | `asp/bs_referers.asp` | ソース | メイン画面処理 |
| bs_stats.asp | `asp/bs_stats.asp` | ソース | 統計画面 |
| includes/logvisit.asp | `asp/includes/logvisit.asp` | ソース | リファラー取得・削除関数 |
| includes/groupRefByList.asp | `asp/includes/groupRefByList.asp` | ソース | グループ化条件クラス |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダーメニュー |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
