# 画面設計書 97-フィードバック

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるフィードバック画面について記述する。bs_feedback.aspはユーザーフィードバックの表示・管理を行うための画面であるが、現在の実装では最小限の機能（フィード一覧への戻りリンク）のみが提供されている。

### 本画面の処理概要

本画面は、ユーザーからのフィードバック情報を表示・管理することを目的としているが、現在の実装ではフィード一覧画面（bs_feedList.asp）への戻りリンクのみが表示される簡易的な画面となっている。

**業務上の目的・背景**：Webサイトの改善にはユーザーからのフィードバックが重要である。本画面は将来的にユーザーフィードバックの収集・管理機能を提供することを想定しているが、現時点では基本的なナビゲーション機能のみの実装となっている。

**画面へのアクセス方法**：バックサイトのメニューまたは直接URLアクセス

**主要な操作・処理内容**：
1. フィード一覧画面への戻りリンク表示

**画面遷移**：
- 遷移元：bs_feedList.asp（フィード一覧）または直接アクセス
- 遷移先：bs_feedList.asp（フィード一覧）

**権限による表示制御**：
- 現在の実装では特別な権限チェックは行われていない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | アクセス統計表示 | 主機能 | ユーザーフィードバックの表示・管理 |
| 53 | フィード一覧 | 遷移先機能 | フィード一覧画面への遷移 |

## 画面種別

簡易表示画面（ナビゲーションのみ）

## URL/ルーティング

```
asp/bs_feedback.asp
```

## 入出力項目

本画面は入出力項目を持たない。

## 表示項目

### ナビゲーションリンク

| 項目名 | 遷移先 | 説明 |
|--------|--------|------|
| 戻るリンク | bs_feedList.asp | フィード一覧画面に戻る |

## イベント仕様

### 1-戻るリンククリック

「戻る」リンク（getArtLink関数で生成）をクリックすると、bs_feedList.asp（フィード一覧画面）に遷移する。

## データベース更新仕様

本画面はデータベースの参照・更新を行わない。

## メッセージ仕様

本画面は特別なメッセージを表示しない。

## 例外処理

本画面は特別な例外処理を持たない。

## 備考

- 現在の実装は最小限の機能のみ
- getArtLink関数でARTテーマ対応のリンクを生成
- 将来的にフィードバック機能が拡張される可能性がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面は現在データベースを使用していない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_feedback.asp | `asp/bs_feedback.asp` | 全体の処理フロー |

**読解のコツ**: 現在の実装は3行のみで、テーブル内にgetArtLink関数呼び出しがあるだけ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_feedback.asp | `asp/bs_feedback.asp` | HTML出力処理 |

**主要処理フロー**:
1. **行1**: 空行
2. **行2-3**: テーブルとgetArtLinkによるリンク生成

### プログラム呼び出し階層図

```
bs_feedback.asp
    │
    └── getArtLink("bs_feedList.asp", l("back"), "", "", "")
            └── ARTテーマ対応リンク生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

なし            ───▶ getArtLink()         ───▶ HTMLリンク
                      （リンク生成）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_feedback.asp | `asp/bs_feedback.asp` | ソース | メイン画面処理 |
| bs_feedList.asp | `asp/bs_feedList.asp` | ソース | フィード一覧画面（遷移先） |
