# 画面設計書 98-ショッピングカート管理

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるショッピングカート管理画面について記述する。bs_shoppingcart.aspはECサイト機能の商品・カテゴリ・メーカーを一覧表示し、管理するためのダッシュボード画面である。

### 本画面の処理概要

本画面は、ショッピングカート機能のメイン管理画面として、商品カテゴリ一覧、メーカー一覧、商品一覧を3カラムレイアウトで表示する。各一覧から詳細画面へ遷移でき、新規登録も可能である。

**業務上の目的・背景**：ECサイトを運営するためには、商品情報、カテゴリ分類、メーカー/ブランド情報を効率的に管理する必要がある。本画面は、これらの情報を一元的に表示・管理するためのダッシュボードを提供し、サイト管理者が商品管理業務を効率的に行えるようにする。

**画面へのアクセス方法**：バックサイトホーム → ショッピングカートメニュー、またはモジュールメニューからアクセス

**主要な操作・処理内容**：
1. 商品カテゴリ一覧の表示（階層構造対応）
2. メーカー一覧の表示
3. 全商品一覧の表示（メーカー名、各種操作ボタン付き）
4. 各一覧からの詳細/編集画面への遷移
5. 新規カテゴリ/メーカー/商品の作成画面への遷移

**画面遷移**：
- 遷移元：バックサイトホーム、モジュールメニュー
- 遷移先：bs_shopAdCat.asp（カテゴリ編集）、bs_shopMake.asp（メーカー編集）、bs_shopProduct.asp（商品編集）、bs_shopProductCat.asp（商品カテゴリ割当）、bs_shopProductImg.asp（商品画像管理）

**権限による表示制御**：
- secondAdmin.bShoppingCart権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 77 | ショッピングカート管理 | 主機能 | ECサイト機能の商品・カテゴリ管理 |
| 79 | 商品カテゴリ管理 | 遷移先機能 | カテゴリ編集画面への遷移 |
| 81 | メーカー管理 | 遷移先機能 | メーカー編集画面への遷移 |
| 78 | 商品管理 | 遷移先機能 | 商品編集画面への遷移 |
| 80 | 商品画像管理 | 遷移先機能 | 商品画像管理画面への遷移 |

## 画面種別

ダッシュボード画面（一覧集約）

## URL/ルーティング

```
asp/bs_shoppingcart.asp
```

## 入出力項目

本画面は入力項目を持たない（表示専用）。

## 表示項目

### カテゴリ一覧（左カラム）

| 項目名 | 説明 | データソース |
|--------|------|--------------|
| カテゴリ名 | 親カテゴリ名（リンク） | tblQShopCategory.sName |
| オフライン表示 | 非公開状態の表示 | tblQShopCategory.bOnline=false |
| サブカテゴリ一覧 | 子カテゴリの階層表示 | subcategories() |

### メーカー一覧（中央カラム）

| 項目名 | 説明 | データソース |
|--------|------|--------------|
| メーカー名 | メーカー名（リンク） | tblQShopMake.sName |
| オフライン表示 | 非公開状態の表示 | tblQShopMake.bOnline=false |

### 商品一覧（右カラム）

| 項目名 | 説明 | データソース |
|--------|------|--------------|
| 商品名 | 商品名（リンク） | tblQShopProduct.sName |
| メーカー名 | 商品のメーカー | tblQShopMake.sName（紐付け） |
| Editボタン | 商品編集画面へ | bs_shopProduct.asp |
| Categoriesボタン | カテゴリ割当画面へ | bs_shopProductCat.asp |
| Imagesボタン | 画像管理画面へ | bs_shopProductImg.asp |

### ナビゲーションボタン

| 項目名 | 遷移先 | 説明 |
|--------|--------|------|
| Shop Home | bs_shoppingcart.asp | ショップホームに戻る |
| Add Category | bs_shopAdCat.asp | 新規カテゴリ作成 |
| Add Make | bs_shopMake.asp | 新規メーカー作成 |
| Add Product | bs_shopProduct.asp | 新規商品作成 |

## イベント仕様

### 1-カテゴリ名リンククリック

カテゴリ名リンクをクリックすると、bs_shopAdCat.asp?iShopCatID={暗号化ID}に遷移し、該当カテゴリの編集画面が表示される。

### 2-メーカー名リンククリック

メーカー名リンクをクリックすると、bs_shopMake.asp?iShopMakeID={暗号化ID}に遷移し、該当メーカーの編集画面が表示される。

### 3-商品操作ボタンクリック

各商品行のボタンをクリックすると、対応する画面に遷移する。

## データベース更新仕様

本画面はデータベースの更新を行わない（参照のみ）。

### 参照テーブル

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblQShopCategory | SELECT | iCustomerID=cId AND iParentCatID IS NULL |
| tblQShopMake | SELECT | iCustomerID=cId |
| tblQShopProduct | SELECT | iCustomerID=cId（allproductsプロパティ） |

## メッセージ仕様

本画面は特別なメッセージを表示しない。

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | bs_security.aspで認証チェック、未認証時はnoaccess.htmにリダイレクト |
| 権限不足 | logon.hasaccess secondAdmin.bShoppingCartでアクセス拒否 |
| データなし | 空の一覧が表示される |

## 備考

- cls_shopCategoryクラスでカテゴリ情報を管理
- cls_shopMakeクラスでメーカー情報を管理
- cls_shopProductクラスで商品情報を管理
- encrypt関数でIDを暗号化してURLパラメータに使用
- sanitize関数でXSS対策を実施
- MYQS_offlineLinkColorでオフライン項目の色を設定
- bs_shoppingcartmenu.aspでメニューバーを共通化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ショッピングカート関連データはtblQShopCategory, tblQShopMake, tblQShopProductテーブルに格納される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblQShopCategory, tblQShopMake, tblQShopProduct（行33-36, 58-61） |
| 1-2 | shopCategory.asp | `asp/includes/shopCategory.asp` | cls_shopCategoryクラス |
| 1-3 | shopMake.asp | `asp/includes/shopMake.asp` | cls_shopMakeクラス |

**読解のコツ**: カテゴリは親子構造（iParentCatID）を持つ。subcategories()メソッドで子カテゴリを取得。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | 全体の処理フロー（行1-46） |

**主要処理フロー**:
1. **行1-4**: インクルードファイル読み込みと権限チェック
2. **行4-7**: cls_shopCategory, cls_shopMakeインスタンス作成と一覧取得
3. **行8-26**: カテゴリ一覧とメーカー一覧の表示
4. **行27-44**: 商品一覧の表示

#### Step 3: カテゴリ階層表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | 行8-19のfor each文 |
| 3-2 | shopCategory.asp | `asp/includes/shopCategory.asp` | listメソッド、subcategoriesメソッド |

**主要処理フロー**:
- **行8**: for each cat in catList
- **行9-10**: 親カテゴリの表示
- **行11**: subcategories()で子カテゴリ取得
- **行13-17**: for each subcatで子カテゴリ表示

#### Step 4: 商品一覧表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | 行27-44の商品一覧表示 |

**主要処理フロー**:
- **行27-29**: cls_shopProductインスタンス作成、allproducts取得
- **行30-43**: while not allproducts.eofでループ
- **行31**: encrypt(allproducts(0))でID暗号化
- **行33-41**: 商品情報とボタンのHTML出力

### プログラム呼び出し階層図

```
bs_shoppingcart.asp
    │
    ├── #include "begin.asp"
    │       └── 共通初期化処理
    │
    ├── #include "bs_security.asp"
    │       └── logon.hasaccess(secondAdmin.bShoppingCart)
    │
    ├── #include "bs_shoppingcartmenu.asp"
    │       └── ショッピングカートメニューバー
    │
    ├── cls_shopCategory
    │       ├── list
    │       │       └── 親カテゴリ一覧取得
    │       └── subcategories()
    │               └── 子カテゴリ一覧取得
    │
    ├── cls_shopMake
    │       └── list
    │               └── メーカー一覧取得
    │
    └── cls_shopProduct
            └── allproducts
                    └── 全商品一覧取得
```

### データフロー図

```
[入力]               [処理]                    [出力]

なし            ───▶ cls_shopCategory     ───▶ カテゴリ一覧
                      .list                      （親子構造）
                      │
                      ▼
              ───▶ cls_shopMake           ───▶ メーカー一覧
                      .list
                      │
                      ▼
              ───▶ cls_shopProduct        ───▶ 商品一覧
                      .allproducts
                      │
                      ▼
3データセット  ───▶ HTML生成              ───▶ 3カラムレイアウト
                      （for each ループ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | ソース | メイン画面処理 |
| bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | ソース | 共通メニューバー |
| bs_shopAdCat.asp | `asp/bs_shopAdCat.asp` | ソース | カテゴリ編集画面 |
| bs_shopMake.asp | `asp/bs_shopMake.asp` | ソース | メーカー編集画面 |
| bs_shopProduct.asp | `asp/bs_shopProduct.asp` | ソース | 商品編集画面 |
| bs_shopProductCat.asp | `asp/bs_shopProductCat.asp` | ソース | 商品カテゴリ割当画面 |
| bs_shopProductImg.asp | `asp/bs_shopProductImg.asp` | ソース | 商品画像管理画面 |
| includes/shopCategory.asp | `asp/includes/shopCategory.asp` | ソース | カテゴリクラス |
| includes/shopMake.asp | `asp/includes/shopMake.asp` | ソース | メーカークラス |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
