# 画面設計書 99-カテゴリ管理

## 概要

本ドキュメントは、QuickerSite CMSのバックサイト（管理画面）におけるカテゴリ管理画面について記述する。bs_shopAdCat.aspはショッピングカート機能の商品カテゴリを登録・編集・削除するための画面である。

### 本画面の処理概要

本画面は、ショッピングカートの商品カテゴリ情報をCRUD操作するための編集画面である。カテゴリ名、親カテゴリ、オンライン状態を設定でき、階層構造を持つカテゴリ管理が可能である。

**業務上の目的・背景**：ECサイトで商品を効率的に分類・管理するためには、カテゴリによる階層構造が必要である。本画面は、サイト管理者が商品カテゴリを作成・編集し、商品の分類体系を構築できるようにする。

**画面へのアクセス方法**：ショッピングカート管理画面（bs_shoppingcart.asp）のカテゴリ一覧からカテゴリ名をクリック、または「Add Category」ボタンをクリック

**主要な操作・処理内容**：
1. カテゴリ名の入力・編集
2. 親カテゴリの選択（階層構造設定）
3. オンライン/オフライン状態の設定
4. カテゴリ情報の保存
5. カテゴリの削除

**画面遷移**：
- 遷移元：bs_shoppingcart.asp（ショッピングカート管理）
- 遷移先：bs_shoppingcart.asp（保存/削除完了後）

**権限による表示制御**：
- secondAdmin.bShoppingCart権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | 商品カテゴリ管理 | 主機能 | カテゴリのCRUD操作 |
| 77 | ショッピングカート管理 | 遷移元/先 | ダッシュボードからの遷移 |

## 画面種別

編集画面（CRUD）

## URL/ルーティング

```
asp/bs_shopAdCat.asp
```

### URLパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| iShopCatID | String | 任意 | 暗号化されたカテゴリID（編集時） |

## 入出力項目

### 入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| カテゴリ名 | sName | text | * | 250 | カテゴリの表示名 |
| 親カテゴリ | iParentCatID | select | - | - | 階層構造の親カテゴリ |
| オンライン | bOnline | checkbox | - | - | 公開状態 |

### 隠しフィールド

| 項目名 | 項目ID | 説明 |
|--------|--------|------|
| カテゴリID | iShopCatID | 暗号化されたカテゴリID |
| ポストバック | postback | フォーム送信判定フラグ |
| CSRFトークン | QS_secCodeHidden | CSRF対策トークン |

## 表示項目

### フォーム項目

| 項目名 | 説明 | 表示条件 |
|--------|------|----------|
| Category name | カテゴリ名入力フィールド | 常時表示 |
| Parent Category | 親カテゴリ選択ドロップダウン | bShowParentCatDropDown=true |
| Online | オンライン状態チェックボックス | bShowOnlineCB=true |

### ボタン

| ボタン名 | 説明 | 表示条件 |
|----------|------|----------|
| Save | カテゴリ情報を保存 | 常時表示 |
| Delete | カテゴリを削除 | 既存カテゴリ編集時のみ |

## イベント仕様

### 1-保存ボタンクリック

**処理内容**：
1. フォーム入力値を取得
2. cls_shopCategoryオブジェクトにプロパティを設定
3. saveメソッドでデータベースに保存
4. 保存成功時、bs_shoppingcart.aspにリダイレクト

**バリデーション**：
- sName（カテゴリ名）が空の場合、エラーメッセージ「err_mandatory」を表示

### 2-削除ボタンクリック

**処理内容**：
1. JavaScriptで確認ダイアログを表示（「areyousure」）
2. 確認後、deleteメソッドでデータベースから削除
3. bs_shoppingcart.aspにリダイレクト

**削除時の関連データ処理**：
- 子カテゴリのiParentCatIDをnullに更新（親カテゴリ解除）
- tblQShopProdCatから該当カテゴリの商品紐付けを削除
- tblQShopCategoryから該当カテゴリを削除

## データベース更新仕様

### 新規作成（INSERT）

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblQShopCategory | INSERT | iIdがnullの場合 |

**設定フィールド**：
- sName: カテゴリ名（trim処理、最大255文字）
- bOnline: オンライン状態
- iParentCatID: 親カテゴリID（0の場合はnull）
- dCreatedTS: 作成日時（now()）
- dUpdatedTS: 更新日時（now()）
- iCustomerID: 顧客ID（cId）

### 更新（UPDATE）

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblQShopCategory | UPDATE | iId一致 |

**追加処理**：
- bOnline=falseの場合、子カテゴリのbOnlineも全てfalseに更新

### 削除（DELETE）

| テーブル名 | 操作 | 条件 |
|-----------|------|------|
| tblQShopCategory | UPDATE | iParentCatID=削除対象ID → null |
| tblQShopProdCat | DELETE | iCategoryID=削除対象ID |
| tblQShopCategory | DELETE | iId=削除対象ID |

## メッセージ仕様

| メッセージID | 表示条件 | メッセージ内容 |
|-------------|----------|---------------|
| err_mandatory | カテゴリ名が空 | 必須項目エラー |
| areyousure | 削除ボタンクリック時 | 確認ダイアログ |

## 例外処理

| 例外 | 処理内容 |
|------|----------|
| 未認証アクセス | bs_security.aspで認証チェック、未認証時はnoaccess.htmにリダイレクト |
| 権限不足 | logon.hasaccess secondAdmin.bShoppingCartでアクセス拒否 |
| 不正なID | decrypt失敗時、新規作成モードとして動作 |

## 備考

- cls_shopCategoryクラスでカテゴリ情報を管理
- encrypt/decrypt関数でIDを暗号化してURLパラメータに使用
- sanitize関数でXSS対策を実施
- QS_secCodeHiddenでCSRF対策を実施
- 親カテゴリがオフラインの場合、子カテゴリのオンラインチェックボックスは非表示
- 子カテゴリが存在する場合、親カテゴリドロップダウンは非表示（階層は2レベルまで）
- カテゴリ削除時、関連する商品-カテゴリ紐付け（tblQShopProdCat）も削除される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カテゴリデータはtblQShopCategoryテーブルに格納され、親子関係はiParentCatIDで表現される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | データベース設計書.md | `docs/code-to-docs/データベース設計書/データベース設計書.md` | tblQShopCategory, tblQShopProdCat（行35-36） |
| 1-2 | shopCategory.asp | `asp/includes/shopCategory.asp` | cls_shopCategoryクラス全体構造 |

**読解のコツ**: iParentCatIDがnullの場合は親カテゴリ、数値の場合は子カテゴリとなる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_shopAdCat.asp | `asp/bs_shopAdCat.asp` | 全体の処理フロー（行1-22） |

**主要処理フロー**:
1. **行1-4**: インクルードファイル読み込みと権限チェック
2. **行5-6**: cls_shopCategoryインスタンス作成、pick()でデータ取得
3. **行7-8**: postback判定
4. **行9-19**: postback時のsave/delete処理
5. **行20-21**: フォームHTML出力

#### Step 3: クラスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | shopCategory.asp | `asp/includes/shopCategory.asp` | Pickメソッド（行37-52） |
| 3-2 | shopCategory.asp | `asp/includes/shopCategory.asp` | Saveメソッド（行61-90） |
| 3-3 | shopCategory.asp | `asp/includes/shopCategory.asp` | Deleteメソッド（行91-95） |

**主要処理フロー（Save）**:
- **行63-68**: Checkメソッドでバリデーション
- **行69**: iParentCatIDが0の場合nullに変換
- **行70-86**: INSERT/UPDATE実行
- **行87-89**: オフライン時、子カテゴリも連動してオフラインに

**主要処理フロー（Delete）**:
- **行92**: 子カテゴリのiParentCatIDをnullに更新
- **行93**: tblQShopProdCatから紐付け削除
- **行94**: tblQShopCategoryから本体削除

#### Step 4: 表示制御ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | shopCategory.asp | `asp/includes/shopCategory.asp` | bShowParentCatDropDownプロパティ（行96-105） |
| 4-2 | shopCategory.asp | `asp/includes/shopCategory.asp` | bShowOnlineCBプロパティ（行106-119） |
| 4-3 | shopCategory.asp | `asp/includes/shopCategory.asp` | showParentCatメソッド（行120-144） |

**表示制御ロジック**:
- **bShowParentCatDropDown**: 子カテゴリが存在しない場合のみtrue
- **bShowOnlineCB**: 親カテゴリがオンラインの場合のみtrue

### プログラム呼び出し階層図

```
bs_shopAdCat.asp
    |
    +-- #include "begin.asp"
    |       +-- 共通初期化処理
    |
    +-- #include "bs_security.asp"
    |       +-- logon.hasaccess(secondAdmin.bShoppingCart)
    |
    +-- #include "bs_shoppingcartmenu.asp"
    |       +-- ショッピングカートメニューバー
    |
    +-- cls_shopCategory
            +-- pick(decrypt(iShopCatID))
            |       +-- SELECT from tblQShopCategory
            |
            +-- save()
            |       +-- Check() -> バリデーション
            |       +-- INSERT/UPDATE tblQShopCategory
            |       +-- UPDATE子カテゴリのbOnline（オフライン連動）
            |
            +-- delete()
            |       +-- UPDATE子カテゴリのiParentCatID=null
            |       +-- DELETE from tblQShopProdCat
            |       +-- DELETE from tblQShopCategory
            |
            +-- bShowParentCatDropDown
            |       +-- 子カテゴリ存在チェック
            |
            +-- bShowOnlineCB
            |       +-- 親カテゴリのbOnlineチェック
            |
            +-- showParentCat("option", selected)
                    +-- 親カテゴリ候補一覧生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

iShopCatID      ---> decrypt()           ---> 復号化されたID
(URLパラメータ)       |
                     v
                 pick(id)
                     |
                     v
              tblQShopCategory  <--------->  カテゴリデータ
                     |
                     v
             フォーム表示  <--------------  bShowParentCatDropDown
                     |                      bShowOnlineCB
                     |                      showParentCat()
                     v
[フォーム送信]
     |
     v
sName, iParentCatID, bOnline
     |
     +--[Save]--> Check() --> save()
     |                          |
     |                          v
     |                    INSERT/UPDATE
     |                    tblQShopCategory
     |                          |
     |                          v
     |                    子カテゴリ連動更新
     |
     +--[Delete]--> delete()
                       |
                       v
                 1. 子カテゴリ親解除
                 2. 商品紐付け削除
                 3. カテゴリ削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_shopAdCat.asp | `asp/bs_shopAdCat.asp` | ソース | メイン画面処理 |
| shopCategory.asp | `asp/includes/shopCategory.asp` | ソース | カテゴリクラス |
| bs_shoppingcart.asp | `asp/bs_shoppingcart.asp` | ソース | 遷移元/先画面 |
| bs_shoppingcartmenu.asp | `asp/bs_shoppingcartmenu.asp` | ソース | 共通メニューバー |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限制御 |
| includes/header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| includes/footer.asp | `asp/includes/footer.asp` | テンプレート | HTMLフッター |
