---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：1-バックサイトログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **メール通知の詳細仕様**：dumpError関数の動作詳細が不明
  2. **CAPTCHA画像生成ロジック**：captcha.aspの内部実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_login.asp` 行1-29
- E-02: `asp/includes/logonEdit.asp` 行1-241
- E-03: `asp/includes/customer.asp` 行1-200
- E-04: `asp/bs_security.asp` 行1-79
- E-05: `asp/begin.asp` 行1-204
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 行2
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行2-4
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` 行18-36

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/bs_login.asp である | E-06 | ○ |
| C-02 | CAPTCHA認証が必須である | E-01 行9-11, E-07 | ○ |
| C-03 | パスワードはSHA256でハッシュ化される | E-01 行12, E-02 行25 | ○ |
| C-04 | ログイン成功時はbs_default.aspへリダイレクト | E-01 行14 | ○ |
| C-05 | bs_pageパラメータで遷移先を指定可能 | E-01 行13-19 | ○ |
| C-06 | ログイン試行回数がApplication変数で管理される | E-01 行24, E-02 行41 | ○ |
| C-07 | lockBSAdmin関数でIPブロックを実行 | E-01 行26, E-02 行86-98 | ○ |
| C-08 | QS_number_of_allowed_attempts_to_loginで試行上限を設定 | E-02 行87 | ○ |
| C-09 | セカンド管理者フラグが別途管理される | E-02 行33-35 | ○ |
| C-10 | CAPTCHAは大文字小文字を区別しない | E-01 行9（LCase使用） | ○ |
| C-11 | CAPTCHA入力は先頭4文字のみ検証される | E-01 行9（Left関数） | ○ |
| C-12 | デフォルトパスワードは"admin"である | E-01 行8（QS_defaultPW参照） | ○ |
| C-13 | デフォルトパスワード使用時は警告表示 | E-01 行28 | ○ |
| C-14 | パスワード入力フィールドのmaxlengthは50 | E-01 行28 | ○ |
| C-15 | CAPTCHA入力フィールドのmaxlengthは4 | E-01 行28 | ○ |
| C-16 | Cookie認証モードが存在する | E-02 行29-31, E-04 行8-9 | ○ |
| C-17 | 認証成功時にApplication変数がリセットされる | E-02 行41 | ○ |
| C-18 | bs_initBackShort.aspがインクルードされる | E-01 行8 | ○ |
| C-19 | contactEdit.aspへの遷移時に特別処理がある | E-01 行16-18 | ○ |
| C-20 | 多言語対応されている（l関数使用） | E-01 行28 | ○ |
| C-21 | bUseArtLoginTemplateがtrue設定 | E-01 行4 | ○ |
| C-22 | err_captchaエラーコードが使用される | E-01 行11 | ○ |
| C-23 | err_loginエラーコードが使用される | E-01 行22 | ○ |
| C-24 | bs_endBack.aspでページが閉じられる | E-01 行28 | ○ |
| C-25 | 認証状態はSession変数で管理される | E-02 行27, 34 | ○ |
| C-26 | フォームのname属性はmainform | E-01 行28 | ○ |
| C-27 | ブロック時にメール通知される | E-02 行77-80 | △ |
| C-28 | captcha.aspが画像を生成する | E-01 行28（参照あり） | △ |

## 4) 不足情報（Unknown / Missing）
- captcha.aspの内部実装（画像生成ロジック）が未確認
  - 候補：`asp/includes/captcha.asp` / セッション保存ロジック / 画像生成ライブラリ
- dumpError関数のメール送信詳細が未確認
  - 候補：`asp/includes/functions.asp` / SMTPサーバー設定 / メールテンプレート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、入力項目、基本フローは実装と一致
- 0: 低リスク - 認証ロジックはソースコードで確認済み
- 1: 中リスク - メール通知機能の動作確認が必要
- 1: 中リスク - CAPTCHA画像生成の実装詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] bs_login.aspの処理フローが設計書と一致しているか確認
- [ ] logonEdit.aspのlogon関数の認証ロジックを確認
- [ ] lockBSAdmin関数のブロック条件を確認
- [ ] CAPTCHA認証の実際の動作を確認
- [ ] デフォルトパスワード警告の表示条件を確認
- [ ] セカンド管理者ログイン時の動作差異を確認
