---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-リストアイテム編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - なし（全項目で根拠確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editListItem.asp` 行1-36
- E-02: `asp/bs_processPage.asp` 行1-50
- E-03: `asp/includes/page.asp` 行1-500
- E-04: `asp/includes/functions.asp` 行1-300
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 行11
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行18
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` 行160-180

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは asp/bs_editListItem.asp である | E-05 | ○ |
| C-02 | bs_security.aspで認証チェック | E-01 行2 | ○ |
| C-03 | bs_process.aspをインクルード | E-01 行3 | ○ |
| C-04 | bs_processPage.aspで保存処理 | E-01 行7 | ○ |
| C-05 | QS_secCodeHiddenでCSRFトークン | E-01 行8 | ○ |
| C-06 | iIdをHiddenで暗号化して渡す | E-01 行8 | ○ |
| C-07 | iListPageIDをHiddenで暗号化して渡す | E-01 行9 | ○ |
| C-08 | bLossePaginaをfalseで固定 | E-01 行9 | ○ |
| C-09 | btnactionがsave_listitemで設定 | E-01 行8 | ○ |
| C-10 | page.listPage.sTitleで親リストページ表示 | E-01 行11 | ○ |
| C-11 | sTitleをmaxlength=255、size=45で入力 | E-01 行12 | ○ |
| C-12 | bs_preview.aspでプレビューリンク | E-01 行13 | ○ |
| C-13 | dPageをJQDatePickerで日付入力 | E-01 行14 | ○ |
| C-14 | dOnlineFromをJQDatePickerで日付入力 | E-01 行15 | ○ |
| C-15 | dOnlineUntillをJQDatePickerで日付入力 | E-01 行16 | ○ |
| C-16 | convertEuroDateで日付フォーマット | E-01 行14-16 | ○ |
| C-17 | 外部URL表示条件が複雑 | E-01 行17 | ○ |
| C-18 | sLPExternalURLをmaxlength=255、size=45で入力 | E-01 行18 | ○ |
| C-19 | bLPExternalOINWでチェックボックス | E-01 行19 | ○ |
| C-20 | 本文エディタ表示条件判定 | E-01 行20 | ○ |
| C-21 | bs_feed.aspでフィード選択 | E-01 行21 | ○ |
| C-22 | createFCKInstanceでWYSIWYGエディタ生成 | E-01 行23 | ○ |
| C-23 | customer.bUserFriendlyURLでURL機能判定 | E-01 行24 | ○ |
| C-24 | secondAdmin.bPageUFLで権限チェック | E-01 行24 | ○ |
| C-25 | sUserFriendlyURLをmaxlength=49で入力 | E-01 行25 | ○ |
| C-26 | customer.sVDUrlでURL接頭辞表示 | E-01 行25 | ○ |
| C-27 | l("mandatory")で必須説明表示 | E-01 行31 | ○ |
| C-28 | type=submitで保存ボタン | E-01 行32 | ○ |
| C-29 | type=resetでリセットボタン | E-01 行32 | ○ |
| C-30 | bs_deleteButtonList.aspで削除ボタン | E-01 行33 | ○ |
| C-31 | bs_convertToItemWithContent.aspで変換リンク | E-01 行34 | ○ |
| C-32 | bs_listPage.aspへの戻るリンク | E-01 行35 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成、フォーム項目、処理フローが実装と一致
- 0: 低リスク - CSRFトークンが実装されている
- 0: 低リスク - 条件付き表示ロジックが実装されている
- 0: 低リスク - 全項目で根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] bs_editListItem.aspの画面構成が設計書と一致しているか確認
- [ ] 外部URL表示条件（行17）の動作を確認
- [ ] 本文エディタ表示条件（行20）の動作を確認
- [ ] JQDatePickerの動作を確認
- [ ] WYSIWYGエディタ（createFCKInstance）の動作を確認
- [ ] ユーザーフレンドリーURL条件（bUserFriendlyURL、bPageUFL）を確認
- [ ] 保存処理（bs_processPage.asp）の動作を確認
- [ ] 削除ボタン（bs_deleteButtonList.asp）の動作を確認
